/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URISyntaxException;
import java.util.Set;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiEndpoint;
import org.apache.servicemix.camel.JbiException;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.id.IdGenerator;

public class CamelConsumerEndpoint
extends ConsumerEndpoint
implements AsyncProcessor {
    public static final QName SERVICE_NAME = new QName("http://activemq.apache.org/camel/schema/jbi", "consumer");
    private JbiBinding binding;
    private JbiEndpoint jbiEndpoint;

    public CamelConsumerEndpoint(JbiBinding binding, JbiEndpoint jbiEndpoint) {
        this.setService(SERVICE_NAME);
        this.setEndpoint(new IdGenerator().generateId());
        this.binding = binding;
        this.jbiEndpoint = jbiEndpoint;
    }

    public void process(MessageExchange messageExchange) throws Exception {
        Exchange exchange = (Exchange)messageExchange.getProperty(Exchange.class.getName());
        AsyncCallback asyncCallback = (AsyncCallback)messageExchange.getProperty(AsyncCallback.class.getName());
        if (messageExchange.getStatus() == ExchangeStatus.ERROR) {
            exchange.setException((Throwable)messageExchange.getError());
        } else if (messageExchange.getStatus() == ExchangeStatus.ACTIVE) {
            this.addHeaders(messageExchange, exchange);
            if (messageExchange.getFault() != null) {
                exchange.getFault().setBody((Object)messageExchange.getFault().getContent());
                this.addHeaders((NormalizedMessage)messageExchange.getFault(), exchange.getFault());
                this.addAttachments((NormalizedMessage)messageExchange.getFault(), exchange.getFault());
            } else {
                exchange.getOut().setBody((Object)messageExchange.getMessage("out").getContent());
                this.addHeaders(messageExchange.getMessage("out"), exchange.getOut());
                this.addAttachments(messageExchange.getMessage("out"), exchange.getOut());
            }
            this.done(messageExchange);
        }
        asyncCallback.done(false);
    }

    public boolean process(Exchange exchange, AsyncCallback asyncCallback) {
        try {
            MessageExchange messageExchange = this.binding.makeJbiMessageExchange(exchange, this.getExchangeFactory(), this.jbiEndpoint.getMep());
            if (this.jbiEndpoint.getOperation() != null) {
                messageExchange.setOperation(QName.valueOf(this.jbiEndpoint.getOperation()));
            }
            URIResolver.configureExchange((MessageExchange)messageExchange, (ComponentContext)this.getContext(), (String)this.jbiEndpoint.getDestinationUri());
            messageExchange.setProperty(Exchange.class.getName(), (Object)exchange);
            messageExchange.setProperty(AsyncCallback.class.getName(), (Object)asyncCallback);
            this.send(messageExchange);
            return false;
        }
        catch (MessagingException e) {
            throw new JbiException(e);
        }
        catch (URISyntaxException e) {
            throw new JbiException(e);
        }
    }

    public void process(Exchange exchange) throws Exception {
        try {
            MessageExchange messageExchange = this.binding.makeJbiMessageExchange(exchange, this.getExchangeFactory(), this.jbiEndpoint.getMep());
            if (this.jbiEndpoint.getOperation() != null) {
                messageExchange.setOperation(QName.valueOf(this.jbiEndpoint.getOperation()));
            }
            URIResolver.configureExchange((MessageExchange)messageExchange, (ComponentContext)this.getContext(), (String)this.jbiEndpoint.getDestinationUri());
            this.sendSync(messageExchange);
            if (messageExchange.getStatus() == ExchangeStatus.ERROR) {
                exchange.setException((Throwable)messageExchange.getError());
            } else if (messageExchange.getStatus() == ExchangeStatus.ACTIVE) {
                this.addHeaders(messageExchange, exchange);
                if (messageExchange.getFault() != null) {
                    exchange.getFault().setBody((Object)messageExchange.getFault().getContent());
                    this.addHeaders((NormalizedMessage)messageExchange.getFault(), exchange.getFault());
                    this.addAttachments((NormalizedMessage)messageExchange.getFault(), exchange.getFault());
                } else {
                    exchange.getOut().setBody((Object)messageExchange.getMessage("out").getContent());
                    this.addHeaders(messageExchange.getMessage("out"), exchange.getOut());
                    this.addAttachments(messageExchange.getMessage("out"), exchange.getOut());
                }
                this.done(messageExchange);
            }
        }
        catch (MessagingException e) {
            throw new JbiException(e);
        }
        catch (URISyntaxException e) {
            throw new JbiException(e);
        }
    }

    public void validate() throws DeploymentException {
    }

    private void addHeaders(MessageExchange messageExchange, Exchange camelExchange) {
        Set entries = messageExchange.getPropertyNames();
        for (Object o : entries) {
            String key = o.toString();
            camelExchange.setProperty(key, messageExchange.getProperty(key));
        }
    }

    private void addHeaders(NormalizedMessage normalizedMessage, Message camelMessage) {
        Set entries = normalizedMessage.getPropertyNames();
        for (Object o : entries) {
            String key = o.toString();
            camelMessage.setHeader(key, normalizedMessage.getProperty(key));
        }
    }

    private void addAttachments(NormalizedMessage normalizedMessage, Message camelMessage) {
        Set entries = normalizedMessage.getAttachmentNames();
        for (Object o : entries) {
            String id = o.toString();
            camelMessage.addAttachment(id, normalizedMessage.getAttachment(id));
        }
    }
}

