/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.jms.endpoints.DefaultConsumerMarshaler;
import org.apache.servicemix.jms.endpoints.DestinationChooser;
import org.apache.servicemix.jms.endpoints.JmsConsumerMarshaler;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreFactory;
import org.apache.servicemix.store.memory.MemoryStoreFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.JmsTemplate102;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.listener.adapter.ListenerExecutionFailedException;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConsumerEndpoint
extends ConsumerEndpoint {
    protected static final String PROP_JMS_CONTEXT = JmsConsumerMarshaler.JmsContext.class.getName();
    private JmsConsumerMarshaler marshaler = new DefaultConsumerMarshaler();
    private boolean synchronous = true;
    private DestinationChooser destinationChooser;
    private DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private boolean pubSubDomain;
    private ConnectionFactory connectionFactory;
    private JmsTemplate template;
    private Boolean useMessageIdInResponse;
    private Destination replyDestination;
    private String replyDestinationName;
    private boolean replyExplicitQosEnabled;
    private int replyDeliveryMode = 2;
    private int replyPriority = 4;
    private long replyTimeToLive = 0L;
    private Map<String, Object> replyProperties;
    private boolean stateless;
    private StoreFactory storeFactory;
    private Store store;
    private boolean jms102;

    public AbstractConsumerEndpoint() {
    }

    public AbstractConsumerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public AbstractConsumerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public DestinationChooser getDestinationChooser() {
        return this.destinationChooser;
    }

    public void setDestinationChooser(DestinationChooser destinationChooser) {
        this.destinationChooser = destinationChooser;
    }

    public int getReplyDeliveryMode() {
        return this.replyDeliveryMode;
    }

    public void setReplyDeliveryMode(int replyDeliveryMode) {
        this.replyDeliveryMode = replyDeliveryMode;
    }

    public Destination getReplyDestination() {
        return this.replyDestination;
    }

    public void setReplyDestination(Destination replyDestination) {
        this.replyDestination = replyDestination;
    }

    public String getReplyDestinationName() {
        return this.replyDestinationName;
    }

    public void setReplyDestinationName(String replyDestinationName) {
        this.replyDestinationName = replyDestinationName;
    }

    public boolean isReplyExplicitQosEnabled() {
        return this.replyExplicitQosEnabled;
    }

    public void setReplyExplicitQosEnabled(boolean replyExplicitQosEnabled) {
        this.replyExplicitQosEnabled = replyExplicitQosEnabled;
    }

    public int getReplyPriority() {
        return this.replyPriority;
    }

    public void setReplyPriority(int replyPriority) {
        this.replyPriority = replyPriority;
    }

    public Map<String, Object> getReplyProperties() {
        return this.replyProperties;
    }

    public void setReplyProperties(Map<String, Object> replyProperties) {
        this.replyProperties = replyProperties;
    }

    public long getReplyTimeToLive() {
        return this.replyTimeToLive;
    }

    public void setReplyTimeToLive(long replyTimeToLive) {
        this.replyTimeToLive = replyTimeToLive;
    }

    public Boolean getUseMessageIdInResponse() {
        return this.useMessageIdInResponse;
    }

    public void setUseMessageIdInResponse(Boolean useMessageIdInResponse) {
        this.useMessageIdInResponse = useMessageIdInResponse;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public JmsConsumerMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsConsumerMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public void setStateless(boolean stateless) {
        this.stateless = stateless;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setStoreFactory(StoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    public String getLocationURI() {
        return this.getService() + "#" + this.getEndpoint();
    }

    public synchronized void activate() throws Exception {
        super.activate();
        if (this.template == null) {
            this.template = this.isJms102() ? new JmsTemplate102(this.getConnectionFactory(), this.isPubSubDomain()) : new JmsTemplate(this.getConnectionFactory());
        }
        if (this.store == null && !this.stateless) {
            if (this.storeFactory == null) {
                this.storeFactory = new MemoryStoreFactory();
            }
            this.store = this.storeFactory.open(this.getService().toString() + this.getEndpoint());
        }
    }

    public synchronized void deactivate() throws Exception {
        if (this.store != null) {
            if (this.storeFactory != null) {
                this.storeFactory.close(this.store);
            }
            this.store = null;
        }
        super.deactivate();
    }

    public void process(MessageExchange exchange) throws Exception {
        JmsConsumerMarshaler.JmsContext context = this.stateless ? (JmsConsumerMarshaler.JmsContext)exchange.getProperty(PROP_JMS_CONTEXT) : (JmsConsumerMarshaler.JmsContext)this.store.load(exchange.getExchangeId());
        this.processExchange(exchange, null, context);
    }

    protected void processExchange(final MessageExchange exchange, Session session, final JmsConsumerMarshaler.JmsContext context) throws Exception {
        if (exchange instanceof InOnly) {
            if (exchange.isTransacted() && ExchangeStatus.ERROR.equals(exchange.getStatus())) {
                throw exchange.getError();
            }
            return;
        }
        if (session == null) {
            this.template.execute(new SessionCallback(){

                public Object doInJms(Session session) throws JMSException {
                    try {
                        AbstractConsumerEndpoint.this.processExchange(exchange, session, context);
                    }
                    catch (Exception e) {
                        throw new ListenerExecutionFailedException("Exchange processing failed", (Throwable)e);
                    }
                    return null;
                }
            });
            return;
        }
        Message msg = null;
        Destination dest = null;
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            if (exchange.getFault() != null) {
                msg = this.marshaler.createFault(exchange, exchange.getFault(), session, context);
                dest = this.getReplyDestination(exchange, exchange.getFault(), session, context);
            } else if (exchange.getMessage("out") != null) {
                msg = this.marshaler.createOut(exchange, exchange.getMessage("out"), session, context);
                dest = this.getReplyDestination(exchange, exchange.getMessage("out"), session, context);
            }
            if (msg == null) {
                throw new IllegalStateException("Unable to send back answer or fault");
            }
            this.setCorrelationId(context.getMessage(), msg);
            try {
                this.send(msg, session, dest);
                this.done(exchange);
            }
            catch (Exception e) {
                this.fail(exchange, e);
                throw e;
            }
        } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
            Exception error = exchange.getError();
            if (error == null) {
                error = new JBIException("Exchange in ERROR state, but no exception provided");
            }
            msg = this.marshaler.createError(exchange, error, session, context);
            dest = this.getReplyDestination(exchange, error, session, context);
            this.setCorrelationId(context.getMessage(), msg);
            this.send(msg, session, dest);
        } else if (exchange.getStatus() == ExchangeStatus.DONE) {
            msg = session.createMessage();
            msg.setBooleanProperty("JBIDone", true);
            this.send(msg, session, dest);
        } else {
            throw new IllegalStateException("Unrecognized exchange status");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(Message msg, Session session, Destination dest) throws JMSException {
        Object producer = this.isJms102() ? (this.isPubSubDomain() ? ((TopicSession)session).createPublisher((Topic)dest) : ((QueueSession)session).createSender((Queue)dest)) : session.createProducer(dest);
        try {
            if (this.replyProperties != null) {
                for (Map.Entry<String, Object> e : this.replyProperties.entrySet()) {
                    msg.setObjectProperty(e.getKey(), e.getValue());
                }
            }
            if (this.isJms102()) {
                if (this.isPubSubDomain()) {
                    if (this.replyExplicitQosEnabled) {
                        ((TopicPublisher)producer).publish(msg, this.replyDeliveryMode, this.replyPriority, this.replyTimeToLive);
                    } else {
                        ((TopicPublisher)producer).publish(msg);
                    }
                } else if (this.replyExplicitQosEnabled) {
                    ((QueueSender)producer).send(msg, this.replyDeliveryMode, this.replyPriority, this.replyTimeToLive);
                } else {
                    ((QueueSender)producer).send(msg);
                }
            } else if (this.replyExplicitQosEnabled) {
                producer.send(msg, this.replyDeliveryMode, this.replyPriority, this.replyTimeToLive);
            } else {
                producer.send(msg);
            }
        }
        finally {
            JmsUtils.closeMessageProducer((MessageProducer)producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessage(Message jmsMessage, Session session) throws JMSException {
        block16: {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Received: " + jmsMessage));
            }
            JmsConsumerMarshaler.JmsContext context = null;
            MessageExchange exchange = null;
            try {
                context = this.marshaler.createContext(jmsMessage);
                exchange = this.marshaler.createExchange(context, this.getContext());
                this.configureExchangeTarget(exchange);
                if (this.synchronous) {
                    try {
                        this.sendSync(exchange);
                    }
                    catch (Exception e) {
                        this.handleException(exchange, e, session, context);
                    }
                    this.processExchange(exchange, session, context);
                    break block16;
                }
                if (this.stateless) {
                    exchange.setProperty(PROP_JMS_CONTEXT, (Object)context);
                } else {
                    this.store.store(exchange.getExchangeId(), (Object)context);
                }
                boolean success = false;
                try {
                    this.send(exchange);
                    success = true;
                }
                catch (Exception e) {
                    this.handleException(exchange, e, session, context);
                }
                finally {
                    if (!success && !this.stateless) {
                        this.store.load(exchange.getExchangeId());
                    }
                }
            }
            catch (Exception e) {
                try {
                    this.handleException(exchange, e, session, context);
                }
                catch (Exception e1) {
                    throw (JMSException)new JMSException("Error sending JBI exchange").initCause((Throwable)e);
                }
            }
        }
    }

    protected Destination getReplyDestination(MessageExchange exchange, Object message, Session session, JmsConsumerMarshaler.JmsContext context) throws JMSException {
        if (context.getMessage().getJMSReplyTo() != null) {
            return context.getMessage().getJMSReplyTo();
        }
        Object dest = null;
        if (this.destinationChooser != null) {
            dest = this.destinationChooser.chooseDestination(exchange, message);
        }
        if (dest == null) {
            dest = this.replyDestination;
        }
        if (dest == null) {
            dest = this.replyDestinationName;
        }
        if (dest instanceof Destination) {
            return dest;
        }
        if (dest instanceof String) {
            return this.destinationResolver.resolveDestinationName(session, (String)dest, this.isPubSubDomain());
        }
        throw new IllegalStateException("Unable to choose destination for exchange " + exchange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setCorrelationId(Message query, Message reply) throws Exception {
        if (this.useMessageIdInResponse == null) {
            if (query.getJMSCorrelationID() != null) {
                reply.setJMSCorrelationID(query.getJMSCorrelationID());
                return;
            } else {
                if (query.getJMSMessageID() == null) throw new IllegalStateException("No JMSCorrelationID or JMSMessageID set on query message");
                reply.setJMSCorrelationID(query.getJMSMessageID());
            }
            return;
        } else if (this.useMessageIdInResponse.booleanValue()) {
            if (query.getJMSMessageID() == null) throw new IllegalStateException("No JMSMessageID set on query message");
            reply.setJMSCorrelationID(query.getJMSMessageID());
            return;
        } else {
            if (query.getJMSCorrelationID() == null) throw new IllegalStateException("No JMSCorrelationID set on query message");
            reply.setJMSCorrelationID(query.getJMSCorrelationID());
        }
    }

    protected void handleException(MessageExchange exchange, Exception error, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        if (exchange instanceof InOnly) {
            throw error;
        }
        if (!this.treatExceptionAsFault(error)) {
            throw error;
        }
        this.sendError(exchange, error, session, context);
    }

    protected boolean treatExceptionAsFault(Exception error) {
        return error instanceof SecurityException;
    }

    protected void sendError(final MessageExchange exchange, final Exception error, Session session, final JmsConsumerMarshaler.JmsContext context) throws Exception {
        if (session == null) {
            this.template.execute(new SessionCallback(){

                public Object doInJms(Session session) throws JMSException {
                    try {
                        AbstractConsumerEndpoint.this.sendError(exchange, error, session, context);
                    }
                    catch (Exception e) {
                        throw new ListenerExecutionFailedException("Exchange processing failed", (Throwable)e);
                    }
                    return null;
                }
            });
            return;
        }
        Message msg = this.marshaler.createError(exchange, error, session, context);
        Destination dest = this.getReplyDestination(exchange, error, session, context);
        this.setCorrelationId(context.getMessage(), msg);
        this.send(msg, session, dest);
    }

    public boolean isJms102() {
        return this.jms102;
    }

    public void setJms102(boolean jms102) {
        this.jms102 = jms102;
    }
}

