/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import java.util.Timer;
import javax.jbi.management.DeploymentException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.WorkManagerWrapper;
import org.apache.servicemix.jms.JmsEndpointType;
import org.apache.servicemix.jms.endpoints.AbstractConsumerEndpoint;
import org.jencks.SingletonEndpointFactory;
import org.springframework.jms.listener.adapter.ListenerExecutionFailedException;

public class JmsJcaConsumerEndpoint
extends AbstractConsumerEndpoint
implements JmsEndpointType {
    private ResourceAdapter resourceAdapter;
    private ActivationSpec activationSpec;
    private BootstrapContext bootstrapContext;
    private MessageEndpointFactory endpointFactory;

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this.activationSpec = activationSpec;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public String getLocationURI() {
        return this.getService() + "#" + this.getEndpoint();
    }

    public synchronized void start() throws Exception {
        if (this.bootstrapContext == null) {
            Executor executor = this.getServiceUnit().getComponent().getExecutor();
            WorkManagerWrapper wm = new WorkManagerWrapper(executor);
            this.bootstrapContext = new SimpleBootstrapContext((WorkManager)wm);
        }
        this.resourceAdapter.start(this.bootstrapContext);
        this.activationSpec.setResourceAdapter(this.resourceAdapter);
        if (this.endpointFactory == null) {
            TransactionManager tm = (TransactionManager)this.getContext().getTransactionManager();
            this.endpointFactory = new SingletonEndpointFactory(new MessageListener(){

                public void onMessage(Message message) {
                    try {
                        JmsJcaConsumerEndpoint.this.onMessage(message, null);
                    }
                    catch (JMSException e) {
                        throw new ListenerExecutionFailedException("Unable to handle message", (Throwable)e);
                    }
                }
            }, tm);
        }
        this.resourceAdapter.endpointActivation(this.endpointFactory, this.activationSpec);
        super.start();
    }

    public synchronized void stop() throws Exception {
        this.resourceAdapter.endpointDeactivation(this.endpointFactory, this.activationSpec);
        this.resourceAdapter.stop();
        super.stop();
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.resourceAdapter == null) {
            throw new DeploymentException("resourceAdapter must be set");
        }
        if (this.activationSpec == null) {
            throw new DeploymentException("activationSpec must be set");
        }
    }

    protected static class SimpleBootstrapContext
    implements BootstrapContext {
        private final WorkManager workManager;

        public SimpleBootstrapContext(WorkManager workManager) {
            this.workManager = workManager;
        }

        public Timer createTimer() throws UnavailableException {
            throw new UnsupportedOperationException();
        }

        public WorkManager getWorkManager() {
            return this.workManager;
        }

        public XATerminator getXATerminator() {
            throw new UnsupportedOperationException();
        }
    }
}

