/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import org.apache.camel.Processor;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.spi.InterceptStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationInterceptStrategy
implements InterceptStrategy {
    private Map<ProcessorType, PerformanceCounter> counterMap;

    public InstrumentationInterceptStrategy(Map<ProcessorType, PerformanceCounter> counterMap) {
        this.counterMap = counterMap;
    }

    @Override
    public Processor wrapProcessorInInterceptors(ProcessorType processorType, Processor target) throws Exception {
        Processor retval = target;
        PerformanceCounter counter = this.counterMap.get(processorType);
        if (counter != null) {
            InstrumentationProcessor wrapper = new InstrumentationProcessor(counter);
            wrapper.setProcessor(target);
            retval = wrapper;
        }
        return retval;
    }
}

