/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.common.locks.LockManager;
import org.apache.servicemix.common.locks.impl.SimpleLockManager;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.file.FileEndpointType;
import org.apache.servicemix.util.FileUtil;

public class FilePollerEndpoint
extends PollingEndpoint
implements FileEndpointType {
    private File file;
    private FileFilter filter;
    private boolean deleteFile = true;
    private boolean recursive = true;
    private boolean autoCreateDirectory = true;
    private File archive;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private LockManager lockManager;
    private ConcurrentMap<String, InputStream> openExchanges = new ConcurrentHashMap<String, InputStream>();

    public FilePollerEndpoint() {
    }

    public FilePollerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public FilePollerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public synchronized void start() throws Exception {
        super.start();
        this.openExchanges = new ConcurrentHashMap<String, InputStream>();
    }

    public void poll() throws Exception {
        this.pollFileOrDirectory(this.file);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.file == null) {
            throw new DeploymentException("You must specify a file property");
        }
        if (this.isAutoCreateDirectory() && !this.file.exists()) {
            this.file.mkdirs();
        }
        if (this.archive != null) {
            if (!this.deleteFile) {
                throw new DeploymentException("Archive shouldn't be specified unless deleteFile='true'");
            }
            if (this.isAutoCreateDirectory() && !this.archive.exists()) {
                this.archive.mkdirs();
            }
            if (!this.archive.isDirectory()) {
                throw new DeploymentException("Archive should refer to a directory");
            }
        }
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager();
        }
    }

    protected LockManager createLockManager() {
        return new SimpleLockManager();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public File getArchive() {
        return this.archive;
    }

    protected void pollFileOrDirectory(File fileOrDirectory) {
        this.pollFileOrDirectory(fileOrDirectory, true);
    }

    protected void pollFileOrDirectory(File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            this.logger.debug((Object)("Polling directory " + fileOrDirectory));
            File[] files = fileOrDirectory.listFiles(this.getFilter());
            for (int i = 0; i < files.length; ++i) {
                this.pollFileOrDirectory(files[i], this.isRecursive());
            }
        } else {
            this.logger.debug((Object)("Skipping directory " + fileOrDirectory));
        }
    }

    protected void pollFile(final File aFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Scheduling file " + aFile + " for processing"));
        }
        if (!FileUtil.isFileFullyAvailable((File)aFile)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The file " + aFile + " is still being copied. Skipping..."));
            }
            return;
        }
        this.getExecutor().execute(new Runnable(){

            public void run() {
                String uri = FilePollerEndpoint.this.file.toURI().relativize(aFile.toURI()).toString();
                Lock lock = FilePollerEndpoint.this.lockManager.getLock(uri);
                if (lock.tryLock()) {
                    FilePollerEndpoint.this.processFileNow(aFile);
                } else if (FilePollerEndpoint.this.logger.isDebugEnabled()) {
                    FilePollerEndpoint.this.logger.debug((Object)("Unable to acquire lock on " + aFile));
                }
            }
        });
    }

    protected void processFileNow(File aFile) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing file " + aFile));
            }
            if (aFile.exists()) {
                this.processFile(aFile);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to process file: " + aFile + ". Reason: " + e), (Throwable)e);
        }
    }

    protected void processFile(File file) throws Exception {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        this.configureExchangeTarget((MessageExchange)exchange);
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        this.marshaler.readMessage((MessageExchange)exchange, message, (InputStream)stream, file.getCanonicalPath());
        exchange.getInMessage().setProperty("org.apache.servicemix.file", (Object)file);
        this.openExchanges.put(exchange.getExchangeId(), stream);
        this.send((MessageExchange)exchange);
    }

    public String getLocationURI() {
        return this.file.toURI().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageExchange exchange) throws Exception {
        if (this.openExchanges.containsKey(exchange.getExchangeId())) {
            InputStream stream = (InputStream)this.openExchanges.get(exchange.getExchangeId());
            File aFile = (File)exchange.getMessage("in").getProperty("org.apache.servicemix.file");
            if (aFile == null) {
                throw new JBIException("Property org.apache.servicemix.file was removed from the exchange -- unable to delete/archive the file");
            }
            this.logger.debug((Object)("Releasing " + aFile.getAbsolutePath()));
            stream.close();
            try {
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    if (!this.isDeleteFile()) return;
                    if (this.archive != null) {
                        FilePollerEndpoint.moveFile(aFile, this.archive);
                        return;
                    }
                    if (aFile.delete()) return;
                    throw new IOException("Could not delete file " + aFile);
                }
                if (exchange.getStatus() != ExchangeStatus.ERROR) throw new JBIException("Unexpectedly received an exchange with status ACTIVE");
                Exception e = exchange.getError();
                if (e == null) {
                    throw new JBIException("Received an exchange with status ERROR, but no exception was set");
                }
                this.logger.warn((Object)("Message in file " + aFile + " could not be handled successfully: " + e.getMessage()), (Throwable)e);
                return;
            }
            finally {
                this.openExchanges.remove(exchange.getExchangeId());
                this.unlockAsyncFile(aFile);
            }
        } else {
            this.logger.debug((Object)"Received unknown exchange. Will be ignored...");
            return;
        }
    }

    private void unlockAsyncFile(File file) {
        String uri = this.file.toURI().relativize(file.toURI()).toString();
        Lock lock = this.lockManager.getLock(uri);
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
        }
    }

    public static void moveFile(File src, File targetDirectory) throws IOException {
        String targetName = src.getName();
        File target = new File(targetDirectory, targetName);
        if (target.exists() && target.isFile()) {
            targetName = String.format("%d_%s", System.currentTimeMillis(), src.getName());
        }
        if (!src.renameTo(new File(targetDirectory, targetName))) {
            throw new IOException("Failed to move " + src + " to " + targetDirectory + " with new name " + targetName);
        }
    }
}

