/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.file.FileComponent;
import org.apache.servicemix.file.FileEndpointType;

public class FileSenderEndpoint
extends ProviderEndpoint
implements FileEndpointType {
    private File directory;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private String tempFilePrefix = "servicemix-";
    private String tempFileSuffix = ".xml";
    private boolean autoCreateDirectory = true;
    private boolean append = false;

    public FileSenderEndpoint() {
    }

    public FileSenderEndpoint(FileComponent component, ServiceEndpoint endpoint) {
        super((DefaultComponent)component, endpoint);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.directory == null) {
            throw new DeploymentException("You must specify the directory property");
        }
        if (this.isAutoCreateDirectory()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new DeploymentException("The directory property must be a directory but was: " + this.directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        block12: {
            boolean success;
            File newFile;
            block11: {
                OutputStream out = null;
                newFile = null;
                success = false;
                try {
                    String name = this.marshaler.getOutputName(exchange, in);
                    newFile = name == null ? File.createTempFile(this.tempFilePrefix, this.tempFileSuffix, this.directory) : new File(this.directory, name);
                    if (!newFile.getParentFile().exists() && this.isAutoCreateDirectory()) {
                        newFile.getParentFile().mkdirs();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Writing to file: " + newFile.getCanonicalPath()));
                    }
                    out = new BufferedOutputStream(new FileOutputStream(newFile, this.append));
                    this.marshaler.writeMessage(exchange, in, out, name);
                    success = true;
                    Object var8_7 = null;
                    if (out == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            this.logger.error((Object)("Caught exception while closing stream on error: " + e), (Throwable)e);
                        }
                    }
                    if (!success) {
                        this.logger.debug((Object)("An error occurred while writing file " + newFile.getCanonicalPath() + ", deleting the invalid file"));
                        if (!newFile.delete()) {
                            this.logger.warn((Object)("Unable to delete the file " + newFile.getCanonicalPath() + " after an error had occurred"));
                        }
                    }
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)("Caught exception while closing stream on error: " + e), (Throwable)e);
                }
            }
            if (success) break block12;
            this.logger.debug((Object)("An error occurred while writing file " + newFile.getCanonicalPath() + ", deleting the invalid file"));
            if (!newFile.delete()) {
                this.logger.warn((Object)("Unable to delete the file " + newFile.getCanonicalPath() + " after an error had occurred"));
            }
        }
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        super.processInOut(exchange, in, out);
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
    }

    public String getTempFilePrefix() {
        return this.tempFilePrefix;
    }

    public void setTempFileSuffix(String tempFileSuffix) {
        this.tempFileSuffix = tempFileSuffix;
    }

    public String getTempFileSuffix() {
        return this.tempFileSuffix;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isAppend() {
        return this.append;
    }
}

