/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean.pojos;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.bean.support.BeanSupport;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.listener.MessageExchangeListener;
import org.w3c.dom.Node;

public class LoggingPojo
extends BeanSupport
implements MessageExchangeListener {
    private Log log = LogFactory.getLog(LoggingPojo.class);
    private SourceTransformer sourceTransformer = new SourceTransformer();
    private int maxMsgDisplaySize = 1500;

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public SourceTransformer getSourceTransformer() {
        return this.sourceTransformer;
    }

    public void setSourceTransformer(SourceTransformer sourceTransformer) {
        this.sourceTransformer = sourceTransformer;
    }

    public int getMaxMsgDisplaySize() {
        return this.maxMsgDisplaySize;
    }

    public void setMaxMsgDisplaySize(int maxMsgDisplaySize) {
        this.maxMsgDisplaySize = maxMsgDisplaySize;
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            NormalizedMessage message = exchange.getMessage("in");
            StringBuffer sb = new StringBuffer();
            sb.append("[\n");
            sb.append("  id: ").append(exchange.getExchangeId()).append('\n');
            sb.append("  mep: ").append(exchange.getPattern()).append('\n');
            sb.append("  status: ").append(exchange.getStatus()).append('\n');
            sb.append("  role: ").append(exchange.getRole() == MessageExchange.Role.CONSUMER ? "consumer" : "provider").append('\n');
            if (exchange.getInterfaceName() != null) {
                sb.append("  interface: ").append(exchange.getInterfaceName()).append('\n');
            }
            if (exchange.getService() != null) {
                sb.append("  service: ").append(exchange.getService()).append('\n');
            }
            if (exchange.getEndpoint() != null) {
                sb.append("  endpoint: ").append(exchange.getEndpoint().getEndpointName()).append('\n');
            }
            if (exchange.getOperation() != null) {
                sb.append("  operation: ").append(exchange.getOperation()).append('\n');
            }
            if (exchange.getPropertyNames().size() > 0) {
                sb.append("  properties: [").append('\n');
                for (String key : exchange.getPropertyNames()) {
                    sb.append("      ").append(key).append(" = ");
                    Object contents = exchange.getProperty(key);
                    if (contents instanceof Source) {
                        try {
                            contents = this.sourceTransformer.toString((Source)contents);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    sb.append(contents);
                    sb.append('\n');
                }
                sb.append("  ]").append('\n');
            }
            this.display(exchange, "in", sb);
            this.log.info((Object)("Exchange received " + sb.toString()));
            if (exchange instanceof InOut) {
                MessageUtil.transferInToOut((MessageExchange)exchange, (MessageExchange)exchange);
                this.send(exchange);
            } else {
                this.done(exchange);
            }
        }
    }

    private void display(MessageExchange exchange, String msg, StringBuffer sb) {
        NormalizedMessage message = exchange.getMessage(msg);
        if (message != null) {
            sb.append("  ").append(msg).append(": [").append('\n');
            sb.append("    content: ");
            try {
                if (message.getContent() != null) {
                    Node node = this.sourceTransformer.toDOMNode(message.getContent());
                    message.setContent((Source)new DOMSource(node));
                    String str = this.sourceTransformer.toString(node);
                    if (str.length() > this.maxMsgDisplaySize) {
                        sb.append(str.substring(0, this.maxMsgDisplaySize)).append("...");
                    } else {
                        sb.append(str);
                    }
                } else {
                    sb.append("null");
                }
            }
            catch (Exception e) {
                sb.append("Unable to display: ").append(e);
            }
            sb.append('\n');
            if (message.getAttachmentNames().size() > 0) {
                sb.append("    attachments: [").append('\n');
                for (String key : message.getAttachmentNames()) {
                    sb.append("      ").append(key).append(" = ").append(message.getAttachment(key)).append('\n');
                }
                sb.append("    ]").append('\n');
            }
            if (message.getPropertyNames().size() > 0) {
                sb.append("    properties: [").append('\n');
                for (String key : message.getPropertyNames()) {
                    sb.append("      ").append(key).append(" = ");
                    Object contents = message.getProperty(key);
                    if (contents instanceof Source) {
                        try {
                            contents = this.sourceTransformer.toString((Source)contents);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    sb.append(contents);
                    sb.append('\n');
                }
                sb.append("    ]").append('\n');
            }
            sb.append("  ]").append('\n');
        }
    }
}

