/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.AbstractWorkflowFactory;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class URLWorkflowFactory
extends AbstractWorkflowFactory {
    private Map cache = new HashMap();

    public WorkflowDescriptor getWorkflow(String name) throws FactoryException {
        WorkflowDescriptor descriptor;
        boolean useCache = this.getProperties().getProperty("cache", "false").equals("true");
        if (useCache && (descriptor = (WorkflowDescriptor)this.cache.get(name)) != null) {
            return descriptor;
        }
        try {
            URL url = new URL(name);
            WorkflowDescriptor descriptor2 = WorkflowLoader.load(url);
            if (useCache) {
                this.cache.put(name, descriptor2);
            }
            return descriptor2;
        }
        catch (Exception e) {
            throw new FactoryException("Unable to find workflow " + name, e);
        }
    }

    public String[] getWorkflowNames() throws FactoryException {
        throw new FactoryException("URLWorkflowFactory does not contain a list of workflow names");
    }

    public boolean removeWorkflow(String name) throws FactoryException {
        throw new FactoryException("remove workflow not supported");
    }

    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        WorkflowDescriptor c = (WorkflowDescriptor)this.cache.get(name);
        URL url = null;
        try {
            url = new URL(name);
        }
        catch (MalformedURLException ex) {
            throw new FactoryException("workflow '" + name + "' is an invalid url:" + ex);
        }
        boolean useCache = this.getProperties().getProperty("cache", "false").equals("true");
        if (useCache && c != null && !replace) {
            return false;
        }
        if (new File(url.getFile()).exists() && !replace) {
            return false;
        }
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(url.getFile() + ".new"), "utf-8");
        }
        catch (FileNotFoundException ex) {
            throw new FactoryException("Could not create new file to save workflow " + url.getFile());
        }
        catch (UnsupportedEncodingException ex) {
            throw new FactoryException("utf-8 encoding not supported, contact your JVM vendor!");
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(out));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.7//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_7.dtd\">");
        descriptor.writeXML(writer, 0);
        writer.flush();
        writer.close();
        File original = new File(url.getFile());
        File backup = new File(url.getFile() + ".bak");
        File updated = new File(url.getFile() + ".new");
        boolean isOK = original.renameTo(backup);
        if (!isOK) {
            throw new FactoryException("Unable to backup original workflow file " + original + " to " + backup + ", aborting save");
        }
        isOK = updated.renameTo(original);
        if (!isOK) {
            throw new FactoryException("Unable to rename new  workflow file " + updated + " to " + original + ", aborting save");
        }
        backup.delete();
        if (useCache) {
            this.cache.put(name, descriptor);
        }
        return true;
    }
}

