/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.filemonitor;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.servicemix.kernel.filemonitor.FileMonitor;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class FileMonitorActivator
implements BundleActivator,
ManagedServiceFactory {
    private BundleContext context;
    private ServiceTracker packageAdminTracker;
    private ServiceTracker configurationAdminTracker;
    private Map<String, FileMonitor> fileMonitors = new HashMap<String, FileMonitor>();

    public void start(BundleContext context) throws Exception {
        this.context = context;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", this.getName());
        context.registerService(ManagedServiceFactory.class.getName(), (Object)this, properties);
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.packageAdminTracker.open();
        this.configurationAdminTracker = new ServiceTracker(context, ConfigurationAdmin.class.getName(), null);
        this.configurationAdminTracker.open();
        Hashtable initialProperties = new Hashtable();
        this.setPropertiesFromContext(initialProperties, "org.apache.servicemix.filemonitor.configDir", "org.apache.servicemix.filemonitor.monitorDir", "org.apache.servicemix.filemonitor.generatedJarDir", "org.apache.servicemix.filemonitor.scanInterval");
        this.updated("initialPid", initialProperties);
    }

    public void stop(BundleContext context) throws Exception {
        Collection<FileMonitor> fileMonitors = this.fileMonitors.values();
        for (FileMonitor monitor : fileMonitors) {
            try {
                monitor.stop();
            }
            catch (Exception e) {}
        }
        this.fileMonitors.clear();
        this.configurationAdminTracker.close();
        this.packageAdminTracker.close();
    }

    public String getName() {
        return "org.apache.servicemix.kernel.filemonitor.FileMonitor";
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        this.deleted(pid);
        FileMonitor monitor = new FileMonitor(this, properties);
        this.fileMonitors.put(pid, monitor);
        monitor.start();
    }

    public void deleted(String pid) {
        FileMonitor monitor = this.fileMonitors.remove(pid);
        if (monitor != null) {
            monitor.stop();
        }
    }

    public BundleContext getContext() {
        return this.context;
    }

    public ServiceTracker getConfigurationAdminTracker() {
        return this.configurationAdminTracker;
    }

    public ServiceTracker getPackageAdminTracker() {
        return this.packageAdminTracker;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return (ConfigurationAdmin)this.getConfigurationAdminTracker().getService();
    }

    protected void setPropertiesFromContext(Hashtable properties, String ... keys) {
        for (String key : keys) {
            String value = this.context.getProperty(key);
            if (value == null) continue;
            properties.put(key, value);
        }
    }
}

