/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support;

import java.io.IOException;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.osgi.context.support.AbstractDelegatedExecutionApplicationContext;
import org.springframework.osgi.context.support.DelegatedEntityResolver;
import org.springframework.osgi.context.support.DelegatedNamespaceHandlerResolver;
import org.springframework.osgi.context.support.TrackingUtil;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;
import org.xml.sax.EntityResolver;

public class OsgiBundleXmlApplicationContext
extends AbstractDelegatedExecutionApplicationContext {
    public static final String DEFAULT_CONFIG_LOCATION = "osgibundle:/META-INF/spring/*.xml";

    public OsgiBundleXmlApplicationContext() {
        this((String[])null);
    }

    public OsgiBundleXmlApplicationContext(ApplicationContext parent) {
        this(null, parent);
    }

    public OsgiBundleXmlApplicationContext(String[] configLocations) {
        this(configLocations, null);
    }

    public OsgiBundleXmlApplicationContext(String[] configLocations, ApplicationContext parent) {
        super(parent);
        this.setConfigLocations(configLocations);
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        beanDefinitionReader.setResourceLoader((ResourceLoader)this);
        NamespaceHandlerResolver nsResolver = this.createNamespaceHandlerResolver(this.getBundleContext(), this.getClassLoader());
        EntityResolver enResolver = this.createEntityResolver(this.getBundleContext(), this.getClassLoader());
        beanDefinitionReader.setEntityResolver(enResolver);
        beanDefinitionReader.setNamespaceHandlerResolver(nsResolver);
        this.initBeanDefinitionReader(beanDefinitionReader);
        this.loadBeanDefinitions(beanDefinitionReader);
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        String[] configLocations = this.getConfigLocations();
        if (configLocations != null) {
            for (int i = 0; i < configLocations.length; ++i) {
                reader.loadBeanDefinitions(configLocations[i]);
            }
        }
    }

    protected String[] getDefaultConfigLocations() {
        return new String[]{DEFAULT_CONFIG_LOCATION};
    }

    private NamespaceHandlerResolver createNamespaceHandlerResolver(BundleContext bundleContext, ClassLoader bundleClassLoader) {
        Assert.notNull((Object)bundleContext, (String)"bundleContext is required");
        DefaultNamespaceHandlerResolver localNamespaceResolver = new DefaultNamespaceHandlerResolver(bundleClassLoader);
        NamespaceHandlerResolver osgiServiceNamespaceResolver = this.lookupNamespaceHandlerResolver(bundleContext, localNamespaceResolver);
        DelegatedNamespaceHandlerResolver delegate = new DelegatedNamespaceHandlerResolver();
        delegate.addNamespaceHandler((NamespaceHandlerResolver)localNamespaceResolver, "LocalNamespaceResolver for bundle " + OsgiStringUtils.nullSafeNameAndSymName(bundleContext.getBundle()));
        delegate.addNamespaceHandler(osgiServiceNamespaceResolver, "OSGi Service resolver");
        return delegate;
    }

    private EntityResolver createEntityResolver(BundleContext bundleContext, ClassLoader bundleClassLoader) {
        Assert.notNull((Object)bundleContext, (String)"bundleContext is required");
        DelegatingEntityResolver localEntityResolver = new DelegatingEntityResolver(bundleClassLoader);
        EntityResolver osgiServiceEntityResolver = this.lookupEntityResolver(bundleContext, localEntityResolver);
        DelegatedEntityResolver delegate = new DelegatedEntityResolver();
        delegate.addEntityResolver((EntityResolver)localEntityResolver, "LocalEntityResolver for bundle " + OsgiStringUtils.nullSafeNameAndSymName(bundleContext.getBundle()));
        delegate.addEntityResolver(osgiServiceEntityResolver, "OSGi Service resolver");
        return delegate;
    }

    private NamespaceHandlerResolver lookupNamespaceHandlerResolver(BundleContext bundleContext, Object fallbackObject) {
        return (NamespaceHandlerResolver)TrackingUtil.getService(new Class[]{NamespaceHandlerResolver.class}, null, NamespaceHandlerResolver.class.getClassLoader(), bundleContext, fallbackObject);
    }

    private EntityResolver lookupEntityResolver(BundleContext bundleContext, Object fallbackObject) {
        return (EntityResolver)TrackingUtil.getService(new Class[]{EntityResolver.class}, null, EntityResolver.class.getClassLoader(), bundleContext, fallbackObject);
    }

    public String[] getConfigLocations() {
        return super.getConfigLocations();
    }
}

