/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.gshell.features.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.gshell.features.Feature;
import org.apache.servicemix.gshell.features.FeaturesService;
import org.apache.servicemix.gshell.features.Repository;
import org.apache.servicemix.gshell.features.internal.RepositoryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturesServiceImpl
implements FeaturesService,
BundleContextAware {
    private static final String ALIAS_KEY = "_alias_factory_pid";
    private static final Log LOGGER = LogFactory.getLog(FeaturesServiceImpl.class);
    private BundleContext bundleContext;
    private ConfigurationAdmin configAdmin;
    private PreferencesService preferences;
    private Set<URI> uris;
    private Map<URI, RepositoryImpl> repositories = new HashMap<URI, RepositoryImpl>();
    private Map<String, Feature> features;
    private Map<String, Set<Long>> installed = new HashMap<String, Set<Long>>();
    private String boot;
    private boolean bootFeaturesInstalled;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public PreferencesService getPreferences() {
        return this.preferences;
    }

    public void setPreferences(PreferencesService preferences) {
        this.preferences = preferences;
    }

    public void setUrls(String uris) throws URISyntaxException {
        String[] s = uris.split(",");
        this.uris = new HashSet<URI>();
        for (int i = 0; i < s.length; ++i) {
            this.uris.add(new URI(s[i]));
        }
    }

    public void setBoot(String boot) {
        this.boot = boot;
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        if (!this.repositories.values().contains(uri)) {
            this.internalAddRepository(uri);
            this.saveState();
        }
    }

    protected void internalAddRepository(URI uri) throws Exception {
        RepositoryImpl repo = new RepositoryImpl(uri);
        this.repositories.put(uri, repo);
        this.features = null;
    }

    @Override
    public void removeRepository(URI uri) {
        if (this.repositories.containsKey(uri)) {
            this.internalRemoveRepository(uri);
            this.saveState();
        }
    }

    public void internalRemoveRepository(URI uri) {
        this.repositories.remove(uri);
        this.features = null;
    }

    @Override
    public Repository[] listRepositories() {
        Collection<RepositoryImpl> repos = this.repositories.values();
        return repos.toArray(new Repository[repos.size()]);
    }

    @Override
    public void installFeature(String name) throws Exception {
        Feature f = this.getFeature(name);
        if (f == null) {
            throw new Exception("No feature named '" + name + "' available");
        }
        for (String dependency : f.getDependencies()) {
            this.installFeature(dependency);
        }
        for (String config : f.getConfigurations().keySet()) {
            Configuration cfg;
            Hashtable<String, String> props = new Hashtable<String, String>(f.getConfigurations().get(config));
            String[] pid = this.parsePid(config);
            if (pid[1] != null) {
                ((Dictionary)props).put(ALIAS_KEY, pid[1]);
            }
            if ((cfg = this.getConfiguration(this.configAdmin, pid[0], pid[1])).getBundleLocation() != null) {
                cfg.setBundleLocation(null);
            }
            cfg.update(props);
        }
        HashSet<Long> bundles = new HashSet<Long>();
        for (String bundleLocation : f.getBundles()) {
            Bundle b = this.installBundleIfNeeded(bundleLocation);
            b.start();
            bundles.add(b.getBundleId());
        }
        this.installed.put(name, bundles);
        this.saveState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle installBundleIfNeeded(String bundleLocation) throws IOException, BundleException {
        LOGGER.debug((Object)("Checking " + bundleLocation));
        BufferedInputStream is = new BufferedInputStream(new URL(bundleLocation).openStream());
        try {
            ((InputStream)is).mark(262144);
            JarInputStream jar = new JarInputStream(is);
            Manifest m = jar.getManifest();
            String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
            String vStr = m.getMainAttributes().getValue("Bundle-Version");
            Version v = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
            for (Bundle b : this.bundleContext.getBundles()) {
                Version bv;
                if (b.getSymbolicName() == null || !b.getSymbolicName().equals(sn)) continue;
                vStr = (String)b.getHeaders().get("Bundle-Version");
                Version version = bv = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
                if (!v.equals((Object)bv)) continue;
                LOGGER.debug((Object)("  found installed bundle: " + b));
                Bundle bundle = b;
                return bundle;
            }
            try {
                ((InputStream)is).reset();
            }
            catch (IOException e) {
                ((InputStream)is).close();
                is = new BufferedInputStream(new URL(bundleLocation).openStream());
            }
            LOGGER.debug((Object)("Installing bundle " + bundleLocation));
            Bundle bundle = this.getBundleContext().installBundle(bundleLocation, (InputStream)is);
            return bundle;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    @Override
    public void uninstallFeature(String name) throws Exception {
        if (!this.installed.containsKey(name)) {
            throw new Exception("Feature named '" + name + "' is not installed");
        }
        Set<Long> bundles = this.installed.remove(name);
        for (Set<Long> b : this.installed.values()) {
            bundles.removeAll(b);
        }
        Iterator<Object> i$ = bundles.iterator();
        while (i$.hasNext()) {
            long bundleId = (Long)i$.next();
            this.getBundleContext().getBundle(bundleId).uninstall();
        }
        this.saveState();
    }

    @Override
    public String[] listFeatures() throws Exception {
        ArrayList<String> features = new ArrayList<String>();
        for (Feature f : this.getFeatures().values()) {
            String installStatus = this.installed.containsKey(f.getName()) ? "installed  " : "uninstalled";
            String version = f.getVersion();
            switch (version.length()) {
                case 1: {
                    version = "       " + version;
                }
                case 2: {
                    version = "      " + version;
                }
                case 3: {
                    version = "     " + version;
                }
                case 4: {
                    version = "    " + version;
                }
                case 5: {
                    version = "   " + version;
                }
                case 6: {
                    version = "  " + version;
                }
                case 7: {
                    version = " " + version;
                }
            }
            features.add("[" + installStatus + "] " + " [" + version + "] " + f.getName());
        }
        return features.toArray(new String[features.size()]);
    }

    @Override
    public String[] listInstalledFeatures() {
        return this.installed.keySet().toArray(new String[this.installed.size()]);
    }

    protected Feature getFeature(String name) throws Exception {
        return this.getFeatures().get(name);
    }

    protected Map<String, Feature> getFeatures() throws Exception {
        if (this.features == null) {
            boolean newRepo;
            HashMap<String, Feature> map = new HashMap<String, Feature>();
            do {
                newRepo = false;
                for (Repository repo : this.listRepositories()) {
                    for (URI uri : repo.getRepositories()) {
                        if (this.repositories.keySet().contains(uri)) continue;
                        this.internalAddRepository(uri);
                        newRepo = true;
                    }
                }
            } while (newRepo);
            for (RepositoryImpl repo : this.repositories.values()) {
                for (Feature f : repo.getFeatures()) {
                    map.put(f.getName(), f);
                }
            }
            this.features = map;
        }
        return this.features;
    }

    public void start() throws Exception {
        if (!this.loadState()) {
            if (this.uris != null) {
                for (URI uri : this.uris) {
                    this.internalAddRepository(uri);
                }
            }
            this.saveState();
        }
        if (this.boot != null && !this.bootFeaturesInstalled) {
            new Thread(){

                public void run() {
                    String[] list;
                    for (String f : list = FeaturesServiceImpl.this.boot.split(",")) {
                        if (f.length() <= 0) continue;
                        try {
                            FeaturesServiceImpl.this.installFeature(f);
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("Error installing boot feature " + f), (Throwable)e);
                        }
                    }
                    FeaturesServiceImpl.this.bootFeaturesInstalled = true;
                    FeaturesServiceImpl.this.saveState();
                }
            }.start();
        }
    }

    public void stop() throws Exception {
        this.uris = new HashSet<URI>(this.repositories.keySet());
        while (!this.repositories.isEmpty()) {
            this.internalRemoveRepository(this.repositories.keySet().iterator().next());
        }
    }

    protected String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    protected Configuration getConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        if (factoryPid != null) {
            Configuration[] configs = configurationAdmin.listConfigurations("(|(_alias_factory_pid=" + pid + ")(.alias_factory_pid=" + factoryPid + "))");
            if (configs == null || configs.length == 0) {
                return configurationAdmin.createFactoryConfiguration(pid, null);
            }
            return configs[0];
        }
        return configurationAdmin.getConfiguration(pid, null);
    }

    protected void saveState() {
        try {
            Preferences prefs = this.preferences.getUserPreferences("FeaturesServiceState");
            this.saveSet(prefs.node("repositories"), this.repositories.keySet());
            this.saveMap(prefs.node("features"), this.installed);
            prefs.putBoolean("bootFeaturesInstalled", this.bootFeaturesInstalled);
            prefs.flush();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error persisting FeaturesService state", (Throwable)e);
        }
    }

    protected boolean loadState() {
        try {
            Preferences prefs = this.preferences.getUserPreferences("FeaturesServiceState");
            if (prefs.nodeExists("repositories")) {
                Set<URI> repositories = this.loadSet(prefs.node("repositories"));
                for (URI repo : repositories) {
                    this.internalAddRepository(repo);
                }
                this.installed = this.loadMap(prefs.node("features"));
                this.bootFeaturesInstalled = prefs.getBoolean("bootFeaturesInstalled", false);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error loading FeaturesService state", (Throwable)e);
        }
        return false;
    }

    protected void saveSet(Preferences node, Set<URI> set) throws BackingStoreException {
        ArrayList<URI> l = new ArrayList<URI>(set);
        node.clear();
        node.putInt("count", l.size());
        for (int i = 0; i < l.size(); ++i) {
            node.put("item." + i, ((URI)l.get(i)).toString());
        }
    }

    protected Set<URI> loadSet(Preferences node) {
        HashSet<URI> l = new HashSet<URI>();
        int count = node.getInt("count", 0);
        for (int i = 0; i < count; ++i) {
            l.add(URI.create(node.get("item." + i, null)));
        }
        return l;
    }

    protected void saveMap(Preferences node, Map<String, Set<Long>> map) throws BackingStoreException {
        node.clear();
        for (Map.Entry<String, Set<Long>> entry : map.entrySet()) {
            String key = entry.getKey();
            String val = this.createValue(entry.getValue());
            node.put(key, val);
        }
    }

    protected Map<String, Set<Long>> loadMap(Preferences node) throws BackingStoreException {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        for (String key : node.keys()) {
            String val = node.get(key, null);
            Set<Long> set = this.readValue(val);
            map.put(key, set);
        }
        return map;
    }

    protected String createValue(Set<Long> set) {
        StringBuilder sb = new StringBuilder();
        for (long i : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(i);
        }
        return sb.toString();
    }

    protected Set<Long> readValue(String val) {
        HashSet<Long> set = new HashSet<Long>();
        for (String str : val.split(",")) {
            set.add(Long.parseLong(str));
        }
        return set;
    }
}

