/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuleLoader {
    RuleLoader() {
    }

    public static Collection<Package> loadPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        Collection<InputStreamReader> readers = RuleLoader.readInputStreamReaders();
        for (InputStreamReader reader : readers) {
            try {
                packages.add(RuleLoader.loadPackage(reader));
            }
            catch (DroolsParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return packages;
    }

    private static Package loadPackage(InputStreamReader reader) throws DroolsParserException, IOException {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl(reader);
        return builder.getPackage();
    }

    private static Collection<InputStreamReader> readInputStreamReaders() {
        ArrayList<InputStreamReader> list = new ArrayList<InputStreamReader>();
        list.add(new InputStreamReader(RuleLoader.class.getResourceAsStream("rangeChecks/Dates.drl")));
        list.add(new InputStreamReader(RuleLoader.class.getResourceAsStream("rangeChecks/Doubles.drl")));
        list.add(new InputStreamReader(RuleLoader.class.getResourceAsStream("rangeChecks/Integers.drl")));
        list.add(new InputStreamReader(RuleLoader.class.getResourceAsStream("rangeChecks/Patterns.drl")));
        list.add(new InputStreamReader(RuleLoader.class.getResourceAsStream("rangeChecks/Variables.drl")));
        list.add(new InputStreamReader(RuleLoader.class.getResourceAsStream("rangeChecks/Clean.drl")));
        list.add(new InputStreamReader(RuleLoader.class.getResourceAsStream("reports/RangeCheckReports.drl")));
        return list;
    }
}

