/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.analytics.PatternSolver;
import org.drools.analytics.RuleSolver;
import org.drools.analytics.components.AnalyticsComponent;
import org.drools.analytics.components.AnalyticsRule;
import org.drools.analytics.components.OperatorDescr;
import org.drools.analytics.components.Pattern;
import org.drools.analytics.components.PatternPossibility;
import org.drools.analytics.components.Restriction;
import org.drools.analytics.components.RulePossibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solvers {
    private RuleSolver ruleSolver = null;
    private PatternSolver patternSolver = null;
    private List<PatternPossibility> patternPossibilities = new ArrayList<PatternPossibility>();
    private List<RulePossibility> rulePossibilities = new ArrayList<RulePossibility>();

    public void startRuleSolver(AnalyticsRule rule) {
        this.ruleSolver = new RuleSolver(rule);
    }

    public void endRuleSolver() {
        this.createRulePossibilities();
        this.ruleSolver = null;
    }

    public void startPatternSolver(Pattern pattern) {
        this.patternSolver = new PatternSolver(pattern);
        this.patternSolver.getPattern().setPatternNot(this.ruleSolver.isChildNot());
    }

    public void endPatternSolver() {
        this.createPatternPossibilities();
        this.patternSolver = null;
    }

    public void startForall() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildForall(true);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildForall(true);
        }
    }

    public void endForall() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildForall(false);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildForall(false);
        }
    }

    public void startExists() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildExists(true);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildExists(true);
        }
    }

    public void endExists() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildExists(false);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildExists(false);
        }
    }

    public void startNot() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildNot(true);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildNot(true);
        }
    }

    public void endNot() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildNot(false);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildNot(false);
        }
    }

    public void startOperator(OperatorDescr operatorDescr) {
        if (this.patternSolver != null) {
            this.patternSolver.add(operatorDescr);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.add(operatorDescr);
        }
    }

    public void endOperator() {
        if (this.patternSolver != null) {
            this.patternSolver.end();
        } else if (this.ruleSolver != null) {
            this.ruleSolver.end();
        }
    }

    public void addRestriction(Restriction restriction) {
        this.patternSolver.add(restriction);
    }

    private void createPatternPossibilities() {
        for (Set<AnalyticsComponent> list : this.patternSolver.getPossibilityLists()) {
            PatternPossibility possibility = new PatternPossibility();
            possibility.setRuleId(this.ruleSolver.getRule().getId());
            possibility.setRuleName(this.ruleSolver.getRule().getRuleName());
            possibility.setPatternId(this.patternSolver.getPattern().getId());
            for (AnalyticsComponent descr : list) {
                possibility.add((Restriction)descr);
            }
            this.ruleSolver.add(possibility);
            this.patternPossibilities.add(possibility);
        }
    }

    private void createRulePossibilities() {
        for (Set<AnalyticsComponent> list : this.ruleSolver.getPossibilityLists()) {
            RulePossibility possibility = new RulePossibility();
            possibility.setRuleId(this.ruleSolver.getRule().getId());
            possibility.setRuleName(this.ruleSolver.getRule().getRuleName());
            for (AnalyticsComponent descr : list) {
                PatternPossibility patternPossibility = (PatternPossibility)descr;
                possibility.add(patternPossibility);
            }
            this.rulePossibilities.add(possibility);
        }
    }

    public List<PatternPossibility> getPatternPossibilities() {
        return this.patternPossibilities;
    }

    public void setPatternPossibilities(List<PatternPossibility> patternPossibilities) {
        this.patternPossibilities = patternPossibilities;
    }

    public List<RulePossibility> getRulePossibilities() {
        return this.rulePossibilities;
    }

    public void setRulePossibilities(List<RulePossibility> rulePossibilities) {
        this.rulePossibilities = rulePossibilities;
    }

    public PatternSolver getPatternSolver() {
        return this.patternSolver;
    }

    public RuleSolver getRuleSolver() {
        return this.ruleSolver;
    }
}

