/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.drools.analytics.components.Field;
import org.drools.analytics.components.LiteralRestriction;
import org.drools.analytics.components.Restriction;
import org.drools.analytics.dao.AnalyticsData;
import org.drools.analytics.dao.AnalyticsDataFactory;
import org.drools.analytics.result.MapTree;
import org.drools.analytics.result.RangeCheckCause;
import org.drools.analytics.result.ReportVisitor;
import org.drools.analytics.result.UrlFactory;
import org.mvel.TemplateInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingRangesReportVisitor
extends ReportVisitor {
    public static String visitRangeCheckCauseCollection(Collection<RangeCheckCause> causes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", MissingRangesReportVisitor.processHeader("."));
        map.put("sourceFolder", ".");
        map.put("ruleFolder", "rules");
        map.put("packageFolder", "packages");
        map.put("cssStyle", MissingRangesReportVisitor.createStyleTag("css/relationsList.css"));
        MapTree<Integer, RangeCheckCause> mapTree = new MapTree<Integer, RangeCheckCause>();
        for (RangeCheckCause cause : causes) {
            mapTree.put(cause.getField().getId(), cause);
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (Integer i : mapTree.map.keySet()) {
            Set<RangeCheckCause> set = mapTree.map.get(i);
            lines.add(MissingRangesReportVisitor.processRangeCheckCollection(set));
        }
        map.put("lines", lines);
        String myTemplate = MissingRangesReportVisitor.readFile("missingRanges.htm");
        String result = TemplateInterpreter.evalToString(myTemplate, map);
        return result;
    }

    private static String processRangeCheckCollection(Collection<RangeCheckCause> causes) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        Field field = causes.iterator().next().getField();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", MissingRangesReportVisitor.processHeader("."));
        map.put("sourceFolder", ".");
        map.put("fieldFolder", "fields");
        map.put("objectTypeFolder", "objectTypes");
        map.put("packageFolder", "packages");
        map.put("cssStyle", MissingRangesReportVisitor.createStyleTag("css/relationsList.css"));
        map.put("field", field);
        map.put("objectType", data.getClassById(field.getClassId()));
        map.put("ranges", MissingRangesReportVisitor.visitRanges(".", data.getRestrictionsByFieldId(field.getId()), causes));
        String myTemplate = MissingRangesReportVisitor.readFile("missingRange.htm");
        String result = TemplateInterpreter.evalToString(myTemplate, map);
        return result;
    }

    public static Collection<String> visitRestrictionsCollection(String sourceFolder, Collection<Restriction> restrictions, Collection<RangeCheckCause> causes) {
        MapTree<Object, String> map = new MapTree<Object, String>();
        for (RangeCheckCause cause : causes) {
            map.put(cause.getValueAsObject(), cause.getEvaluator() + " " + cause.getValueAsString() + " is missing");
        }
        for (Restriction r : restrictions) {
            if (!(r instanceof LiteralRestriction)) continue;
            try {
                LiteralRestriction restriction = (LiteralRestriction)r;
                map.put(restriction.getValueAsObject(), restriction.getEvaluator() + " " + restriction.getValueAsString() + " " + UrlFactory.getRuleUrl(sourceFolder, restriction.getRuleId(), restriction.getRuleName()));
            }
            catch (Exception e) {
                System.out.println(map);
                System.out.println(r);
            }
        }
        return map.values();
    }

    public static String visitRanges(String sourceFolder, Collection<Restriction> restrictions, Collection<RangeCheckCause> causes) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        map.put("lines", MissingRangesReportVisitor.visitRestrictionsCollection(sourceFolder, restrictions, causes));
        String myTemplate = MissingRangesReportVisitor.readFile("ranges.htm");
        String result = TemplateInterpreter.evalToString(myTemplate, map);
        return result;
    }
}

