/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import java.io.File;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.drools.analytics.Analyzer;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.descr.PackageDescr;

public class DroolsAnalyticsAntTask
extends MatchingTask {
    public static final String DRLFILEEXTENSION = ".drl";
    private File srcdir;
    private File toFile;
    private Path classpath;

    public void setSrcDir(File directory) {
        this.srcdir = directory;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathref(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.toFile == null) {
            throw new BuildException("Destination rulebase file does not specified.");
        }
        if (this.srcdir == null) {
            throw new BuildException("Source directory not specified.");
        }
        if (!this.srcdir.exists()) {
            throw new BuildException("Source directory does not exists." + this.srcdir.getAbsolutePath());
        }
        try {
            Analyzer droolsanalyzer = new Analyzer();
            String[] fileNames = this.getFileList();
            for (int i = 0; i < fileNames.length; ++i) {
                this.compileAndAnalyzeFile(droolsanalyzer, fileNames[i]);
            }
            droolsanalyzer.fireAnalysis();
            droolsanalyzer.writeComponentsHTML(this.toFile.getAbsolutePath() + "/");
            System.out.println("Writing analytics report to " + this.toFile.getAbsolutePath() + "/report");
        }
        catch (Exception e) {
            throw new BuildException("RuleBaseTask failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private void compileAndAnalyzeFile(Analyzer droolsanalyzer, String filename) throws DroolsParserException {
        if (!filename.endsWith(DRLFILEEXTENSION)) {
            throw new UnsupportedOperationException();
        }
        PackageDescr descr = new DrlParser().parse(new InputStreamReader(Analyzer.class.getResourceAsStream(filename)));
        droolsanalyzer.addPackageDescr(descr);
    }

    private String[] getFileList() {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.srcdir);
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (fileNames == null || fileNames.length <= 0) {
            throw new BuildException("No rule files found in include directory.");
        }
        return fileNames;
    }
}

