/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.decisiontable.model.SnippetBuilder;
import org.drools.decisiontable.parser.SourceBuilder;

public class RhsBuilder
implements SourceBuilder {
    private Map templates;
    private String variable;
    private List values;
    private boolean hasValues;

    public RhsBuilder(String boundVariable) {
        this.variable = boundVariable == null ? "" : boundVariable.trim();
        this.templates = new HashMap();
        this.values = new ArrayList();
    }

    public void addTemplate(int col, String content) {
        Integer key = new Integer(col);
        content = content.trim();
        if (this.isBoundVar()) {
            content = this.variable + "." + content + ";";
        }
        this.templates.put(key, content);
    }

    private boolean isBoundVar() {
        return !"".equals(this.variable);
    }

    public void addCellValue(int col, String value) {
        this.hasValues = true;
        String template = (String)this.templates.get(new Integer(col));
        SnippetBuilder snip = new SnippetBuilder(template);
        this.values.add(snip.build(value));
    }

    public void clearValues() {
        this.hasValues = false;
        this.values.clear();
    }

    public String getResult() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.values.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public boolean hasValues() {
        return this.hasValues;
    }
}

