/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.log4j.Logger;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionableItem;

public class PackageItem
extends VersionableItem {
    private static Logger log = Logger.getLogger((Class)PackageItem.class);
    public static final String ASSET_FOLDER_NAME = "assets";
    public static final String PACKAGE_FORMAT = "package";
    public static final String RULE_PACKAGE_TYPE_NAME = "drools:packageNodeType";
    public static final String HEADER_PROPERTY_NAME = "drools:header";
    public static final String EXTERNAL_URI_PROPERTY_NAME = "drools:externalURI";
    private static final String COMPILED_PACKAGE_PROPERTY_NAME = "drools:compiledPackage";

    public PackageItem(RulesRepository rulesRepository, Node node) throws RulesRepositoryException {
        super(rulesRepository, node);
        try {
            if (!this.node.getPrimaryNodeType().getName().equals(RULE_PACKAGE_TYPE_NAME) && !this.isHistoricalVersion()) {
                String message = this.node.getName() + " is not a node of type " + RULE_PACKAGE_TYPE_NAME + ". It is a node of type: " + this.node.getPrimaryNodeType().getName();
                log.error((Object)message);
                throw new RulesRepositoryException(message);
            }
        }
        catch (Exception e) {
            log.error((Object)("Caught exception: " + e));
            throw new RulesRepositoryException(e);
        }
    }

    PackageItem() {
        super(null, null);
    }

    public String getName() {
        try {
            if (this.isSnapshot()) {
                return this.node.getParent().getName();
            }
            return super.getName();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public boolean isSnapshot() {
        try {
            return !this.rulesRepository.isNotSnapshot(this.node.getParent());
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getSnapshotName() {
        return super.getName();
    }

    public AssetItem addAsset(String assetName, String description) {
        return this.addAsset(assetName, description, null, null);
    }

    public AssetItem addAsset(String assetName, String description, String initialCategory, String format) {
        try {
            Node rulesFolder = this.node.getNode(ASSET_FOLDER_NAME);
            Node ruleNode = rulesFolder.addNode(assetName, "drools:assetNodeType");
            ruleNode.setProperty("drools:title", assetName);
            ruleNode.setProperty("drools:description", description);
            if (format != null) {
                ruleNode.setProperty("drools:format", format);
            } else {
                ruleNode.setProperty("drools:format", "txt");
            }
            ruleNode.setProperty("drools:checkinComment", "Initial");
            Calendar lastModified = Calendar.getInstance();
            ruleNode.setProperty("drools:lastModified", lastModified);
            ruleNode.setProperty("drools:packageName", this.getName());
            ruleNode.setProperty("drools:creator", this.node.getSession().getUserID());
            AssetItem rule = new AssetItem(this.rulesRepository, ruleNode);
            rule.updateState(StateItem.DRAFT_STATE_NAME);
            if (initialCategory != null) {
                rule.addCategory(initialCategory);
            }
            return rule;
        }
        catch (RepositoryException e) {
            if (e instanceof ItemExistsException) {
                throw new RulesRepositoryException("A rule of that name already exists in that package.", e);
            }
            throw new RulesRepositoryException(e);
        }
    }

    public void removeAsset(String name) {
        try {
            this.node.getNode("assets/" + name).remove();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public Iterator getAssets() {
        try {
            Node content = this.getVersionContentNode();
            AssetItemIterator it = new AssetItemIterator(content.getNode(ASSET_FOLDER_NAME).getNodes(), this.rulesRepository);
            return it;
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator queryAssets(String fieldPredicates, boolean seekArchived) {
        try {
            String sql = "SELECT * FROM drools:assetNodeType";
            sql = sql + " WHERE jcr:path LIKE '" + this.getVersionContentNode().getPath() + "/" + ASSET_FOLDER_NAME + "[%]/%'";
            if (fieldPredicates.length() > 0) {
                sql = sql + " and " + fieldPredicates;
            }
            if (!seekArchived) {
                sql = sql + " AND drools:archive = 'false'";
            }
            Query q = this.node.getSession().getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult res = q.execute();
            return new AssetItemIterator(res.getNodes(), this.rulesRepository);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator queryAssets(String fieldPredicates) {
        return this.queryAssets(fieldPredicates, false);
    }

    public AssetItemIterator listArchivedAssets() {
        return this.queryAssets("drools:archive = 'true'", true);
    }

    public AssetItemIterator listAssetsByFormat(String[] formats) {
        if (formats.length == 1) {
            return this.queryAssets("drools:format='" + formats[0] + "'");
        }
        String predicate = " ( ";
        for (int i = 0; i < formats.length; ++i) {
            predicate = predicate + "drools:format='" + formats[i] + "'";
            if (i == formats.length - 1) continue;
            predicate = predicate + " OR ";
        }
        predicate = predicate + " ) ";
        return this.queryAssets(predicate);
    }

    public AssetItem loadAsset(String name) {
        try {
            Node content = this.getVersionContentNode();
            return new AssetItem(this.rulesRepository, content.getNode(ASSET_FOLDER_NAME).getNode(name));
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public boolean containsAsset(String name) {
        try {
            Node content = this.getVersionContentNode();
            return content.getNode(ASSET_FOLDER_NAME).hasNode(name);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public String toString() {
        try {
            StringBuffer returnString = new StringBuffer();
            returnString.append("Content of the rule package named " + this.node.getName() + ":");
            returnString.append("Description: " + this.getDescription() + "\n");
            returnString.append("Format: " + this.getFormat() + "\n");
            returnString.append("Last modified: " + this.getLastModified() + "\n");
            returnString.append("Title: " + this.getTitle() + "\n");
            returnString.append("----\n");
            return returnString.toString();
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception", (Throwable)e);
            return null;
        }
    }

    public VersionableItem getPrecedingVersion() throws RulesRepositoryException {
        try {
            Node precedingVersionNode = this.getPrecedingVersionNode();
            if (precedingVersionNode != null) {
                return new PackageItem(this.rulesRepository, precedingVersionNode);
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public VersionableItem getSucceedingVersion() throws RulesRepositoryException {
        try {
            Node succeedingVersionNode = this.getSucceedingVersionNode();
            if (succeedingVersionNode != null) {
                return new PackageItem(this.rulesRepository, succeedingVersionNode);
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public Iterator getAssetsWithStatus(StateItem state, StateItem ignoreState) {
        Iterator rules = this.getAssets();
        ArrayList<AssetItem> result = new ArrayList<AssetItem>();
        block0: while (rules.hasNext()) {
            AssetItem head = (AssetItem)rules.next();
            if (head.sameState(state)) {
                result.add(head);
                continue;
            }
            if (head.sameState(ignoreState)) continue;
            ArrayList<AssetItem> fullHistory = new ArrayList<AssetItem>();
            AssetHistoryIterator iter = head.getHistory();
            while (iter.hasNext()) {
                AssetItem element = (AssetItem)iter.next();
                if (element.getVersionNumber() == 0L) continue;
                fullHistory.add(element);
            }
            this.sortHistoryByVersionNumber(fullHistory);
            Iterator prev = fullHistory.iterator();
            while (prev.hasNext()) {
                AssetItem prevRule = (AssetItem)prev.next();
                if (!prevRule.sameState(state)) continue;
                result.add(prevRule);
                continue block0;
            }
        }
        return result.iterator();
    }

    void sortHistoryByVersionNumber(List fullHistory) {
        Collections.sort(fullHistory, new Comparator(){

            public int compare(Object o1, Object o2) {
                long la2;
                AssetItem a1 = (AssetItem)o1;
                AssetItem a2 = (AssetItem)o2;
                long la1 = a1.getVersionNumber();
                if (la1 == (la2 = a2.getVersionNumber())) {
                    return 0;
                }
                if (la1 < la2) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public Iterator getAssetsWithStatus(StateItem state) {
        return this.getAssetsWithStatus(state, null);
    }

    public String getHeader() {
        return this.getStringProperty(HEADER_PROPERTY_NAME);
    }

    public String getExternalURI() {
        return this.getStringProperty(EXTERNAL_URI_PROPERTY_NAME);
    }

    public void updateHeader(String header) {
        this.updateStringProperty(header, HEADER_PROPERTY_NAME);
    }

    public void updateExternalURI(String uri) {
        this.updateStringProperty(uri, EXTERNAL_URI_PROPERTY_NAME);
    }

    public void updateCheckinComment(String comment) {
        this.updateStringProperty(comment, "drools:checkinComment");
    }

    public void changeStatus(String newState) {
        StateItem stateItem = this.rulesRepository.getState(newState);
        this.updateState(stateItem);
        Iterator iter = this.getAssets();
        while (iter.hasNext()) {
            AssetItem element = (AssetItem)iter.next();
            element.updateState(stateItem);
        }
    }

    public PackageItem updateCompiledPackage(InputStream data) {
        this.checkout();
        try {
            this.node.setProperty(COMPILED_PACKAGE_PROPERTY_NAME, data);
            this.node.setProperty("drools:lastModified", Calendar.getInstance());
            return this;
        }
        catch (RepositoryException e) {
            log.error((Object)"Unable to update the assets binary content", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public byte[] getCompiledPackageBytes() {
        try {
            Node ruleNode = this.getVersionContentNode();
            if (ruleNode.hasProperty(COMPILED_PACKAGE_PROPERTY_NAME)) {
                int offset;
                Property data = ruleNode.getProperty(COMPILED_PACKAGE_PROPERTY_NAME);
                InputStream in = data.getStream();
                byte[] bytes = new byte[(int)data.getLength()];
                int numRead = 0;
                for (offset = 0; offset < bytes.length && (numRead = in.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
                if (offset < bytes.length) {
                    throw new RulesRepositoryException("Could not completely read binary package for " + this.getName());
                }
                in.close();
                return bytes;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException(e);
        }
    }
}

