/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Declaration;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.util.StringUtils;
import org.mvel.MVELTemplateRegistry;
import org.mvel.TemplateInterpreter;
import org.mvel.TemplateRegistry;

public class AbstractJavaBuilder {
    protected static final TemplateRegistry RULE_REGISTRY = new MVELTemplateRegistry();
    protected static final TemplateRegistry INVOKER_REGISTRY = new MVELTemplateRegistry();

    public TemplateRegistry getRuleTemplateRegistry() {
        return RULE_REGISTRY;
    }

    public TemplateRegistry getInvokerTemplateRegistry() {
        return INVOKER_REGISTRY;
    }

    public Map createVariableContext(String className, String text, RuleBuildContext context, Declaration[] declarations, Declaration[] localDeclarations, String[] globals) {
        int i;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("methodName", className);
        map.put("package", context.getPkg().getName());
        map.put("ruleClassName", StringUtils.ucFirst(context.getRuleDescr().getClassName()));
        map.put("invokerClassName", context.getRuleDescr().getClassName() + StringUtils.ucFirst(className) + "Invoker");
        if (text != null) {
            map.put("text", text);
            map.put("hashCode", new Integer(text.hashCode()));
        }
        String[] declarationTypes = new String[declarations.length];
        int size = declarations.length;
        for (int i2 = 0; i2 < size; ++i2) {
            declarationTypes[i2] = ((JavaDialect)context.getDialect()).getTypeFixer().fix(declarations[i2]);
        }
        map.put("declarations", declarations);
        map.put("declarationTypes", declarationTypes);
        if (localDeclarations != null) {
            String[] localDeclarationTypes = new String[localDeclarations.length];
            int size2 = localDeclarations.length;
            for (i = 0; i < size2; ++i) {
                localDeclarationTypes[i] = ((JavaDialect)context.getDialect()).getTypeFixer().fix(localDeclarations[i]);
            }
            map.put("localDeclarations", localDeclarations);
            map.put("localDeclarationTypes", localDeclarationTypes);
        }
        ArrayList<String> globalTypes = new ArrayList<String>(globals.length);
        int length = globals.length;
        for (i = 0; i < length; ++i) {
            globalTypes.add(((Class)context.getPkg().getGlobals().get(globals[i])).getName().replace('$', '.'));
        }
        map.put("globals", globals);
        map.put("globalTypes", globalTypes);
        return map;
    }

    public void generatTemplates(String ruleTemplate, String invokerTemplate, RuleBuildContext context, String className, Map vars, Object invokerLookup, BaseDescr descrLookup) {
        TemplateRegistry registry = this.getRuleTemplateRegistry();
        context.getMethods().add(TemplateInterpreter.parse(registry.getTemplate(ruleTemplate), null, vars, registry));
        registry = this.getInvokerTemplateRegistry();
        String invokerClassName = context.getPkg().getName() + "." + context.getRuleDescr().getClassName() + StringUtils.ucFirst(className) + "Invoker";
        context.getInvokers().put(invokerClassName, TemplateInterpreter.parse(registry.getTemplate(invokerTemplate), null, vars, registry));
        context.getInvokerLookups().put(invokerClassName, invokerLookup);
        context.getDescrLookups().put(invokerClassName, descrLookup);
    }

    static {
        RULE_REGISTRY.registerTemplate(new InputStreamReader(AbstractJavaBuilder.class.getResourceAsStream("javaRule.mvel")));
        INVOKER_REGISTRY.registerTemplate(new InputStreamReader(AbstractJavaBuilder.class.getResourceAsStream("javaInvokers.mvel")));
        MVELDialect.setLanguageLevel(4);
    }
}

