/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.osgi.EndpointWrapper;
import org.apache.servicemix.common.osgi.EndpointWrapperImpl;
import org.apache.servicemix.jbi.deployer.DeployedAssembly;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointExporter
implements BundleContextAware,
ApplicationContextAware,
InitializingBean,
DisposableBean,
DeployedAssembly {
    private BundleContext bundleContext;
    private ApplicationContext applicationContext;
    private Collection<Endpoint> endpoints;
    private String assemblyName;
    private Collection<ServiceRegistration> endpointRegistrations;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEndpoints(Collection<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public Collection<Endpoint> getEndpoints() {
        Collection<Endpoint> eps = this.endpoints;
        if (eps == null) {
            eps = this.applicationContext.getBeansOfType(Endpoint.class).values();
        }
        return eps;
    }

    @Override
    public String getName() {
        return this.assemblyName;
    }

    @Override
    public void deploy() {
        this.endpointRegistrations = new ArrayList<ServiceRegistration>();
        for (Endpoint ep : this.getEndpoints()) {
            EndpointWrapperImpl wrapper = new EndpointWrapperImpl(ep, this.applicationContext.getClassLoader());
            Properties props = new Properties();
            ServiceRegistration reg = this.bundleContext.registerService(EndpointWrapper.class.getName(), (Object)wrapper, (Dictionary)props);
            this.endpointRegistrations.add(reg);
        }
    }

    @Override
    public Map<String, String> getServiceUnits() {
        if (this.endpointRegistrations == null) {
            throw new IllegalStateException("Service assembly has not been deployed");
        }
        HashMap<String, String> sus = new HashMap<String, String>();
        for (Endpoint ep : this.getEndpoints()) {
            if (ep.getServiceUnit() == null) {
                throw new IllegalStateException("Endpoint has not been ");
            }
            sus.put(ep.getServiceUnit().getName(), ep.getServiceUnit().getComponent().getComponentName());
        }
        return sus;
    }

    public void afterPropertiesSet() throws Exception {
        this.assemblyName = this.bundleContext.getBundle().getSymbolicName();
        this.bundleContext.registerService(DeployedAssembly.class.getName(), (Object)this, (Dictionary)new Properties());
    }

    public void destroy() throws Exception {
        if (this.endpointRegistrations != null) {
            for (ServiceRegistration reg : this.endpointRegistrations) {
                reg.unregister();
            }
        }
    }
}

