/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.jaas.boot;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyLoginModule
implements LoginModule {
    public static final String PROPERTY_MODULE = "org.apache.servicemix.kernel.jaas.module";
    public static final String PROPERTY_BUNDLE = "org.apache.servicemix.kernel.jaas.bundle";
    private static BundleContext bundleContext = null;
    private LoginModule target = null;

    public static void init(BundleContext context) {
        bundleContext = context;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (bundleContext == null) {
            throw new IllegalStateException("ProxyLoginModule not initialized. Init must be called prior any invocation.");
        }
        HashMap newOptions = new HashMap(options);
        String module = (String)newOptions.remove(PROPERTY_MODULE);
        if (module == null) {
            throw new IllegalStateException("Option org.apache.servicemix.kernel.jaas.module must be set to the name of the factory service");
        }
        String bundleId = (String)newOptions.remove(PROPERTY_BUNDLE);
        if (bundleId == null) {
            throw new IllegalStateException("Option org.apache.servicemix.kernel.jaas.bundle must be set to the name of the factory service");
        }
        Bundle bundle = bundleContext.getBundle(Long.parseLong(bundleId));
        if (bundle == null) {
            throw new IllegalStateException("No bundle found for id " + bundleId);
        }
        try {
            this.target = (LoginModule)bundle.loadClass(module).newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not load or create login module " + module + " for bundle " + bundleId, e);
        }
        this.target.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    public boolean login() throws LoginException {
        return this.target.login();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.target.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.target.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.target.logout();
    }
}

