/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import org.apache.geronimo.gshell.ExitNotification;
import org.apache.geronimo.gshell.remote.client.RemoteExecuteException;
import org.apache.geronimo.gshell.remote.client.handler.EchoHandler;
import org.apache.geronimo.gshell.remote.crypto.CryptoContext;
import org.apache.geronimo.gshell.whisper.stream.StreamFeeder;
import org.apache.geronimo.gshell.whisper.transport.TransportException;
import org.apache.geronimo.gshell.whisper.transport.TransportFactory;
import org.apache.geronimo.gshell.whisper.transport.TransportFactoryLocator;
import org.apache.geronimo.gshell.whisper.transport.tcp.SpringTcpTransportFactory;
import org.apache.servicemix.kernel.client.RshClient;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block25: {
            URI address = new URI("tcp://127.0.0.1:8101/");
            String user = "smx";
            String password = "smx";
            StringBuilder sb = new StringBuilder();
            boolean options = true;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].charAt(0) == '-') {
                    if (args[i].equals("-a")) {
                        address = new URI(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-u")) {
                        user = args[++i];
                        continue;
                    }
                    if (args[i].equals("-p")) {
                        password = args[++i];
                        continue;
                    }
                    if (args[i].equals("--help")) {
                        System.out.println("Apache ServiceMix Kernel client");
                        System.out.println("  -a [address]  specify the URL to connect to");
                        System.out.println("  -u [user]     specify the user name");
                        System.out.println("  -p [password] specify the password");
                        System.out.println("  --help        shows this help message");
                        System.out.println("  [commands]    commands to run");
                        System.out.println("If no commands are specified, the client will be put in an interactive mode");
                        continue;
                    }
                    System.err.println("Unknown option: " + args[i]);
                    System.err.println("Run with --help for usage");
                    System.exit(1);
                    continue;
                }
                sb.append(args[i]);
                sb.append(' ');
                options = false;
            }
            RshClient client = null;
            try {
                CryptoContext context = new CryptoContext("RSA", null);
                LinkedList<EchoHandler> handlers = new LinkedList<EchoHandler>();
                handlers.add(new EchoHandler());
                client = new RshClient(context, (TransportFactoryLocator)new Locator(), handlers){

                    protected void onSessionClosed() {
                        System.exit(2);
                    }
                };
                client.initialize();
                client.connect(address, new URI("tcp://0.0.0.0:0"));
                client.login(user, password);
                StreamFeeder outputFeeder = new StreamFeeder(client.getInputStream(), (OutputStream)System.out);
                outputFeeder.createThread().start();
                client.openShell();
                System.out.println("Connected");
                String commandLine = sb.toString().trim();
                if (commandLine.length() > 0) {
                    client.execute(commandLine);
                    break block25;
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                while (true) {
                    System.out.print("> ");
                    String s = r.readLine().trim();
                    if (s.length() <= 0) continue;
                    try {
                        client.execute(s);
                    }
                    catch (RemoteExecuteException e) {
                        String name = e.getCause().getClass().getName();
                        name = name.substring(name.lastIndexOf(46) + 1);
                        System.err.println(name + ": " + e.getCause().getMessage());
                    }
                }
            }
            catch (ExitNotification e) {
                System.exit(0);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(1);
            }
            finally {
                try {
                    client.closeShell();
                    client.close();
                }
                catch (Throwable t) {}
            }
        }
        System.exit(0);
    }

    private static class Locator
    implements TransportFactoryLocator {
        SpringTcpTransportFactory factory = new SpringTcpTransportFactory();

        private Locator() {
        }

        public TransportFactory locate(URI arg0) throws TransportException {
            return this.factory;
        }
    }
}

