/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.bindings.soap.interceptors;

import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.model.Operation;
import org.apache.servicemix.soap.bindings.soap.model.SoapOperation;
import org.apache.servicemix.soap.core.AbstractInterceptor;

public class SoapActionOutOperationInterceptor
extends AbstractInterceptor {
    public void handleMessage(Message message) {
        Operation operation = message.get(Operation.class);
        if (!(operation instanceof SoapOperation)) {
            return;
        }
        SoapOperation soapOp = (SoapOperation)operation;
        String soapAction = ((SoapOperation)operation).getSoapAction();
        if (soapAction != null) {
            if (!soapAction.startsWith("\"") || !soapAction.endsWith("\"")) {
                soapAction = "\"" + soapAction + "\"";
            }
        } else {
            soapAction = "\"\"";
        }
        message.getTransportHeaders().put("SOAPAction", soapAction);
    }
}

