/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.shutdown;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.ObjectUtils;

public class BundleDependencyComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = -108354908478230663L;
    private static final Log log = LogFactory.getLog((Class)BundleDependencyComparator.class);

    public int compare(Object a, Object b) {
        boolean trace = log.isTraceEnabled();
        Bundle bundle1 = (Bundle)a;
        Bundle bundle2 = (Bundle)b;
        if (trace) {
            log.trace((Object)("comparing bundle1 [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle1) + "] w/ bundle2 [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle2) + "].."));
        }
        if (bundle1 == null) {
            if (bundle2 == null) {
                return 0;
            }
            return 1;
        }
        if (bundle2 == null) {
            return -1;
        }
        if (bundle1.equals(bundle2)) {
            return 0;
        }
        boolean b1Lower = this.references(bundle2, bundle1);
        boolean b2Lower = this.references(bundle1, bundle2);
        if (b1Lower && !b2Lower) {
            return 1;
        }
        if (b2Lower && !b1Lower) {
            return -1;
        }
        if (b1Lower && b2Lower && log.isInfoEnabled()) {
            log.info((Object)("circular service dependency detected between [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle1) + ", " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle2) + "]"));
        }
        int compare = this.compareUsingServiceRankingAndId(bundle1, bundle2);
        if (trace) {
            log.trace((Object)("comparison of [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle1) + ", " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle2) + "] based on service ranking/id was won by bundle " + (compare > 0 ? "1" : "2")));
        }
        return compare;
    }

    protected boolean references(Bundle a, Bundle b) {
        boolean ref = this.references(a, b, new HashSet());
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)a) + "] " + (ref ? "->" : "!->") + "[" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)b) + "]"));
        }
        return ref;
    }

    protected boolean references(Bundle a, Bundle b, Set seen) {
        if (seen.contains(b)) {
            return false;
        }
        seen.add(b);
        ServiceReference[] services = b.getRegisteredServices();
        if (services == null) {
            return false;
        }
        for (int i = 0; i < services.length; ++i) {
            Bundle[] referingBundles;
            if (!this.isSpringManagedService(services[i]) || (referingBundles = services[i].getUsingBundles()) == null) continue;
            for (int j = 0; j < referingBundles.length; ++j) {
                if (a.equals(referingBundles[j])) {
                    return true;
                }
                if (!this.references(a, referingBundles[j], seen)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpringManagedService(ServiceReference reference) {
        if (reference == null) {
            return false;
        }
        return reference.getProperty("org.springframework.osgi.bean.name") != null || reference.getProperty("org.springframework.context.service.name") != null;
    }

    private ServiceReference[] excludeNonSpringManagedServices(ServiceReference[] references) {
        if (ObjectUtils.isEmpty((Object[])references)) {
            return references;
        }
        int count = 0;
        for (int i = 0; i < references.length; ++i) {
            if (!this.isSpringManagedService(references[i])) {
                references[i] = null;
                continue;
            }
            ++count;
        }
        if (count == references.length) {
            return references;
        }
        ServiceReference[] refs = new ServiceReference[count];
        int j = 0;
        for (int i = 0; i < references.length; ++i) {
            if (references[i] == null) continue;
            refs[j] = references[i];
            ++j;
        }
        return refs;
    }

    protected int compareUsingServiceRankingAndId(Bundle a, Bundle b) {
        long bMaxId;
        int bRank;
        Object[] aservices = this.excludeNonSpringManagedServices(a.getRegisteredServices());
        Object[] bservices = this.excludeNonSpringManagedServices(b.getRegisteredServices());
        boolean trace = log.isTraceEnabled();
        if (ObjectUtils.isEmpty((Object[])aservices) && ObjectUtils.isEmpty((Object[])bservices)) {
            if (trace) {
                log.trace((Object)"both services have 0 services; sorting based on id");
            }
            return (int)(a.getBundleId() - b.getBundleId());
        }
        if (aservices == null) {
            return -1;
        }
        if (bservices == null) {
            return 1;
        }
        int aRank = this.findHighestServiceRanking((ServiceReference[])aservices);
        if (aRank != (bRank = this.findHighestServiceRanking((ServiceReference[])bservices))) {
            int compare = -(bRank - aRank);
            if (trace) {
                int min = compare > 0 ? bRank : aRank;
                log.trace((Object)("sorting based on lowest-service-ranking won by bundle" + (compare > 0 ? "1" : "2") + " w/ service id " + min));
            }
            return -(bRank - aRank);
        }
        long aMaxId = this.findHighestServiceId((ServiceReference[])aservices);
        if (aMaxId != (bMaxId = this.findHighestServiceId((ServiceReference[])bservices))) {
            int compare = (int)(bMaxId - aMaxId);
            if (trace) {
                int max = compare > 0 ? (int)bMaxId : (int)aMaxId;
                log.trace((Object)("sorting based on highest-service-id won by bundle " + (compare > 0 ? "1" : "2") + " w/ service id " + max));
            }
            return compare;
        }
        return (int)(a.getBundleId() - b.getBundleId());
    }

    private int findHighestServiceRanking(ServiceReference[] refs) {
        int maxRank = Integer.MIN_VALUE;
        for (int i = 0; i < refs.length; ++i) {
            int currentRank = OsgiServiceReferenceUtils.getServiceRanking((ServiceReference)refs[i]);
            if (currentRank <= maxRank) continue;
            maxRank = currentRank;
        }
        return maxRank;
    }

    private long findHighestServiceId(ServiceReference[] refs) {
        long maxId = Long.MIN_VALUE;
        for (int i = 0; i < refs.length; ++i) {
            long currentId = OsgiServiceReferenceUtils.getServiceId((ServiceReference)refs[i]);
            if (currentId <= maxId) continue;
            maxId = currentId;
        }
        return maxId;
    }
}

