/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.JdkVersion;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.osgi.context.ConfigurableOsgiBundleApplicationContext;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEventMulticaster;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEventMulticasterAdapter;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;
import org.springframework.osgi.extender.OsgiApplicationContextCreator;
import org.springframework.osgi.extender.OsgiBeanFactoryPostProcessor;
import org.springframework.osgi.extender.OsgiServiceDependencyFactory;
import org.springframework.osgi.extender.internal.dependencies.startup.MandatoryImporterDependencyFactory;
import org.springframework.osgi.extender.support.DefaultOsgiApplicationContextCreator;
import org.springframework.osgi.util.BundleDelegatingClassLoader;
import org.springframework.scheduling.timer.TimerTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ExtenderConfiguration
implements DisposableBean {
    private static final Log log = LogFactory.getLog((Class)ExtenderConfiguration.class);
    private static final String TASK_EXECUTOR_NAME = "taskExecutor";
    private static final String SHUTDOWN_TASK_EXECUTOR_NAME = "shutdownTaskExecutor";
    private static final String CONTEXT_CREATOR_NAME = "applicationContextCreator";
    private static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "osgiApplicationEventMulticaster";
    private static final String PROPERTIES_NAME = "extenderProperties";
    private static final String SHUTDOWN_WAIT_KEY = "shutdown.wait.time";
    private static final String PROCESS_ANNOTATIONS_KEY = "process.annotations";
    private static final String EXTENDER_CFG_LOCATION = "META-INF/spring/extender";
    private static final String XML_PATTERN = "*.xml";
    private static final String ANNOTATION_DEPENDENCY_FACTORY = "ANNOTATION FACTORY";
    private static final long DEFAULT_SHUTDOWN_WAIT = 10000L;
    private static final boolean DEFAULT_PROCESS_ANNOTATION = false;
    private ConfigurableOsgiBundleApplicationContext extenderConfiguration;
    private TaskExecutor taskExecutor;
    private TaskExecutor shutdownTaskExecutor;
    private boolean isTaskExecutorManagedInternally = false;
    private boolean isShutdownTaskExecutorManagedInternally = false;
    private boolean isMulticasterManagedInternally = false;
    private long shutdownWaitTime;
    private boolean processAnnotation;
    private OsgiBundleApplicationContextEventMulticaster eventMulticaster;
    private boolean forceThreadShutdown;
    private OsgiApplicationContextCreator contextCreator;
    private final ClassLoader classLoader;
    private final List postProcessors = new ArrayList(0);
    private final List dependencyFactories = new ArrayList(0);

    public ExtenderConfiguration(BundleContext bundleContext) {
        Bundle bundle = bundleContext.getBundle();
        Properties properties = new Properties(this.createDefaultProperties());
        Enumeration enm = bundle.findEntries(EXTENDER_CFG_LOCATION, XML_PATTERN, false);
        if (enm == null) {
            log.info((Object)"No custom extender configuration detected; using defaults...");
            this.taskExecutor = this.createDefaultTaskExecutor();
            this.shutdownTaskExecutor = this.createDefaultShutdownTaskExecutor();
            this.eventMulticaster = this.createDefaultEventMulticaster();
            this.isMulticasterManagedInternally = true;
            this.contextCreator = this.createDefaultApplicationContextCreator();
            this.classLoader = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)bundle);
        } else {
            Object[] configs = this.copyEnumerationToList(enm);
            log.info((Object)("Detected extender custom configurations at " + ObjectUtils.nullSafeToString((Object[])configs)));
            this.extenderConfiguration = new OsgiBundleXmlApplicationContext((String[])configs);
            this.extenderConfiguration.setBundleContext(bundleContext);
            this.extenderConfiguration.refresh();
            TaskExecutor taskExecutor = this.extenderConfiguration.containsBean(TASK_EXECUTOR_NAME) ? (TaskExecutor)this.extenderConfiguration.getBean(TASK_EXECUTOR_NAME, TaskExecutor.class) : (this.taskExecutor = this.createDefaultTaskExecutor());
            TaskExecutor taskExecutor2 = this.extenderConfiguration.containsBean(SHUTDOWN_TASK_EXECUTOR_NAME) ? (TaskExecutor)this.extenderConfiguration.getBean(SHUTDOWN_TASK_EXECUTOR_NAME, TaskExecutor.class) : (this.shutdownTaskExecutor = this.createDefaultShutdownTaskExecutor());
            OsgiBundleApplicationContextEventMulticaster osgiBundleApplicationContextEventMulticaster = this.extenderConfiguration.containsBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME) ? (OsgiBundleApplicationContextEventMulticaster)this.extenderConfiguration.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, OsgiBundleApplicationContextEventMulticaster.class) : (this.eventMulticaster = this.createDefaultEventMulticaster());
            this.contextCreator = this.extenderConfiguration.containsBean(CONTEXT_CREATOR_NAME) ? (OsgiApplicationContextCreator)this.extenderConfiguration.getBean(CONTEXT_CREATOR_NAME, OsgiApplicationContextCreator.class) : this.createDefaultApplicationContextCreator();
            this.postProcessors.addAll(this.extenderConfiguration.getBeansOfType(OsgiBeanFactoryPostProcessor.class).values());
            this.dependencyFactories.addAll(this.extenderConfiguration.getBeansOfType(OsgiServiceDependencyFactory.class).values());
            this.classLoader = this.extenderConfiguration.getClassLoader();
            if (this.extenderConfiguration.containsBean(PROPERTIES_NAME)) {
                Properties customProperties = (Properties)this.extenderConfiguration.getBean(PROPERTIES_NAME, Properties.class);
                Enumeration<?> propertyKey = customProperties.propertyNames();
                while (propertyKey.hasMoreElements()) {
                    String property = (String)propertyKey.nextElement();
                    properties.setProperty(property, customProperties.getProperty(property));
                }
            }
        }
        this.shutdownWaitTime = this.getShutdownWaitTime(properties);
        this.processAnnotation = this.getProcessAnnotations(properties);
        this.addDefaultDependencyFactories();
    }

    public void destroy() {
        if (this.isMulticasterManagedInternally) {
            this.eventMulticaster.removeAllListeners();
            this.eventMulticaster = null;
        }
        if (this.extenderConfiguration != null) {
            this.extenderConfiguration.close();
            this.extenderConfiguration = null;
        }
        if (this.forceThreadShutdown) {
            if (this.isTaskExecutorManagedInternally) {
                log.warn((Object)"Forcing the (internally created) taskExecutor to stop...");
                ThreadGroup th = ((SimpleAsyncTaskExecutor)this.taskExecutor).getThreadGroup();
                if (!th.isDestroyed()) {
                    th.interrupt();
                }
            }
            this.taskExecutor = null;
        }
        if (this.isShutdownTaskExecutorManagedInternally) {
            try {
                ((DisposableBean)this.shutdownTaskExecutor).destroy();
            }
            catch (Exception ex) {
                log.debug((Object)"Received exception while shutting down shutdown task executor", (Throwable)ex);
            }
            this.shutdownTaskExecutor = null;
        }
    }

    private String[] copyEnumerationToList(Enumeration enm) {
        ArrayList<String> urls = new ArrayList<String>(4);
        while (enm != null && enm.hasMoreElements()) {
            URL configURL = (URL)enm.nextElement();
            String configURLAsString = configURL.toExternalForm();
            try {
                urls.add(URLDecoder.decode(configURLAsString, "UTF8"));
            }
            catch (UnsupportedEncodingException uee) {
                log.warn((Object)"UTF8 encoding not supported, using the platform default");
                urls.add(URLDecoder.decode(configURLAsString));
            }
        }
        return urls.toArray(new String[urls.size()]);
    }

    private Properties createDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty(SHUTDOWN_WAIT_KEY, "10000");
        properties.setProperty(PROCESS_ANNOTATIONS_KEY, "false");
        return properties;
    }

    private void addDefaultDependencyFactories() {
        boolean debug = log.isDebugEnabled();
        this.dependencyFactories.add(0, new MandatoryImporterDependencyFactory());
        if (this.processAnnotation) {
            if (JdkVersion.isAtLeastJava15()) {
                Class<?> annotationProcessor = null;
                try {
                    annotationProcessor = Class.forName(ANNOTATION_DEPENDENCY_FACTORY, false, ExtenderConfiguration.class.getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    log.warn((Object)"Spring-DM annotation package not found, annotation processing disabled.", (Throwable)cnfe);
                    return;
                }
                Object processor = BeanUtils.instantiateClass(annotationProcessor);
                Assert.isInstanceOf((Class)OsgiServiceDependencyFactory.class, (Object)processor);
                this.dependencyFactories.add(1, (OsgiServiceDependencyFactory)processor);
                if (debug) {
                    log.debug((Object)"Succesfully loaded annotation dependency processor [ANNOTATION FACTORY]");
                }
            } else if (debug) {
                log.debug((Object)"JDK 5 not available [ANNOTATION FACTORY] not loaded");
            }
        } else if (debug) {
            log.debug((Object)"Annotation processing disabled; [ANNOTATION FACTORY] not loaded");
        }
    }

    private TaskExecutor createDefaultTaskExecutor() {
        ThreadGroup threadGroup = new ThreadGroup("spring-osgi-extender[" + ObjectUtils.getIdentityHexString((Object)this) + "]-threads");
        threadGroup.setDaemon(false);
        SimpleAsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
        taskExecutor.setThreadGroup(threadGroup);
        taskExecutor.setThreadNamePrefix("SpringOsgiExtenderThread-");
        this.isTaskExecutorManagedInternally = true;
        return taskExecutor;
    }

    private TaskExecutor createDefaultShutdownTaskExecutor() {
        TimerTaskExecutor taskExecutor = new TimerTaskExecutor();
        taskExecutor.afterPropertiesSet();
        this.isShutdownTaskExecutorManagedInternally = true;
        return taskExecutor;
    }

    private OsgiBundleApplicationContextEventMulticaster createDefaultEventMulticaster() {
        return new OsgiBundleApplicationContextEventMulticasterAdapter((ApplicationEventMulticaster)new SimpleApplicationEventMulticaster());
    }

    private OsgiApplicationContextCreator createDefaultApplicationContextCreator() {
        return new DefaultOsgiApplicationContextCreator();
    }

    private long getShutdownWaitTime(Properties properties) {
        return Long.parseLong(properties.getProperty(SHUTDOWN_WAIT_KEY));
    }

    private boolean getProcessAnnotations(Properties properties) {
        return Boolean.valueOf(properties.getProperty(PROCESS_ANNOTATIONS_KEY));
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public TaskExecutor getShutdownTaskExecutor() {
        return this.shutdownTaskExecutor;
    }

    public long getShutdownWaitTime() {
        return this.shutdownWaitTime;
    }

    public boolean shouldProcessAnnotation() {
        return this.processAnnotation;
    }

    public OsgiBundleApplicationContextEventMulticaster getEventMulticaster() {
        return this.eventMulticaster;
    }

    public void setForceThreadShutdown(boolean forceThreadShutdown) {
        this.forceThreadShutdown = forceThreadShutdown;
    }

    public OsgiApplicationContextCreator getContextCreator() {
        return this.contextCreator;
    }

    public List getPostProcessors() {
        return this.postProcessors;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List getDependencyFactories() {
        return this.dependencyFactories;
    }
}

