/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

public class ManagementAgent
implements DisposableBean {
    private static final transient Log LOG = LogFactory.getLog(ManagementAgent.class);
    private MBeanServer mbeanServer;
    private MetadataMBeanInfoAssembler assembler;
    private Set<ObjectName> mbeans = new HashSet<ObjectName>();

    public ManagementAgent() {
        this.assembler = new MetadataMBeanInfoAssembler();
        this.assembler.setAttributeSource((JmxAttributeSource)new AnnotationJmxAttributeSource());
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void destroy() throws Exception {
        Object[] mBeans = this.mbeans.toArray();
        int caught = 0;
        for (Object name : mBeans) {
            this.mbeans.remove((ObjectName)name);
            try {
                this.unregister((ObjectName)name);
            }
            catch (JMException jmex) {
                LOG.info((Object)"Exception unregistering MBean", (Throwable)jmex);
                ++caught;
            }
        }
        if (caught > 0) {
            LOG.warn((Object)("A number of " + caught + " exceptions caught while unregistering MBeans during stop operation.  " + "See INFO log for details."));
        }
    }

    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        try {
            this.registerMBeanWithServer(obj, name, forceRegistration);
        }
        catch (NotCompliantMBeanException e) {
            ModelMBeanInfo mbi = this.assembler.getMBeanInfo(obj, name.toString());
            RequiredModelMBean mbean = (RequiredModelMBean)this.mbeanServer.instantiate(RequiredModelMBean.class.getName());
            mbean.setModelMBeanInfo(mbi);
            try {
                mbean.setManagedResource(obj, "ObjectReference");
            }
            catch (InvalidTargetObjectTypeException itotex) {
                throw new JMException(itotex.getMessage());
            }
            this.registerMBeanWithServer(mbean, name, forceRegistration);
        }
    }

    public void unregister(ObjectName name) throws JMException {
        this.mbeanServer.unregisterMBean(name);
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        ObjectInstance instance = null;
        try {
            instance = this.mbeanServer.registerMBean(obj, name);
        }
        catch (InstanceAlreadyExistsException e) {
            if (forceRegistration) {
                this.mbeanServer.unregisterMBean(name);
                instance = this.mbeanServer.registerMBean(obj, name);
            }
            throw e;
        }
        if (instance != null) {
            this.mbeans.add(name);
        }
    }
}

