/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicemix.nmr.management.stats.Statistic;

public class CountStatistic
extends Statistic {
    private final AtomicLong counter = new AtomicLong(0L);
    private CountStatistic parent;

    public CountStatistic(CountStatistic parent, String name, String description) {
        this(name, description);
        this.parent = parent;
    }

    public CountStatistic(String name, String description) {
        this(name, "count", description);
    }

    public CountStatistic(String name, String unit, String description) {
        super(name, unit, description);
    }

    public void reset() {
        super.reset();
        this.counter.set(0L);
    }

    public long getCount() {
        return this.counter.get();
    }

    public void setCount(long count) {
        this.counter.set(count);
    }

    public void add(long amount) {
        this.counter.addAndGet(amount);
        this.updateSampleTime();
        if (this.parent != null) {
            this.parent.add(amount);
        }
    }

    public void increment() {
        this.counter.incrementAndGet();
        this.updateSampleTime();
        if (this.parent != null) {
            this.parent.increment();
        }
    }

    public void subtract(long amount) {
        this.counter.addAndGet(-amount);
        this.updateSampleTime();
        if (this.parent != null) {
            this.parent.subtract(amount);
        }
    }

    public void decrement() {
        this.counter.decrementAndGet();
        this.updateSampleTime();
        if (this.parent != null) {
            this.parent.decrement();
        }
    }

    public CountStatistic getParent() {
        return this.parent;
    }

    public void setParent(CountStatistic parent) {
        this.parent = parent;
    }

    protected void appendFieldDescription(StringBuffer buffer) {
        buffer.append(" count: ");
        buffer.append(Long.toString(this.counter.get()));
        super.appendFieldDescription(buffer);
    }

    public double getPeriod() {
        double count = this.counter.get();
        if (count == 0.0) {
            return 0.0;
        }
        double time = System.currentTimeMillis() - this.getStartTime();
        return time / (count * 1000.0);
    }

    public double getFrequency() {
        double count = this.counter.get();
        double time = System.currentTimeMillis() - this.getStartTime();
        return count * 1000.0 / time;
    }
}

