/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.traversers;

import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaNamespaceSupport;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaSymbols;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaException;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaLoader;
import com.sun.org.apache.xerces.internal.impl.xs.XSComplexTypeDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSDDescription;
import com.sun.org.apache.xerces.internal.impl.xs.XSDeclarationPool;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSGrammarBucket;
import com.sun.org.apache.xerces.internal.impl.xs.XSGroupDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSModelGroupImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSParticleDecl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.ElementImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.SchemaDOM;
import com.sun.org.apache.xerces.internal.impl.xs.opti.SchemaDOMParser;
import com.sun.org.apache.xerces.internal.impl.xs.opti.SchemaParsingConfig;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.SchemaContentHandler;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSAnnotationInfo;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSAttributeChecker;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDAttributeGroupTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDAttributeTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDComplexTypeTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDElementTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDGroupTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDKeyrefTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDNotationTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDSimpleTypeTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDUniqueOrKeyTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDWildcardTraverser;
import com.sun.org.apache.xerces.internal.impl.xs.traversers.XSDocumentInfo;
import com.sun.org.apache.xerces.internal.impl.xs.util.SimpleLocator;
import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import com.sun.org.apache.xerces.internal.parsers.XML11Configuration;
import com.sun.org.apache.xerces.internal.util.DOMInputSource;
import com.sun.org.apache.xerces.internal.util.DOMUtil;
import com.sun.org.apache.xerces.internal.util.DefaultErrorHandler;
import com.sun.org.apache.xerces.internal.util.SAXInputSource;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.URI;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.grammars.Grammar;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarDescription;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLSchemaDescription;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xs.XSObject;
import com.sun.org.apache.xerces.internal.xs.XSParticle;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XSDHandler {
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String XMLSCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String STANDARD_URI_CONFORMANT_FEATURE = "http://apache.org/xml/features/standard-uri-conformant";
    protected static final String DISALLOW_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String VALIDATE_ANNOTATIONS = "http://apache.org/xml/features/validate-annotations";
    protected static final String HONOUR_ALL_SCHEMALOCATIONS = "http://apache.org/xml/features/honour-all-schemaLocations";
    private static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String SECURE_PROCESSING = "http://apache.org/xml/properties/security-manager";
    protected static final boolean DEBUG_NODE_POOL = false;
    static final int ATTRIBUTE_TYPE = 1;
    static final int ATTRIBUTEGROUP_TYPE = 2;
    static final int ELEMENT_TYPE = 3;
    static final int GROUP_TYPE = 4;
    static final int IDENTITYCONSTRAINT_TYPE = 5;
    static final int NOTATION_TYPE = 6;
    static final int TYPEDECL_TYPE = 7;
    public static final String REDEF_IDENTIFIER = "_fn3dktizrknc9pi";
    protected Hashtable fNotationRegistry = new Hashtable();
    protected XSDeclarationPool fDeclPool = null;
    protected SecurityManager fSecureProcessing = null;
    private Hashtable fUnparsedAttributeRegistry = new Hashtable();
    private Hashtable fUnparsedAttributeGroupRegistry = new Hashtable();
    private Hashtable fUnparsedElementRegistry = new Hashtable();
    private Hashtable fUnparsedGroupRegistry = new Hashtable();
    private Hashtable fUnparsedIdentityConstraintRegistry = new Hashtable();
    private Hashtable fUnparsedNotationRegistry = new Hashtable();
    private Hashtable fUnparsedTypeRegistry = new Hashtable();
    private Hashtable fUnparsedAttributeRegistrySub = new Hashtable();
    private Hashtable fUnparsedAttributeGroupRegistrySub = new Hashtable();
    private Hashtable fUnparsedElementRegistrySub = new Hashtable();
    private Hashtable fUnparsedGroupRegistrySub = new Hashtable();
    private Hashtable fUnparsedIdentityConstraintRegistrySub = new Hashtable();
    private Hashtable fUnparsedNotationRegistrySub = new Hashtable();
    private Hashtable fUnparsedTypeRegistrySub = new Hashtable();
    private Hashtable fXSDocumentInfoRegistry = new Hashtable();
    private Hashtable fDependencyMap = new Hashtable();
    private Hashtable fImportMap = new Hashtable();
    private Vector fAllTNSs = new Vector();
    private Hashtable fLocationPairs = null;
    private Hashtable fHiddenNodes = null;
    private Hashtable fTraversed = new Hashtable();
    private Hashtable fDoc2SystemId = new Hashtable();
    private XSDocumentInfo fRoot = null;
    private Hashtable fDoc2XSDocumentMap = new Hashtable();
    private Hashtable fRedefine2XSDMap = new Hashtable();
    private Hashtable fRedefine2NSSupport = new Hashtable();
    private Hashtable fRedefinedRestrictedAttributeGroupRegistry = new Hashtable();
    private Hashtable fRedefinedRestrictedGroupRegistry = new Hashtable();
    private boolean fLastSchemaWasDuplicate;
    private boolean fValidateAnnotations = false;
    private boolean fHonourAllSchemaLocations = false;
    private XMLErrorReporter fErrorReporter;
    private XMLEntityResolver fEntityResolver;
    private XSAttributeChecker fAttributeChecker;
    private SymbolTable fSymbolTable;
    private XSGrammarBucket fGrammarBucket;
    private XSDDescription fSchemaGrammarDescription;
    private XMLGrammarPool fGrammarPool;
    XSDAttributeGroupTraverser fAttributeGroupTraverser;
    XSDAttributeTraverser fAttributeTraverser;
    XSDComplexTypeTraverser fComplexTypeTraverser;
    XSDElementTraverser fElementTraverser;
    XSDGroupTraverser fGroupTraverser;
    XSDKeyrefTraverser fKeyrefTraverser;
    XSDNotationTraverser fNotationTraverser;
    XSDSimpleTypeTraverser fSimpleTypeTraverser;
    XSDUniqueOrKeyTraverser fUniqueOrKeyTraverser;
    XSDWildcardTraverser fWildCardTraverser;
    SchemaDOMParser fSchemaParser;
    SchemaContentHandler fXSContentHandler;
    XML11Configuration fAnnotationValidator;
    XSAnnotationGrammarPool fGrammarBucketAdapter;
    private static final int INIT_STACK_SIZE = 30;
    private static final int INC_STACK_SIZE = 10;
    private int fLocalElemStackPos = 0;
    private XSParticleDecl[] fParticle = new XSParticleDecl[30];
    private Element[] fLocalElementDecl = new Element[30];
    private XSDocumentInfo[] fLocalElementDecl_schema = new XSDocumentInfo[30];
    private int[] fAllContext = new int[30];
    private XSObject[] fParent = new XSObject[30];
    private String[][] fLocalElemNamespaceContext = new String[30][1];
    private static final int INIT_KEYREF_STACK = 2;
    private static final int INC_KEYREF_STACK_AMOUNT = 2;
    private int fKeyrefStackPos = 0;
    private Element[] fKeyrefs = new Element[2];
    private XSDocumentInfo[] fKeyrefsMapXSDocumentInfo = new XSDocumentInfo[2];
    private XSElementDecl[] fKeyrefElems = new XSElementDecl[2];
    private String[][] fKeyrefNamespaceContext = new String[2][1];
    private static final String[][] NS_ERROR_CODES = new String[][]{{"src-include.2.1", "src-include.2.1"}, {"src-redefine.3.1", "src-redefine.3.1"}, {"src-import.3.1", "src-import.3.2"}, null, {"TargetNamespace.1", "TargetNamespace.2"}, {"TargetNamespace.1", "TargetNamespace.2"}, {"TargetNamespace.1", "TargetNamespace.2"}, {"TargetNamespace.1", "TargetNamespace.2"}};
    private static final String[] ELE_ERROR_CODES = new String[]{"src-include.1", "src-redefine.2", "src-import.2", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4", "schema_reference.4"};
    private Vector fReportedTNS = null;
    private static final String[] COMP_TYPE = new String[]{null, "attribute declaration", "attribute group", "element declaration", "group", "identity constraint", "notation", "type definition"};
    private static final String[] CIRCULAR_CODES = new String[]{"Internal-Error", "Internal-Error", "src-attribute_group.3", "e-props-correct.6", "mg-props-correct.2", "Internal-Error", "Internal-Error", "st-props-correct.2"};
    private SimpleLocator xl = new SimpleLocator();

    private String null2EmptyString(String ns) {
        return ns == null ? XMLSymbols.EMPTY_STRING : ns;
    }

    private String emptyString2Null(String ns) {
        return ns == XMLSymbols.EMPTY_STRING ? null : ns;
    }

    private String doc2SystemId(Element ele) {
        String documentURI = null;
        if (ele.getOwnerDocument() instanceof SchemaDOM) {
            documentURI = ((SchemaDOM)ele.getOwnerDocument()).getDocumentURI();
        }
        return documentURI != null ? documentURI : (String)this.fDoc2SystemId.get(ele);
    }

    public XSDHandler() {
        this.fHiddenNodes = new Hashtable();
        this.fSchemaParser = new SchemaDOMParser(new SchemaParsingConfig());
    }

    public XSDHandler(XSGrammarBucket gBucket) {
        this();
        this.fGrammarBucket = gBucket;
        this.fSchemaGrammarDescription = new XSDDescription();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SchemaGrammar parseSchema(XMLInputSource is, XSDDescription desc, Hashtable locationPairs) throws IOException {
        this.fLocationPairs = locationPairs;
        this.fSchemaParser.resetNodePool();
        SchemaGrammar grammar = null;
        String schemaNamespace = null;
        short referType = desc.getContextType();
        if (referType != 3) {
            grammar = this.fHonourAllSchemaLocations && referType == 2 && this.isExistingGrammar(desc) ? this.fGrammarBucket.getGrammar(desc.getTargetNamespace()) : this.findGrammar(desc);
            if (grammar != null) {
                return grammar;
            }
            schemaNamespace = desc.getTargetNamespace();
            if (schemaNamespace != null) {
                schemaNamespace = this.fSymbolTable.addSymbol(schemaNamespace);
            }
        }
        this.prepareForParse();
        Document schemaRootDoc = null;
        Element schemaRoot = null;
        if (is instanceof DOMInputSource) {
            this.fHiddenNodes.clear();
            Node domNode = ((DOMInputSource)is).getNode();
            if (domNode instanceof Document) {
                schemaRootDoc = (Document)domNode;
                schemaRoot = DOMUtil.getRoot(schemaRootDoc);
            } else {
                if (!(domNode instanceof Element)) return null;
                schemaRoot = (Element)domNode;
            }
        } else if (is instanceof SAXInputSource) {
            XMLReader parser = ((SAXInputSource)is).getXMLReader();
            InputSource inputSource = ((SAXInputSource)is).getInputSource();
            boolean namespacePrefixes = false;
            if (parser != null) {
                try {
                    namespacePrefixes = parser.getFeature(NAMESPACE_PREFIXES);
                }
                catch (SAXException se) {}
            } else {
                try {
                    parser = XMLReaderFactory.createXMLReader();
                }
                catch (SAXException se) {
                    parser = new SAXParser();
                }
                try {
                    parser.setFeature(NAMESPACE_PREFIXES, true);
                    namespacePrefixes = true;
                }
                catch (SAXException se) {
                    // empty catch block
                }
            }
            boolean stringsInternalized = false;
            try {
                stringsInternalized = parser.getFeature(STRING_INTERNING);
            }
            catch (SAXException exc) {
                // empty catch block
            }
            if (this.fXSContentHandler == null) {
                this.fXSContentHandler = new SchemaContentHandler();
            }
            this.fXSContentHandler.reset(this.fSchemaParser, this.fSymbolTable, namespacePrefixes, stringsInternalized);
            parser.setContentHandler(this.fXSContentHandler);
            parser.setErrorHandler(this.fErrorReporter.getSAXErrorHandler());
            try {
                parser.parse(inputSource);
            }
            catch (SAXException se) {
                return null;
            }
            schemaRootDoc = this.fXSContentHandler.getDocument();
            if (schemaRootDoc == null) {
                return null;
            }
            schemaRoot = DOMUtil.getRoot(schemaRootDoc);
        } else {
            schemaRoot = this.getSchemaDocument(schemaNamespace, is, referType == 3, referType, null);
        }
        if (schemaRoot == null) {
            return null;
        }
        if (referType == 3) {
            Element schemaElem = schemaRoot;
            schemaNamespace = DOMUtil.getAttrValue(schemaElem, SchemaSymbols.ATT_TARGETNAMESPACE);
            if (schemaNamespace != null && schemaNamespace.length() > 0) {
                schemaNamespace = this.fSymbolTable.addSymbol(schemaNamespace);
                desc.setTargetNamespace(schemaNamespace);
            } else {
                schemaNamespace = null;
            }
            grammar = this.findGrammar(desc);
            if (grammar != null) {
                return grammar;
            }
            String schemaId = XMLEntityManager.expandSystemId(is.getSystemId(), is.getBaseSystemId(), false);
            XSDKey key = new XSDKey(schemaId, referType, schemaNamespace);
            this.fTraversed.put(key, schemaRoot);
            if (schemaId != null) {
                this.fDoc2SystemId.put(schemaRoot, schemaId);
            }
        }
        this.prepareForTraverse();
        this.fRoot = this.constructTrees(schemaRoot, is.getSystemId(), desc);
        if (this.fRoot == null) {
            return null;
        }
        this.buildGlobalNameRegistries();
        ArrayList annotationInfo = this.fValidateAnnotations ? new ArrayList() : null;
        this.traverseSchemas(annotationInfo);
        this.traverseLocalElements();
        this.resolveKeyRefs();
        for (int i = this.fAllTNSs.size() - 1; i >= 0; --i) {
            String tns = (String)this.fAllTNSs.elementAt(i);
            Vector ins = (Vector)this.fImportMap.get(tns);
            SchemaGrammar sg = this.fGrammarBucket.getGrammar(this.emptyString2Null(tns));
            if (sg == null) continue;
            int count = 0;
            for (int j = 0; j < ins.size(); ++j) {
                SchemaGrammar isg = this.fGrammarBucket.getGrammar((String)ins.elementAt(j));
                if (isg == null) continue;
                ins.setElementAt(isg, count++);
            }
            ins.setSize(count);
            sg.setImportedGrammars(ins);
        }
        if (!this.fValidateAnnotations || annotationInfo.size() <= 0) return this.fGrammarBucket.getGrammar(this.fRoot.fTargetNamespace);
        this.validateAnnotations(annotationInfo);
        return this.fGrammarBucket.getGrammar(this.fRoot.fTargetNamespace);
    }

    private void validateAnnotations(ArrayList annotationInfo) {
        if (this.fAnnotationValidator == null) {
            this.createAnnotationValidator();
        }
        int size = annotationInfo.size();
        XMLInputSource src = new XMLInputSource(null, null, null);
        this.fGrammarBucketAdapter.refreshGrammars(this.fGrammarBucket);
        for (int i = 0; i < size; i += 2) {
            src.setSystemId((String)annotationInfo.get(i));
            XSAnnotationInfo annotation = (XSAnnotationInfo)annotationInfo.get(i + 1);
            while (annotation != null) {
                src.setCharacterStream(new StringReader(annotation.fAnnotation));
                try {
                    this.fAnnotationValidator.parse(src);
                }
                catch (IOException exc) {
                    // empty catch block
                }
                annotation = annotation.next;
            }
        }
    }

    private void createAnnotationValidator() {
        this.fAnnotationValidator = new XML11Configuration();
        this.fGrammarBucketAdapter = new XSAnnotationGrammarPool();
        this.fAnnotationValidator.setFeature(VALIDATION, true);
        this.fAnnotationValidator.setFeature(XMLSCHEMA_VALIDATION, true);
        this.fAnnotationValidator.setProperty(XMLGRAMMAR_POOL, this.fGrammarBucketAdapter);
        XMLErrorHandler errorHandler = this.fErrorReporter.getErrorHandler();
        this.fAnnotationValidator.setProperty(ERROR_HANDLER, errorHandler != null ? errorHandler : new DefaultErrorHandler());
    }

    SchemaGrammar getGrammar(String tns) {
        return this.fGrammarBucket.getGrammar(tns);
    }

    protected SchemaGrammar findGrammar(XSDDescription desc) {
        SchemaGrammar sg = this.fGrammarBucket.getGrammar(desc.getTargetNamespace());
        if (sg == null && this.fGrammarPool != null && (sg = (SchemaGrammar)this.fGrammarPool.retrieveGrammar(desc)) != null && !this.fGrammarBucket.putGrammar(sg, true)) {
            this.reportSchemaWarning("GrammarConflict", null, null);
            sg = null;
        }
        return sg;
    }

    protected XSDocumentInfo constructTrees(Element schemaRoot, String locationHint, XSDDescription desc) {
        if (schemaRoot == null) {
            return null;
        }
        String callerTNS = desc.getTargetNamespace();
        short referType = desc.getContextType();
        XSDocumentInfo currSchemaInfo = null;
        try {
            currSchemaInfo = new XSDocumentInfo(schemaRoot, this.fAttributeChecker, this.fSymbolTable);
        }
        catch (XMLSchemaException se) {
            this.reportSchemaError(ELE_ERROR_CODES[referType], new Object[]{locationHint}, schemaRoot);
            return null;
        }
        if (currSchemaInfo.fTargetNamespace != null && currSchemaInfo.fTargetNamespace.length() == 0) {
            this.reportSchemaWarning("EmptyTargetNamespace", new Object[]{locationHint}, schemaRoot);
            currSchemaInfo.fTargetNamespace = null;
        }
        if (callerTNS != null) {
            int secondIdx = 0;
            if (referType == 0 || referType == 1) {
                if (currSchemaInfo.fTargetNamespace == null) {
                    currSchemaInfo.fTargetNamespace = callerTNS;
                    currSchemaInfo.fIsChameleonSchema = true;
                } else if (callerTNS != currSchemaInfo.fTargetNamespace) {
                    this.reportSchemaError(NS_ERROR_CODES[referType][secondIdx], new Object[]{callerTNS, currSchemaInfo.fTargetNamespace}, schemaRoot);
                    return null;
                }
            } else if (referType != 3 && callerTNS != currSchemaInfo.fTargetNamespace) {
                this.reportSchemaError(NS_ERROR_CODES[referType][secondIdx], new Object[]{callerTNS, currSchemaInfo.fTargetNamespace}, schemaRoot);
                return null;
            }
        } else if (currSchemaInfo.fTargetNamespace != null) {
            if (referType == 3) {
                desc.setTargetNamespace(currSchemaInfo.fTargetNamespace);
                callerTNS = currSchemaInfo.fTargetNamespace;
            } else {
                int secondIdx = 1;
                this.reportSchemaError(NS_ERROR_CODES[referType][secondIdx], new Object[]{callerTNS, currSchemaInfo.fTargetNamespace}, schemaRoot);
                return null;
            }
        }
        currSchemaInfo.addAllowedNS(currSchemaInfo.fTargetNamespace);
        SchemaGrammar sg = null;
        if (referType == 0 || referType == 1) {
            sg = this.fGrammarBucket.getGrammar(currSchemaInfo.fTargetNamespace);
        } else if (this.fHonourAllSchemaLocations && referType == 2) {
            sg = this.findGrammar(desc);
            if (sg == null) {
                sg = new SchemaGrammar(currSchemaInfo.fTargetNamespace, desc.makeClone(), this.fSymbolTable);
                this.fGrammarBucket.putGrammar(sg);
            }
        } else {
            sg = new SchemaGrammar(currSchemaInfo.fTargetNamespace, desc.makeClone(), this.fSymbolTable);
            this.fGrammarBucket.putGrammar(sg);
        }
        sg.addDocument(null, (String)this.fDoc2SystemId.get(currSchemaInfo.fSchemaElement));
        this.fDoc2XSDocumentMap.put(schemaRoot, currSchemaInfo);
        Vector<XSDocumentInfo> dependencies = new Vector<XSDocumentInfo>();
        Element rootNode = schemaRoot;
        Element newSchemaRoot = null;
        Element child = DOMUtil.getFirstChildElement(rootNode);
        while (child != null) {
            block45: {
                String localName;
                String schemaHint;
                block49: {
                    Object[] includeAttrs;
                    short refType;
                    String schemaNamespace;
                    block52: {
                        block50: {
                            String text;
                            block51: {
                                block46: {
                                    String tns;
                                    Vector<String> ins;
                                    block48: {
                                        block47: {
                                            Element importChild;
                                            schemaNamespace = null;
                                            schemaHint = null;
                                            localName = DOMUtil.getLocalName(child);
                                            refType = -1;
                                            if (localName.equals(SchemaSymbols.ELT_ANNOTATION)) break block45;
                                            if (!localName.equals(SchemaSymbols.ELT_IMPORT)) break block46;
                                            refType = 2;
                                            Object[] importAttrs = this.fAttributeChecker.checkAttributes(child, true, currSchemaInfo);
                                            schemaHint = (String)importAttrs[XSAttributeChecker.ATTIDX_SCHEMALOCATION];
                                            schemaNamespace = (String)importAttrs[XSAttributeChecker.ATTIDX_NAMESPACE];
                                            if (schemaNamespace != null) {
                                                schemaNamespace = this.fSymbolTable.addSymbol(schemaNamespace);
                                            }
                                            if (schemaNamespace == currSchemaInfo.fTargetNamespace) {
                                                this.reportSchemaError("src-import.1.1", new Object[]{schemaNamespace}, child);
                                            }
                                            if ((importChild = DOMUtil.getFirstChildElement(child)) != null) {
                                                String importComponentType = DOMUtil.getLocalName(importChild);
                                                if (importComponentType.equals(SchemaSymbols.ELT_ANNOTATION)) {
                                                    sg.addAnnotation(this.fElementTraverser.traverseAnnotationDecl(importChild, importAttrs, true, currSchemaInfo));
                                                } else {
                                                    this.reportSchemaError("s4s-elt-must-match.1", new Object[]{localName, "annotation?", importComponentType}, child);
                                                }
                                                if (DOMUtil.getNextSiblingElement(importChild) != null) {
                                                    this.reportSchemaError("s4s-elt-must-match.1", new Object[]{localName, "annotation?", DOMUtil.getLocalName(DOMUtil.getNextSiblingElement(importChild))}, child);
                                                }
                                            } else {
                                                text = DOMUtil.getSyntheticAnnotation(child);
                                                if (text != null) {
                                                    sg.addAnnotation(this.fElementTraverser.traverseSyntheticAnnotation(child, text, importAttrs, true, currSchemaInfo));
                                                }
                                            }
                                            this.fAttributeChecker.returnAttrArray(importAttrs, currSchemaInfo);
                                            if (!currSchemaInfo.isAllowedNS(schemaNamespace)) break block47;
                                            if (this.fHonourAllSchemaLocations) break block48;
                                            break block45;
                                        }
                                        currSchemaInfo.addAllowedNS(schemaNamespace);
                                    }
                                    if ((ins = (Vector<String>)this.fImportMap.get(tns = this.null2EmptyString(currSchemaInfo.fTargetNamespace))) == null) {
                                        this.fAllTNSs.addElement(tns);
                                        ins = new Vector<String>();
                                        this.fImportMap.put(tns, ins);
                                        ins.addElement(schemaNamespace);
                                    } else if (!ins.contains(schemaNamespace)) {
                                        ins.addElement(schemaNamespace);
                                    }
                                    this.fSchemaGrammarDescription.reset();
                                    this.fSchemaGrammarDescription.setContextType((short)2);
                                    this.fSchemaGrammarDescription.setBaseSystemId(this.doc2SystemId(schemaRoot));
                                    this.fSchemaGrammarDescription.setLocationHints(new String[]{schemaHint});
                                    this.fSchemaGrammarDescription.setTargetNamespace(schemaNamespace);
                                    if (!this.fHonourAllSchemaLocations && this.findGrammar(this.fSchemaGrammarDescription) != null || this.isExistingGrammar(this.fSchemaGrammarDescription)) break block45;
                                    newSchemaRoot = this.resolveSchema(this.fSchemaGrammarDescription, false, child);
                                    break block49;
                                }
                                if (!localName.equals(SchemaSymbols.ELT_INCLUDE) && !localName.equals(SchemaSymbols.ELT_REDEFINE)) break;
                                includeAttrs = this.fAttributeChecker.checkAttributes(child, true, currSchemaInfo);
                                schemaHint = (String)includeAttrs[XSAttributeChecker.ATTIDX_SCHEMALOCATION];
                                if (localName.equals(SchemaSymbols.ELT_REDEFINE)) {
                                    this.fRedefine2NSSupport.put(child, new SchemaNamespaceSupport(currSchemaInfo.fNamespaceSupport));
                                }
                                if (!localName.equals(SchemaSymbols.ELT_INCLUDE)) break block50;
                                Element includeChild = DOMUtil.getFirstChildElement(child);
                                if (includeChild == null) break block51;
                                String includeComponentType = DOMUtil.getLocalName(includeChild);
                                if (includeComponentType.equals(SchemaSymbols.ELT_ANNOTATION)) {
                                    sg.addAnnotation(this.fElementTraverser.traverseAnnotationDecl(includeChild, includeAttrs, true, currSchemaInfo));
                                } else {
                                    this.reportSchemaError("s4s-elt-must-match.1", new Object[]{localName, "annotation?", includeComponentType}, child);
                                }
                                if (DOMUtil.getNextSiblingElement(includeChild) != null) {
                                    this.reportSchemaError("s4s-elt-must-match.1", new Object[]{localName, "annotation?", DOMUtil.getLocalName(DOMUtil.getNextSiblingElement(includeChild))}, child);
                                }
                                break block52;
                            }
                            text = DOMUtil.getSyntheticAnnotation(child);
                            if (text == null) break block52;
                            sg.addAnnotation(this.fElementTraverser.traverseSyntheticAnnotation(child, text, includeAttrs, true, currSchemaInfo));
                            break block52;
                        }
                        Element redefinedChild = DOMUtil.getFirstChildElement(child);
                        while (redefinedChild != null) {
                            String redefinedComponentType = DOMUtil.getLocalName(redefinedChild);
                            if (redefinedComponentType.equals(SchemaSymbols.ELT_ANNOTATION)) {
                                sg.addAnnotation(this.fElementTraverser.traverseAnnotationDecl(redefinedChild, includeAttrs, true, currSchemaInfo));
                                DOMUtil.setHidden(redefinedChild, this.fHiddenNodes);
                            } else {
                                String text = DOMUtil.getSyntheticAnnotation(child);
                                if (text != null) {
                                    sg.addAnnotation(this.fElementTraverser.traverseSyntheticAnnotation(child, text, includeAttrs, true, currSchemaInfo));
                                }
                            }
                            redefinedChild = DOMUtil.getNextSiblingElement(redefinedChild);
                        }
                    }
                    this.fAttributeChecker.returnAttrArray(includeAttrs, currSchemaInfo);
                    if (schemaHint == null) {
                        this.reportSchemaError("s4s-att-must-appear", new Object[]{"<include> or <redefine>", "schemaLocation"}, child);
                    }
                    boolean mustResolve = false;
                    refType = 0;
                    if (localName.equals(SchemaSymbols.ELT_REDEFINE)) {
                        mustResolve = this.nonAnnotationContent(child);
                        refType = 1;
                    }
                    this.fSchemaGrammarDescription.reset();
                    this.fSchemaGrammarDescription.setContextType(refType);
                    this.fSchemaGrammarDescription.setBaseSystemId(this.doc2SystemId(schemaRoot));
                    this.fSchemaGrammarDescription.setLocationHints(new String[]{schemaHint});
                    this.fSchemaGrammarDescription.setTargetNamespace(callerTNS);
                    newSchemaRoot = this.resolveSchema(this.fSchemaGrammarDescription, mustResolve, child);
                    schemaNamespace = currSchemaInfo.fTargetNamespace;
                }
                XSDocumentInfo newSchemaInfo = null;
                newSchemaInfo = this.fLastSchemaWasDuplicate ? (newSchemaRoot == null ? null : (XSDocumentInfo)this.fDoc2XSDocumentMap.get(newSchemaRoot)) : this.constructTrees(newSchemaRoot, schemaHint, this.fSchemaGrammarDescription);
                if (localName.equals(SchemaSymbols.ELT_REDEFINE) && newSchemaInfo != null) {
                    this.fRedefine2XSDMap.put(child, newSchemaInfo);
                }
                if (newSchemaRoot != null) {
                    if (newSchemaInfo != null) {
                        dependencies.addElement(newSchemaInfo);
                    }
                    newSchemaRoot = null;
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        this.fDependencyMap.put(currSchemaInfo, dependencies);
        return currSchemaInfo;
    }

    private boolean isExistingGrammar(XSDDescription desc) {
        SchemaGrammar sg = this.fGrammarBucket.getGrammar(desc.getTargetNamespace());
        if (sg == null) {
            return this.findGrammar(desc) != null;
        }
        try {
            return sg.getDocumentLocations().contains(XMLEntityManager.expandSystemId(desc.getLiteralSystemId(), desc.getBaseSystemId(), false));
        }
        catch (URI.MalformedURIException e) {
            return false;
        }
    }

    protected void buildGlobalNameRegistries() {
        Stack<XSDocumentInfo> schemasToProcess = new Stack<XSDocumentInfo>();
        schemasToProcess.push(this.fRoot);
        while (!schemasToProcess.empty()) {
            XSDocumentInfo currSchemaDoc = (XSDocumentInfo)schemasToProcess.pop();
            Element currDoc = currSchemaDoc.fSchemaElement;
            if (DOMUtil.isHidden(currDoc, this.fHiddenNodes)) continue;
            Element currRoot = currDoc;
            boolean dependenciesCanOccur = true;
            Element globalComp = DOMUtil.getFirstChildElement(currRoot);
            while (globalComp != null) {
                if (!DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    if (DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_INCLUDE) || DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_IMPORT)) {
                        if (!dependenciesCanOccur) {
                            this.reportSchemaError("s4s-elt-invalid-content.3", new Object[]{DOMUtil.getLocalName(globalComp)}, globalComp);
                        }
                        DOMUtil.setHidden(globalComp, this.fHiddenNodes);
                    } else if (DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_REDEFINE)) {
                        if (!dependenciesCanOccur) {
                            this.reportSchemaError("s4s-elt-invalid-content.3", new Object[]{DOMUtil.getLocalName(globalComp)}, globalComp);
                        }
                        Element redefineComp = DOMUtil.getFirstChildElement(globalComp);
                        while (redefineComp != null) {
                            String lName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME);
                            if (lName.length() != 0) {
                                String targetLName;
                                String qName = currSchemaDoc.fTargetNamespace == null ? "," + lName : currSchemaDoc.fTargetNamespace + "," + lName;
                                String componentType = DOMUtil.getLocalName(redefineComp);
                                if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                                    this.checkForDuplicateNames(qName, this.fUnparsedAttributeGroupRegistry, this.fUnparsedAttributeGroupRegistrySub, redefineComp, currSchemaDoc);
                                    targetLName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_ATTRIBUTEGROUP, lName, targetLName);
                                } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE) || componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                                    this.checkForDuplicateNames(qName, this.fUnparsedTypeRegistry, this.fUnparsedTypeRegistrySub, redefineComp, currSchemaDoc);
                                    targetLName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                                        this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_COMPLEXTYPE, lName, targetLName);
                                    } else {
                                        this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_SIMPLETYPE, lName, targetLName);
                                    }
                                } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
                                    this.checkForDuplicateNames(qName, this.fUnparsedGroupRegistry, this.fUnparsedGroupRegistrySub, redefineComp, currSchemaDoc);
                                    targetLName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_GROUP, lName, targetLName);
                                }
                            }
                            redefineComp = DOMUtil.getNextSiblingElement(redefineComp);
                        }
                    } else {
                        dependenciesCanOccur = false;
                        String lName = DOMUtil.getAttrValue(globalComp, SchemaSymbols.ATT_NAME);
                        if (lName.length() != 0) {
                            String qName = currSchemaDoc.fTargetNamespace == null ? "," + lName : currSchemaDoc.fTargetNamespace + "," + lName;
                            String componentType = DOMUtil.getLocalName(globalComp);
                            if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedAttributeRegistry, this.fUnparsedAttributeRegistrySub, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedAttributeGroupRegistry, this.fUnparsedAttributeGroupRegistrySub, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE) || componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedTypeRegistry, this.fUnparsedTypeRegistrySub, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_ELEMENT)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedElementRegistry, this.fUnparsedElementRegistrySub, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedGroupRegistry, this.fUnparsedGroupRegistrySub, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_NOTATION)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedNotationRegistry, this.fUnparsedNotationRegistrySub, globalComp, currSchemaDoc);
                            }
                        }
                    }
                }
                globalComp = DOMUtil.getNextSiblingElement(globalComp);
            }
            DOMUtil.setHidden(currDoc, this.fHiddenNodes);
            Vector currSchemaDepends = (Vector)this.fDependencyMap.get(currSchemaDoc);
            for (int i = 0; i < currSchemaDepends.size(); ++i) {
                schemasToProcess.push((XSDocumentInfo)currSchemaDepends.elementAt(i));
            }
        }
    }

    protected void traverseSchemas(ArrayList annotationInfo) {
        this.setSchemasVisible(this.fRoot);
        Stack<XSDocumentInfo> schemasToProcess = new Stack<XSDocumentInfo>();
        schemasToProcess.push(this.fRoot);
        while (!schemasToProcess.empty()) {
            XSAnnotationInfo info;
            String text;
            XSDocumentInfo currSchemaDoc = (XSDocumentInfo)schemasToProcess.pop();
            Element currDoc = currSchemaDoc.fSchemaElement;
            SchemaGrammar currSG = this.fGrammarBucket.getGrammar(currSchemaDoc.fTargetNamespace);
            if (DOMUtil.isHidden(currDoc, this.fHiddenNodes)) continue;
            Element currRoot = currDoc;
            boolean sawAnnotation = false;
            Element globalComp = DOMUtil.getFirstVisibleChildElement(currRoot, this.fHiddenNodes);
            while (globalComp != null) {
                DOMUtil.setHidden(globalComp, this.fHiddenNodes);
                String componentType = DOMUtil.getLocalName(globalComp);
                if (DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_REDEFINE)) {
                    currSchemaDoc.backupNSSupport((SchemaNamespaceSupport)this.fRedefine2NSSupport.get(globalComp));
                    Element redefinedComp = DOMUtil.getFirstVisibleChildElement(globalComp, this.fHiddenNodes);
                    while (redefinedComp != null) {
                        String redefinedComponentType = DOMUtil.getLocalName(redefinedComp);
                        DOMUtil.setHidden(redefinedComp, this.fHiddenNodes);
                        if (redefinedComponentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                            this.fAttributeGroupTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                            this.fComplexTypeTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_GROUP)) {
                            this.fGroupTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                            this.fSimpleTypeTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else {
                            this.reportSchemaError("s4s-elt-must-match.1", new Object[]{DOMUtil.getLocalName(globalComp), "(annotation | (simpleType | complexType | group | attributeGroup))*", redefinedComponentType}, redefinedComp);
                        }
                        redefinedComp = DOMUtil.getNextVisibleSiblingElement(redefinedComp, this.fHiddenNodes);
                    }
                    currSchemaDoc.restoreNSSupport();
                } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                    this.fAttributeTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                    this.fAttributeGroupTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                    this.fComplexTypeTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_ELEMENT)) {
                    this.fElementTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
                    this.fGroupTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_NOTATION)) {
                    this.fNotationTraverser.traverse(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                    this.fSimpleTypeTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_ANNOTATION)) {
                    currSG.addAnnotation(this.fElementTraverser.traverseAnnotationDecl(globalComp, currSchemaDoc.getSchemaAttrs(), true, currSchemaDoc));
                    sawAnnotation = true;
                } else {
                    this.reportSchemaError("s4s-elt-invalid-content.1", new Object[]{SchemaSymbols.ELT_SCHEMA, DOMUtil.getLocalName(globalComp)}, globalComp);
                }
                globalComp = DOMUtil.getNextVisibleSiblingElement(globalComp, this.fHiddenNodes);
            }
            if (!sawAnnotation && (text = DOMUtil.getSyntheticAnnotation(currRoot)) != null) {
                currSG.addAnnotation(this.fElementTraverser.traverseSyntheticAnnotation(currRoot, text, currSchemaDoc.getSchemaAttrs(), true, currSchemaDoc));
            }
            if (annotationInfo != null && (info = currSchemaDoc.getAnnotations()) != null) {
                annotationInfo.add(this.doc2SystemId(currDoc));
                annotationInfo.add(info);
            }
            currSchemaDoc.returnSchemaAttrs();
            DOMUtil.setHidden(currDoc, this.fHiddenNodes);
            Vector currSchemaDepends = (Vector)this.fDependencyMap.get(currSchemaDoc);
            for (int i = 0; i < currSchemaDepends.size(); ++i) {
                schemasToProcess.push((XSDocumentInfo)currSchemaDepends.elementAt(i));
            }
        }
    }

    private final boolean needReportTNSError(String uri) {
        if (this.fReportedTNS == null) {
            this.fReportedTNS = new Vector();
        } else if (this.fReportedTNS.contains(uri)) {
            return false;
        }
        this.fReportedTNS.addElement(uri);
        return true;
    }

    protected Object getGlobalDecl(XSDocumentInfo currSchema, int declType, QName declToTraverse, Element elmNode) {
        XSTypeDefinition retObj;
        if (declToTraverse.uri != null && declToTraverse.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && declType == 7 && (retObj = SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(declToTraverse.localpart)) != null) {
            return retObj;
        }
        if (!currSchema.isAllowedNS(declToTraverse.uri)) {
            if (currSchema.needReportTNSError(declToTraverse.uri)) {
                String code = declToTraverse.uri == null ? "src-resolve.4.1" : "src-resolve.4.2";
                this.reportSchemaError(code, new Object[]{this.fDoc2SystemId.get(currSchema.fSchemaElement), declToTraverse.uri, declToTraverse.rawname}, elmNode);
            }
            return null;
        }
        SchemaGrammar sGrammar = this.fGrammarBucket.getGrammar(declToTraverse.uri);
        if (sGrammar == null) {
            if (this.needReportTNSError(declToTraverse.uri)) {
                this.reportSchemaError("src-resolve", new Object[]{declToTraverse.rawname, COMP_TYPE[declType]}, elmNode);
            }
            return null;
        }
        XSObject retObj2 = null;
        switch (declType) {
            case 1: {
                retObj2 = sGrammar.getGlobalAttributeDecl(declToTraverse.localpart);
                break;
            }
            case 2: {
                retObj2 = sGrammar.getGlobalAttributeGroupDecl(declToTraverse.localpart);
                break;
            }
            case 3: {
                retObj2 = sGrammar.getGlobalElementDecl(declToTraverse.localpart);
                break;
            }
            case 4: {
                retObj2 = sGrammar.getGlobalGroupDecl(declToTraverse.localpart);
                break;
            }
            case 5: {
                retObj2 = sGrammar.getIDConstraintDecl(declToTraverse.localpart);
                break;
            }
            case 6: {
                retObj2 = sGrammar.getGlobalNotationDecl(declToTraverse.localpart);
                break;
            }
            case 7: {
                retObj2 = sGrammar.getGlobalTypeDecl(declToTraverse.localpart);
            }
        }
        if (retObj2 != null) {
            return retObj2;
        }
        XSDocumentInfo schemaWithDecl = null;
        Element decl = null;
        XSDocumentInfo declDoc = null;
        String declKey = declToTraverse.uri == null ? "," + declToTraverse.localpart : declToTraverse.uri + "," + declToTraverse.localpart;
        switch (declType) {
            case 1: {
                decl = (Element)this.fUnparsedAttributeRegistry.get(declKey);
                declDoc = (XSDocumentInfo)this.fUnparsedAttributeRegistrySub.get(declKey);
                break;
            }
            case 2: {
                decl = (Element)this.fUnparsedAttributeGroupRegistry.get(declKey);
                declDoc = (XSDocumentInfo)this.fUnparsedAttributeGroupRegistrySub.get(declKey);
                break;
            }
            case 3: {
                decl = (Element)this.fUnparsedElementRegistry.get(declKey);
                declDoc = (XSDocumentInfo)this.fUnparsedElementRegistrySub.get(declKey);
                break;
            }
            case 4: {
                decl = (Element)this.fUnparsedGroupRegistry.get(declKey);
                declDoc = (XSDocumentInfo)this.fUnparsedGroupRegistrySub.get(declKey);
                break;
            }
            case 5: {
                decl = (Element)this.fUnparsedIdentityConstraintRegistry.get(declKey);
                declDoc = (XSDocumentInfo)this.fUnparsedIdentityConstraintRegistrySub.get(declKey);
                break;
            }
            case 6: {
                decl = (Element)this.fUnparsedNotationRegistry.get(declKey);
                declDoc = (XSDocumentInfo)this.fUnparsedNotationRegistrySub.get(declKey);
                break;
            }
            case 7: {
                decl = (Element)this.fUnparsedTypeRegistry.get(declKey);
                declDoc = (XSDocumentInfo)this.fUnparsedTypeRegistrySub.get(declKey);
                break;
            }
            default: {
                this.reportSchemaError("Internal-Error", new Object[]{"XSDHandler asked to locate component of type " + declType + "; it does not recognize this type!"}, elmNode);
            }
        }
        if (decl == null) {
            this.reportSchemaError("src-resolve", new Object[]{declToTraverse.rawname, COMP_TYPE[declType]}, elmNode);
            return null;
        }
        schemaWithDecl = this.findXSDocumentForDecl(currSchema, decl, declDoc);
        if (schemaWithDecl == null) {
            String code = declToTraverse.uri == null ? "src-resolve.4.1" : "src-resolve.4.2";
            this.reportSchemaError(code, new Object[]{this.fDoc2SystemId.get(currSchema.fSchemaElement), declToTraverse.uri, declToTraverse.rawname}, elmNode);
            return null;
        }
        if (DOMUtil.isHidden(decl, this.fHiddenNodes)) {
            String code = CIRCULAR_CODES[declType];
            if (declType == 7 && SchemaSymbols.ELT_COMPLEXTYPE.equals(DOMUtil.getLocalName(decl))) {
                code = "ct-props-correct.3";
            }
            this.reportSchemaError(code, new Object[]{declToTraverse.prefix + ":" + declToTraverse.localpart}, elmNode);
            return null;
        }
        DOMUtil.setHidden(decl, this.fHiddenNodes);
        SchemaNamespaceSupport nsSupport = null;
        Element parent = DOMUtil.getParent(decl);
        if (DOMUtil.getLocalName(parent).equals(SchemaSymbols.ELT_REDEFINE)) {
            nsSupport = (SchemaNamespaceSupport)this.fRedefine2NSSupport.get(parent);
        }
        schemaWithDecl.backupNSSupport(nsSupport);
        switch (declType) {
            case 1: {
                retObj2 = this.fAttributeTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 2: {
                retObj2 = this.fAttributeGroupTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 3: {
                retObj2 = this.fElementTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 4: {
                retObj2 = this.fGroupTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 5: {
                retObj2 = null;
                break;
            }
            case 6: {
                retObj2 = this.fNotationTraverser.traverse(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 7: {
                retObj2 = DOMUtil.getLocalName(decl).equals(SchemaSymbols.ELT_COMPLEXTYPE) ? this.fComplexTypeTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar) : this.fSimpleTypeTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
            }
        }
        schemaWithDecl.restoreNSSupport();
        return retObj2;
    }

    Object getGrpOrAttrGrpRedefinedByRestriction(int type, QName name, XSDocumentInfo currSchema, Element elmNode) {
        String realName = name.uri != null ? name.uri + "," + name.localpart : "," + name.localpart;
        String nameToFind = null;
        switch (type) {
            case 2: {
                nameToFind = (String)this.fRedefinedRestrictedAttributeGroupRegistry.get(realName);
                break;
            }
            case 4: {
                nameToFind = (String)this.fRedefinedRestrictedGroupRegistry.get(realName);
                break;
            }
            default: {
                return null;
            }
        }
        if (nameToFind == null) {
            return null;
        }
        int commaPos = nameToFind.indexOf(",");
        QName qNameToFind = new QName(XMLSymbols.EMPTY_STRING, nameToFind.substring(commaPos + 1), nameToFind.substring(commaPos), commaPos == 0 ? null : nameToFind.substring(0, commaPos));
        Object retObj = this.getGlobalDecl(currSchema, type, qNameToFind, elmNode);
        if (retObj == null) {
            switch (type) {
                case 2: {
                    this.reportSchemaError("src-redefine.7.2.1", new Object[]{name.localpart}, elmNode);
                    break;
                }
                case 4: {
                    this.reportSchemaError("src-redefine.6.2.1", new Object[]{name.localpart}, elmNode);
                }
            }
            return null;
        }
        return retObj;
    }

    protected void resolveKeyRefs() {
        for (int i = 0; i < this.fKeyrefStackPos; ++i) {
            XSDocumentInfo keyrefSchemaDoc = this.fKeyrefsMapXSDocumentInfo[i];
            keyrefSchemaDoc.fNamespaceSupport.makeGlobal();
            keyrefSchemaDoc.fNamespaceSupport.setEffectiveContext(this.fKeyrefNamespaceContext[i]);
            SchemaGrammar keyrefGrammar = this.fGrammarBucket.getGrammar(keyrefSchemaDoc.fTargetNamespace);
            DOMUtil.setHidden(this.fKeyrefs[i], this.fHiddenNodes);
            this.fKeyrefTraverser.traverse(this.fKeyrefs[i], this.fKeyrefElems[i], keyrefSchemaDoc, keyrefGrammar);
        }
    }

    protected Hashtable getIDRegistry() {
        return this.fUnparsedIdentityConstraintRegistry;
    }

    protected Hashtable getIDRegistry_sub() {
        return this.fUnparsedIdentityConstraintRegistrySub;
    }

    protected void storeKeyRef(Element keyrefToStore, XSDocumentInfo schemaDoc, XSElementDecl currElemDecl) {
        String keyrefName = DOMUtil.getAttrValue(keyrefToStore, SchemaSymbols.ATT_NAME);
        if (keyrefName.length() != 0) {
            String keyrefQName = schemaDoc.fTargetNamespace == null ? "," + keyrefName : schemaDoc.fTargetNamespace + "," + keyrefName;
            this.checkForDuplicateNames(keyrefQName, this.fUnparsedIdentityConstraintRegistry, this.fUnparsedIdentityConstraintRegistrySub, keyrefToStore, schemaDoc);
        }
        if (this.fKeyrefStackPos == this.fKeyrefs.length) {
            Element[] elemArray = new Element[this.fKeyrefStackPos + 2];
            System.arraycopy(this.fKeyrefs, 0, elemArray, 0, this.fKeyrefStackPos);
            this.fKeyrefs = elemArray;
            XSElementDecl[] declArray = new XSElementDecl[this.fKeyrefStackPos + 2];
            System.arraycopy(this.fKeyrefElems, 0, declArray, 0, this.fKeyrefStackPos);
            this.fKeyrefElems = declArray;
            String[][] stringArray = new String[this.fKeyrefStackPos + 2][];
            System.arraycopy(this.fKeyrefNamespaceContext, 0, stringArray, 0, this.fKeyrefStackPos);
            this.fKeyrefNamespaceContext = stringArray;
            XSDocumentInfo[] xsDocumentInfo = new XSDocumentInfo[this.fKeyrefStackPos + 2];
            System.arraycopy(this.fKeyrefsMapXSDocumentInfo, 0, xsDocumentInfo, 0, this.fKeyrefStackPos);
            this.fKeyrefsMapXSDocumentInfo = xsDocumentInfo;
        }
        this.fKeyrefs[this.fKeyrefStackPos] = keyrefToStore;
        this.fKeyrefElems[this.fKeyrefStackPos] = currElemDecl;
        this.fKeyrefNamespaceContext[this.fKeyrefStackPos] = schemaDoc.fNamespaceSupport.getEffectiveLocalContext();
        this.fKeyrefsMapXSDocumentInfo[this.fKeyrefStackPos++] = schemaDoc;
    }

    private Element resolveSchema(XSDDescription desc, boolean mustResolve, Element referElement) {
        XMLInputSource schemaSource = null;
        try {
            schemaSource = XMLSchemaLoader.resolveDocument(desc, this.fLocationPairs, this.fEntityResolver);
        }
        catch (IOException ex) {
            if (mustResolve) {
                this.reportSchemaError("schema_reference.4", new Object[]{desc.getLocationHints()[0]}, referElement);
            }
            this.reportSchemaWarning("schema_reference.4", new Object[]{desc.getLocationHints()[0]}, referElement);
        }
        if (schemaSource instanceof DOMInputSource) {
            this.fHiddenNodes.clear();
            Node node = ((DOMInputSource)schemaSource).getNode();
            if (node instanceof Document) {
                return DOMUtil.getRoot((Document)node);
            }
            if (node instanceof Element) {
                return (Element)node;
            }
            return null;
        }
        if (schemaSource instanceof SAXInputSource) {
            XMLReader parser = ((SAXInputSource)schemaSource).getXMLReader();
            InputSource inputSource = ((SAXInputSource)schemaSource).getInputSource();
            boolean namespacePrefixes = false;
            if (parser != null) {
                try {
                    namespacePrefixes = parser.getFeature(NAMESPACE_PREFIXES);
                }
                catch (SAXException se) {}
            } else {
                try {
                    parser = XMLReaderFactory.createXMLReader();
                }
                catch (SAXException se) {
                    parser = new SAXParser();
                }
                try {
                    parser.setFeature(NAMESPACE_PREFIXES, true);
                    namespacePrefixes = true;
                }
                catch (SAXException se) {
                    // empty catch block
                }
            }
            boolean stringsInternalized = false;
            try {
                stringsInternalized = parser.getFeature(STRING_INTERNING);
            }
            catch (SAXException exc) {
                // empty catch block
            }
            if (this.fXSContentHandler == null) {
                this.fXSContentHandler = new SchemaContentHandler();
            }
            this.fXSContentHandler.reset(this.fSchemaParser, this.fSymbolTable, namespacePrefixes, stringsInternalized);
            parser.setContentHandler(this.fXSContentHandler);
            parser.setErrorHandler(this.fErrorReporter.getSAXErrorHandler());
            try {
                parser.parse(inputSource);
            }
            catch (SAXException se) {
                return null;
            }
            catch (IOException ioe) {
                return null;
            }
            Document root = this.fXSContentHandler.getDocument();
            if (root == null) {
                return null;
            }
            return DOMUtil.getRoot(root);
        }
        return this.getSchemaDocument(desc.getTargetNamespace(), schemaSource, mustResolve, desc.getContextType(), referElement);
    }

    private Element getSchemaDocument(String schemaNamespace, XMLInputSource schemaSource, boolean mustResolve, short referType, Element referElement) {
        boolean hasInput = true;
        Element schemaElement = null;
        try {
            if (schemaSource != null && (schemaSource.getSystemId() != null || schemaSource.getByteStream() != null || schemaSource.getCharacterStream() != null)) {
                XSDKey key = null;
                String schemaId = null;
                if (referType != 3 && (schemaElement = (Element)this.fTraversed.get(key = new XSDKey(schemaId = XMLEntityManager.expandSystemId(schemaSource.getSystemId(), schemaSource.getBaseSystemId(), false), referType, schemaNamespace))) != null) {
                    this.fLastSchemaWasDuplicate = true;
                    return schemaElement;
                }
                this.fSchemaParser.parse(schemaSource);
                Element element = schemaElement = this.fSchemaParser.getDocument2() == null ? null : DOMUtil.getRoot(this.fSchemaParser.getDocument2());
                if (key != null) {
                    this.fTraversed.put(key, schemaElement);
                }
                if (schemaId != null) {
                    this.fDoc2SystemId.put(schemaElement, schemaId);
                }
                this.fLastSchemaWasDuplicate = false;
                return schemaElement;
            }
            hasInput = false;
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (mustResolve) {
            if (hasInput) {
                this.reportSchemaError("schema_reference.4", new Object[]{schemaSource.getSystemId()}, referElement);
            } else {
                this.reportSchemaError("schema_reference.4", new Object[]{schemaSource == null ? "" : schemaSource.getSystemId()}, referElement);
            }
        } else if (hasInput) {
            this.reportSchemaWarning("schema_reference.4", new Object[]{schemaSource.getSystemId()}, referElement);
        }
        this.fLastSchemaWasDuplicate = false;
        return null;
    }

    private void createTraversers() {
        this.fAttributeChecker = new XSAttributeChecker(this);
        this.fAttributeGroupTraverser = new XSDAttributeGroupTraverser(this, this.fAttributeChecker);
        this.fAttributeTraverser = new XSDAttributeTraverser(this, this.fAttributeChecker);
        this.fComplexTypeTraverser = new XSDComplexTypeTraverser(this, this.fAttributeChecker);
        this.fElementTraverser = new XSDElementTraverser(this, this.fAttributeChecker);
        this.fGroupTraverser = new XSDGroupTraverser(this, this.fAttributeChecker);
        this.fKeyrefTraverser = new XSDKeyrefTraverser(this, this.fAttributeChecker);
        this.fNotationTraverser = new XSDNotationTraverser(this, this.fAttributeChecker);
        this.fSimpleTypeTraverser = new XSDSimpleTypeTraverser(this, this.fAttributeChecker);
        this.fUniqueOrKeyTraverser = new XSDUniqueOrKeyTraverser(this, this.fAttributeChecker);
        this.fWildCardTraverser = new XSDWildcardTraverser(this, this.fAttributeChecker);
    }

    void prepareForParse() {
        this.fTraversed.clear();
        this.fDoc2SystemId.clear();
        this.fHiddenNodes.clear();
        this.fLastSchemaWasDuplicate = false;
    }

    void prepareForTraverse() {
        int i;
        this.fUnparsedAttributeRegistry.clear();
        this.fUnparsedAttributeGroupRegistry.clear();
        this.fUnparsedElementRegistry.clear();
        this.fUnparsedGroupRegistry.clear();
        this.fUnparsedIdentityConstraintRegistry.clear();
        this.fUnparsedNotationRegistry.clear();
        this.fUnparsedTypeRegistry.clear();
        this.fUnparsedAttributeRegistrySub.clear();
        this.fUnparsedAttributeGroupRegistrySub.clear();
        this.fUnparsedElementRegistrySub.clear();
        this.fUnparsedGroupRegistrySub.clear();
        this.fUnparsedIdentityConstraintRegistrySub.clear();
        this.fUnparsedNotationRegistrySub.clear();
        this.fUnparsedTypeRegistrySub.clear();
        this.fXSDocumentInfoRegistry.clear();
        this.fDependencyMap.clear();
        this.fDoc2XSDocumentMap.clear();
        this.fRedefine2XSDMap.clear();
        this.fRedefine2NSSupport.clear();
        this.fAllTNSs.removeAllElements();
        this.fImportMap.clear();
        this.fRoot = null;
        for (i = 0; i < this.fLocalElemStackPos; ++i) {
            this.fParticle[i] = null;
            this.fLocalElementDecl[i] = null;
            this.fLocalElementDecl_schema[i] = null;
            this.fLocalElemNamespaceContext[i] = null;
        }
        this.fLocalElemStackPos = 0;
        for (i = 0; i < this.fKeyrefStackPos; ++i) {
            this.fKeyrefs[i] = null;
            this.fKeyrefElems[i] = null;
            this.fKeyrefNamespaceContext[i] = null;
            this.fKeyrefsMapXSDocumentInfo[i] = null;
        }
        this.fKeyrefStackPos = 0;
        if (this.fAttributeChecker == null) {
            this.createTraversers();
        }
        this.fAttributeChecker.reset(this.fSymbolTable);
        this.fAttributeGroupTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fAttributeTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fComplexTypeTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fElementTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fGroupTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fKeyrefTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fNotationTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fSimpleTypeTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fUniqueOrKeyTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fWildCardTraverser.reset(this.fSymbolTable, this.fValidateAnnotations);
        this.fRedefinedRestrictedAttributeGroupRegistry.clear();
        this.fRedefinedRestrictedGroupRegistry.clear();
    }

    public void setDeclPool(XSDeclarationPool declPool) {
        this.fDeclPool = declPool;
    }

    public void reset(XMLComponentManager componentManager) {
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fSecureProcessing = null;
        if (componentManager != null) {
            try {
                this.fSecureProcessing = (SecurityManager)componentManager.getProperty("http://apache.org/xml/properties/security-manager");
            }
            catch (XMLConfigurationException xmlConfigurationException) {
                // empty catch block
            }
        }
        this.fEntityResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_MANAGER);
        XMLEntityResolver er = (XMLEntityResolver)componentManager.getProperty(ENTITY_RESOLVER);
        if (er != null) {
            this.fSchemaParser.setEntityResolver(er);
        }
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        try {
            XMLErrorHandler currErrorHandler = this.fErrorReporter.getErrorHandler();
            if (currErrorHandler != this.fSchemaParser.getProperty(ERROR_HANDLER)) {
                this.fSchemaParser.setProperty(ERROR_HANDLER, currErrorHandler != null ? currErrorHandler : new DefaultErrorHandler());
                if (this.fAnnotationValidator != null) {
                    this.fAnnotationValidator.setProperty(ERROR_HANDLER, currErrorHandler != null ? currErrorHandler : new DefaultErrorHandler());
                }
            }
        }
        catch (XMLConfigurationException e) {
            // empty catch block
        }
        try {
            this.fValidateAnnotations = componentManager.getFeature(VALIDATE_ANNOTATIONS);
        }
        catch (XMLConfigurationException e) {
            this.fValidateAnnotations = false;
        }
        try {
            this.fHonourAllSchemaLocations = componentManager.getFeature(HONOUR_ALL_SCHEMALOCATIONS);
        }
        catch (XMLConfigurationException e) {
            this.fHonourAllSchemaLocations = false;
        }
        try {
            this.fSchemaParser.setFeature(CONTINUE_AFTER_FATAL_ERROR, this.fErrorReporter.getFeature(CONTINUE_AFTER_FATAL_ERROR));
        }
        catch (XMLConfigurationException e) {
            // empty catch block
        }
        try {
            this.fSchemaParser.setFeature(ALLOW_JAVA_ENCODINGS, componentManager.getFeature(ALLOW_JAVA_ENCODINGS));
        }
        catch (XMLConfigurationException e) {
            // empty catch block
        }
        try {
            this.fSchemaParser.setFeature(STANDARD_URI_CONFORMANT_FEATURE, componentManager.getFeature(STANDARD_URI_CONFORMANT_FEATURE));
        }
        catch (XMLConfigurationException e) {
            // empty catch block
        }
        try {
            this.fGrammarPool = (XMLGrammarPool)componentManager.getProperty(XMLGRAMMAR_POOL);
        }
        catch (XMLConfigurationException e) {
            this.fGrammarPool = null;
        }
        try {
            this.fSchemaParser.setFeature(DISALLOW_DOCTYPE, componentManager.getFeature(DISALLOW_DOCTYPE));
        }
        catch (XMLConfigurationException e) {
            // empty catch block
        }
        try {
            Object security = componentManager.getProperty("http://apache.org/xml/properties/security-manager");
            if (security != null) {
                this.fSchemaParser.setProperty("http://apache.org/xml/properties/security-manager", security);
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    void traverseLocalElements() {
        this.fElementTraverser.fDeferTraversingLocalElements = false;
        for (int i = 0; i < this.fLocalElemStackPos; ++i) {
            Element currElem = this.fLocalElementDecl[i];
            XSDocumentInfo currSchema = this.fLocalElementDecl_schema[i];
            SchemaGrammar currGrammar = this.fGrammarBucket.getGrammar(currSchema.fTargetNamespace);
            this.fElementTraverser.traverseLocal(this.fParticle[i], currElem, currSchema, currGrammar, this.fAllContext[i], this.fParent[i], this.fLocalElemNamespaceContext[i]);
            if (this.fParticle[i].fType != 0) continue;
            XSModelGroupImpl group = null;
            if (this.fParent[i] instanceof XSComplexTypeDecl) {
                XSParticle p = ((XSComplexTypeDecl)this.fParent[i]).getParticle();
                if (p != null) {
                    group = (XSModelGroupImpl)p.getTerm();
                }
            } else {
                group = ((XSGroupDecl)this.fParent[i]).fModelGroup;
            }
            if (group == null) continue;
            this.removeParticle(group, this.fParticle[i]);
        }
    }

    private boolean removeParticle(XSModelGroupImpl group, XSParticleDecl particle) {
        for (int i = 0; i < group.fParticleCount; ++i) {
            XSParticleDecl member = group.fParticles[i];
            if (member == particle) {
                for (int j = i; j < group.fParticleCount - 1; ++j) {
                    group.fParticles[j] = group.fParticles[j + 1];
                }
                --group.fParticleCount;
                return true;
            }
            if (member.fType != 3 || !this.removeParticle((XSModelGroupImpl)member.fValue, particle)) continue;
            return true;
        }
        return false;
    }

    void fillInLocalElemInfo(Element elmDecl, XSDocumentInfo schemaDoc, int allContextFlags, XSObject parent, XSParticleDecl particle) {
        if (this.fParticle.length == this.fLocalElemStackPos) {
            XSParticleDecl[] newStackP = new XSParticleDecl[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fParticle, 0, newStackP, 0, this.fLocalElemStackPos);
            this.fParticle = newStackP;
            Element[] newStackE = new Element[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fLocalElementDecl, 0, newStackE, 0, this.fLocalElemStackPos);
            this.fLocalElementDecl = newStackE;
            XSDocumentInfo[] newStackE_schema = new XSDocumentInfo[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fLocalElementDecl_schema, 0, newStackE_schema, 0, this.fLocalElemStackPos);
            this.fLocalElementDecl_schema = newStackE_schema;
            int[] newStackI = new int[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fAllContext, 0, newStackI, 0, this.fLocalElemStackPos);
            this.fAllContext = newStackI;
            XSObject[] newStackC = new XSObject[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fParent, 0, newStackC, 0, this.fLocalElemStackPos);
            this.fParent = newStackC;
            String[][] newStackN = new String[this.fLocalElemStackPos + 10][];
            System.arraycopy(this.fLocalElemNamespaceContext, 0, newStackN, 0, this.fLocalElemStackPos);
            this.fLocalElemNamespaceContext = newStackN;
        }
        this.fParticle[this.fLocalElemStackPos] = particle;
        this.fLocalElementDecl[this.fLocalElemStackPos] = elmDecl;
        this.fLocalElementDecl_schema[this.fLocalElemStackPos] = schemaDoc;
        this.fAllContext[this.fLocalElemStackPos] = allContextFlags;
        this.fParent[this.fLocalElemStackPos] = parent;
        this.fLocalElemNamespaceContext[this.fLocalElemStackPos++] = schemaDoc.fNamespaceSupport.getEffectiveLocalContext();
    }

    void checkForDuplicateNames(String qName, Hashtable registry, Hashtable registry_sub, Element currComp, XSDocumentInfo currSchema) {
        Object objElem = null;
        Object v = registry.get(qName);
        objElem = v;
        if (v == null) {
            registry.put(qName, currComp);
            registry_sub.put(qName, currSchema);
        } else {
            Element collidingElem = objElem;
            XSDocumentInfo collidingElemSchema = (XSDocumentInfo)registry_sub.get(qName);
            if (collidingElem == currComp) {
                return;
            }
            Element elemParent = null;
            XSDocumentInfo redefinedSchema = null;
            boolean collidedWithRedefine = true;
            elemParent = DOMUtil.getParent(collidingElem);
            if (DOMUtil.getLocalName(elemParent).equals(SchemaSymbols.ELT_REDEFINE)) {
                redefinedSchema = (XSDocumentInfo)this.fRedefine2XSDMap.get(elemParent);
            } else if (DOMUtil.getLocalName(DOMUtil.getParent(currComp)).equals(SchemaSymbols.ELT_REDEFINE)) {
                redefinedSchema = collidingElemSchema;
                collidedWithRedefine = false;
            }
            if (redefinedSchema != null) {
                if (collidingElemSchema == currSchema) {
                    this.reportSchemaError("sch-props-correct.2", new Object[]{qName}, currComp);
                    return;
                }
                String newName = qName.substring(qName.lastIndexOf(44) + 1) + REDEF_IDENTIFIER;
                if (redefinedSchema == currSchema) {
                    currComp.setAttribute(SchemaSymbols.ATT_NAME, newName);
                    if (currSchema.fTargetNamespace == null) {
                        registry.put("," + newName, currComp);
                        registry_sub.put("," + newName, currSchema);
                    } else {
                        registry.put(currSchema.fTargetNamespace + "," + newName, currComp);
                        registry_sub.put(currSchema.fTargetNamespace + "," + newName, currSchema);
                    }
                    if (currSchema.fTargetNamespace == null) {
                        this.checkForDuplicateNames("," + newName, registry, registry_sub, currComp, currSchema);
                    } else {
                        this.checkForDuplicateNames(currSchema.fTargetNamespace + "," + newName, registry, registry_sub, currComp, currSchema);
                    }
                } else if (collidedWithRedefine) {
                    if (currSchema.fTargetNamespace == null) {
                        this.checkForDuplicateNames("," + newName, registry, registry_sub, currComp, currSchema);
                    } else {
                        this.checkForDuplicateNames(currSchema.fTargetNamespace + "," + newName, registry, registry_sub, currComp, currSchema);
                    }
                } else {
                    this.reportSchemaError("sch-props-correct.2", new Object[]{qName}, currComp);
                }
            } else {
                this.reportSchemaError("sch-props-correct.2", new Object[]{qName}, currComp);
            }
        }
    }

    private void renameRedefiningComponents(XSDocumentInfo currSchema, Element child, String componentType, String oldName, String newName) {
        if (componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            Element grandKid = DOMUtil.getFirstChildElement(child);
            if (grandKid == null) {
                this.reportSchemaError("src-redefine.5.a.a", null, child);
            } else {
                String grandKidName = DOMUtil.getLocalName(grandKid);
                if (grandKidName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                    grandKid = DOMUtil.getNextSiblingElement(grandKid);
                }
                if (grandKid == null) {
                    this.reportSchemaError("src-redefine.5.a.a", null, child);
                } else {
                    grandKidName = DOMUtil.getLocalName(grandKid);
                    if (!grandKidName.equals(SchemaSymbols.ELT_RESTRICTION)) {
                        this.reportSchemaError("src-redefine.5.a.b", new Object[]{grandKidName}, child);
                    } else {
                        Object[] attrs = this.fAttributeChecker.checkAttributes(grandKid, false, currSchema);
                        QName derivedBase = (QName)attrs[XSAttributeChecker.ATTIDX_BASE];
                        if (derivedBase == null || derivedBase.uri != currSchema.fTargetNamespace || !derivedBase.localpart.equals(oldName)) {
                            this.reportSchemaError("src-redefine.5.a.c", new Object[]{grandKidName, (currSchema.fTargetNamespace == null ? "" : currSchema.fTargetNamespace) + "," + oldName}, child);
                        } else if (derivedBase.prefix != null && derivedBase.prefix.length() > 0) {
                            grandKid.setAttribute(SchemaSymbols.ATT_BASE, derivedBase.prefix + ":" + newName);
                        } else {
                            grandKid.setAttribute(SchemaSymbols.ATT_BASE, newName);
                        }
                        this.fAttributeChecker.returnAttrArray(attrs, currSchema);
                    }
                }
            }
        } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
            Element grandKid = DOMUtil.getFirstChildElement(child);
            if (grandKid == null) {
                this.reportSchemaError("src-redefine.5.b.a", null, child);
            } else {
                if (DOMUtil.getLocalName(grandKid).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    grandKid = DOMUtil.getNextSiblingElement(grandKid);
                }
                if (grandKid == null) {
                    this.reportSchemaError("src-redefine.5.b.a", null, child);
                } else {
                    Element greatGrandKid = DOMUtil.getFirstChildElement(grandKid);
                    if (greatGrandKid == null) {
                        this.reportSchemaError("src-redefine.5.b.b", null, grandKid);
                    } else {
                        String greatGrandKidName = DOMUtil.getLocalName(greatGrandKid);
                        if (greatGrandKidName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                            greatGrandKid = DOMUtil.getNextSiblingElement(greatGrandKid);
                        }
                        if (greatGrandKid == null) {
                            this.reportSchemaError("src-redefine.5.b.b", null, grandKid);
                        } else {
                            greatGrandKidName = DOMUtil.getLocalName(greatGrandKid);
                            if (!greatGrandKidName.equals(SchemaSymbols.ELT_RESTRICTION) && !greatGrandKidName.equals(SchemaSymbols.ELT_EXTENSION)) {
                                this.reportSchemaError("src-redefine.5.b.c", new Object[]{greatGrandKidName}, greatGrandKid);
                            } else {
                                Object[] attrs = this.fAttributeChecker.checkAttributes(greatGrandKid, false, currSchema);
                                QName derivedBase = (QName)attrs[XSAttributeChecker.ATTIDX_BASE];
                                if (derivedBase == null || derivedBase.uri != currSchema.fTargetNamespace || !derivedBase.localpart.equals(oldName)) {
                                    this.reportSchemaError("src-redefine.5.b.d", new Object[]{greatGrandKidName, (currSchema.fTargetNamespace == null ? "" : currSchema.fTargetNamespace) + "," + oldName}, greatGrandKid);
                                } else if (derivedBase.prefix != null && derivedBase.prefix.length() > 0) {
                                    greatGrandKid.setAttribute(SchemaSymbols.ATT_BASE, derivedBase.prefix + ":" + newName);
                                } else {
                                    greatGrandKid.setAttribute(SchemaSymbols.ATT_BASE, newName);
                                }
                            }
                        }
                    }
                }
            }
        } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
            String processedBaseName = currSchema.fTargetNamespace == null ? "," + oldName : currSchema.fTargetNamespace + "," + oldName;
            int attGroupRefsCount = this.changeRedefineGroup(processedBaseName, componentType, newName, child, currSchema);
            if (attGroupRefsCount > 1) {
                this.reportSchemaError("src-redefine.7.1", new Object[]{new Integer(attGroupRefsCount)}, child);
            } else if (attGroupRefsCount != 1) {
                if (currSchema.fTargetNamespace == null) {
                    this.fRedefinedRestrictedAttributeGroupRegistry.put(processedBaseName, "," + newName);
                } else {
                    this.fRedefinedRestrictedAttributeGroupRegistry.put(processedBaseName, currSchema.fTargetNamespace + "," + newName);
                }
            }
        } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
            String processedBaseName = currSchema.fTargetNamespace == null ? "," + oldName : currSchema.fTargetNamespace + "," + oldName;
            int groupRefsCount = this.changeRedefineGroup(processedBaseName, componentType, newName, child, currSchema);
            if (groupRefsCount > 1) {
                this.reportSchemaError("src-redefine.6.1.1", new Object[]{new Integer(groupRefsCount)}, child);
            } else if (groupRefsCount != 1) {
                if (currSchema.fTargetNamespace == null) {
                    this.fRedefinedRestrictedGroupRegistry.put(processedBaseName, "," + newName);
                } else {
                    this.fRedefinedRestrictedGroupRegistry.put(processedBaseName, currSchema.fTargetNamespace + "," + newName);
                }
            }
        } else {
            this.reportSchemaError("Internal-Error", new Object[]{"could not handle this particular <redefine>; please submit your schemas and instance document in a bug report!"}, child);
        }
    }

    private String findQName(String name, XSDocumentInfo schemaDoc) {
        String localpart;
        SchemaNamespaceSupport currNSMap = schemaDoc.fNamespaceSupport;
        int colonPtr = name.indexOf(58);
        String prefix = XMLSymbols.EMPTY_STRING;
        if (colonPtr > 0) {
            prefix = name.substring(0, colonPtr);
        }
        String uri = currNSMap.getURI(this.fSymbolTable.addSymbol(prefix));
        String string = localpart = colonPtr == 0 ? name : name.substring(colonPtr + 1);
        if (prefix == XMLSymbols.EMPTY_STRING && uri == null && schemaDoc.fIsChameleonSchema) {
            uri = schemaDoc.fTargetNamespace;
        }
        if (uri == null) {
            return "," + localpart;
        }
        return uri + "," + localpart;
    }

    private int changeRedefineGroup(String originalQName, String elementSought, String newName, Element curr, XSDocumentInfo schemaDoc) {
        int result = 0;
        Element child = DOMUtil.getFirstChildElement(curr);
        while (child != null) {
            String name = DOMUtil.getLocalName(child);
            if (!name.equals(elementSought)) {
                result += this.changeRedefineGroup(originalQName, elementSought, newName, child, schemaDoc);
            } else {
                String processedRef;
                String ref = child.getAttribute(SchemaSymbols.ATT_REF);
                if (ref.length() != 0 && originalQName.equals(processedRef = this.findQName(ref, schemaDoc))) {
                    String prefix = XMLSymbols.EMPTY_STRING;
                    int colonptr = ref.indexOf(":");
                    if (colonptr > 0) {
                        prefix = ref.substring(0, colonptr);
                        child.setAttribute(SchemaSymbols.ATT_REF, prefix + ":" + newName);
                    } else {
                        child.setAttribute(SchemaSymbols.ATT_REF, newName);
                    }
                    ++result;
                    if (elementSought.equals(SchemaSymbols.ELT_GROUP)) {
                        String minOccurs = child.getAttribute(SchemaSymbols.ATT_MINOCCURS);
                        String maxOccurs = child.getAttribute(SchemaSymbols.ATT_MAXOCCURS);
                        if (maxOccurs.length() != 0 && !maxOccurs.equals("1") || minOccurs.length() != 0 && !minOccurs.equals("1")) {
                            this.reportSchemaError("src-redefine.6.1.2", new Object[]{ref}, child);
                        }
                    }
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return result;
    }

    private XSDocumentInfo findXSDocumentForDecl(XSDocumentInfo currSchema, Element decl, XSDocumentInfo decl_Doc) {
        XSDocumentInfo temp = decl_Doc;
        if (temp == null) {
            return null;
        }
        XSDocumentInfo declDocInfo = temp;
        return declDocInfo;
    }

    private boolean nonAnnotationContent(Element elem) {
        Element child = DOMUtil.getFirstChildElement(elem);
        while (child != null) {
            if (!DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                return true;
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return false;
    }

    private void setSchemasVisible(XSDocumentInfo startSchema) {
        if (DOMUtil.isHidden(startSchema.fSchemaElement, this.fHiddenNodes)) {
            DOMUtil.setVisible(startSchema.fSchemaElement, this.fHiddenNodes);
            Vector dependingSchemas = (Vector)this.fDependencyMap.get(startSchema);
            for (int i = 0; i < dependingSchemas.size(); ++i) {
                this.setSchemasVisible((XSDocumentInfo)dependingSchemas.elementAt(i));
            }
        }
    }

    public SimpleLocator element2Locator(Element e) {
        if (!(e instanceof ElementImpl)) {
            return null;
        }
        SimpleLocator l = new SimpleLocator();
        return this.element2Locator(e, l) ? l : null;
    }

    public boolean element2Locator(Element e, SimpleLocator l) {
        if (l == null) {
            return false;
        }
        if (e instanceof ElementImpl) {
            ElementImpl ele = (ElementImpl)e;
            Document doc = ele.getOwnerDocument();
            String sid = (String)this.fDoc2SystemId.get(DOMUtil.getRoot(doc));
            int line = ele.getLineNumber();
            int column = ele.getColumnNumber();
            l.setValues(sid, sid, line, column, ele.getCharacterOffset());
            return true;
        }
        return false;
    }

    void reportSchemaFatalError(String key, Object[] args, Element ele) {
        this.reportSchemaErr(key, args, ele, (short)2);
    }

    void reportSchemaError(String key, Object[] args, Element ele) {
        this.reportSchemaErr(key, args, ele, (short)1);
    }

    void reportSchemaWarning(String key, Object[] args, Element ele) {
        this.reportSchemaErr(key, args, ele, (short)0);
    }

    void reportSchemaErr(String key, Object[] args, Element ele, short type) {
        if (this.element2Locator(ele, this.xl)) {
            this.fErrorReporter.reportError(this.xl, "http://www.w3.org/TR/xml-schema-1", key, args, type);
        } else {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, args, type);
        }
    }

    public void setGenerateSyntheticAnnotations(boolean state) {
        this.fSchemaParser.setFeature(GENERATE_SYNTHETIC_ANNOTATIONS, state);
    }

    private static class XSDKey {
        String systemId;
        short referType;
        String referNS;

        XSDKey(String systemId, short referType, String referNS) {
            this.systemId = systemId;
            this.referType = referType;
            this.referNS = referNS;
        }

        public int hashCode() {
            return this.referNS == null ? 0 : this.referNS.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XSDKey)) {
                return false;
            }
            XSDKey key = (XSDKey)obj;
            if ((this.referType == 1 || key.referType == 1) && this.referType != key.referType) {
                return false;
            }
            if (this.referNS != key.referNS) {
                return false;
            }
            return this.systemId != null && this.systemId.equals(key.systemId);
        }
    }

    private static class XSAnnotationGrammarPool
    implements XMLGrammarPool {
        private XSGrammarBucket fGrammarBucket;
        private Grammar[] fInitialGrammarSet;

        private XSAnnotationGrammarPool() {
        }

        public Grammar[] retrieveInitialGrammarSet(String grammarType) {
            if (grammarType == "http://www.w3.org/2001/XMLSchema") {
                if (this.fInitialGrammarSet == null) {
                    if (this.fGrammarBucket == null) {
                        this.fInitialGrammarSet = new Grammar[]{SchemaGrammar.SG_Schema4Annotations};
                    } else {
                        SchemaGrammar[] schemaGrammars = this.fGrammarBucket.getGrammars();
                        for (int i = 0; i < schemaGrammars.length; ++i) {
                            if (!SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(schemaGrammars[i].getTargetNamespace())) continue;
                            this.fInitialGrammarSet = schemaGrammars;
                            return this.fInitialGrammarSet;
                        }
                        Grammar[] grammars = new Grammar[schemaGrammars.length + 1];
                        System.arraycopy(schemaGrammars, 0, grammars, 0, schemaGrammars.length);
                        grammars[grammars.length - 1] = SchemaGrammar.SG_Schema4Annotations;
                        this.fInitialGrammarSet = grammars;
                    }
                }
                return this.fInitialGrammarSet;
            }
            return new Grammar[0];
        }

        public void cacheGrammars(String grammarType, Grammar[] grammars) {
        }

        public Grammar retrieveGrammar(XMLGrammarDescription desc) {
            if (desc.getGrammarType() == "http://www.w3.org/2001/XMLSchema") {
                SchemaGrammar grammar;
                String tns = ((XMLSchemaDescription)desc).getTargetNamespace();
                if (this.fGrammarBucket != null && (grammar = this.fGrammarBucket.getGrammar(tns)) != null) {
                    return grammar;
                }
                if (SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(tns)) {
                    return SchemaGrammar.SG_Schema4Annotations;
                }
            }
            return null;
        }

        public void refreshGrammars(XSGrammarBucket gBucket) {
            this.fGrammarBucket = gBucket;
            this.fInitialGrammarSet = null;
        }

        public void lockPool() {
        }

        public void unlockPool() {
        }

        public void clear() {
        }
    }
}

