/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.util.stax;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class StaxSource
extends SAXSource
implements XMLReader {
    private XMLStreamReader streamReader;
    private ContentHandler contentHandler;

    public StaxSource(XMLStreamReader streamReader) {
        this.streamReader = streamReader;
        this.setInputSource(new InputSource());
    }

    public XMLReader getXMLReader() {
        return this;
    }

    public XMLStreamReader getStreamReader() {
        return this.streamReader;
    }

    protected void parse() throws SAXException {
        try {
            this.contentHandler.startDocument();
            while (true) {
                switch (this.streamReader.getEventType()) {
                    case 10: 
                    case 12: {
                        break;
                    }
                    case 4: {
                        if (this.streamReader.isWhiteSpace()) break;
                        int length = this.streamReader.getTextLength();
                        int start = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.contentHandler.characters(chars, start, length);
                        break;
                    }
                    case 5: 
                    case 11: {
                        break;
                    }
                    case 8: {
                        this.contentHandler.endDocument();
                        return;
                    }
                    case 2: {
                        String uri = this.streamReader.getNamespaceURI();
                        String localName = this.streamReader.getLocalName();
                        String prefix = this.streamReader.getPrefix();
                        String qname = prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
                        this.contentHandler.endElement(uri, localName, qname);
                        for (int i = 0; i < this.streamReader.getNamespaceCount(); ++i) {
                        }
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 9: 
                    case 13: 
                    case 14: 
                    case 15: {
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < this.streamReader.getNamespaceCount(); ++i) {
                        }
                        String uri = this.streamReader.getNamespaceURI();
                        String localName = this.streamReader.getLocalName();
                        String prefix = this.streamReader.getPrefix();
                        String qname = prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
                        this.contentHandler.startElement(uri != null ? uri : "", localName, qname, this.getAttributes());
                        break;
                    }
                }
                this.streamReader.next();
            }
        }
        catch (XMLStreamException e) {
            if (e.getLocation() != null) {
                throw new SAXParseException(e.getMessage(), null, null, e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e);
            }
            throw new SAXParseException(e.getMessage(), null, null, -1, -1, e);
        }
    }

    protected String getQualifiedName() {
        String prefix = this.streamReader.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            return prefix + ":" + this.streamReader.getLocalName();
        }
        return this.streamReader.getLocalName();
    }

    protected Attributes getAttributes() {
        int i;
        AttributesImpl attrs = new AttributesImpl();
        for (i = 0; i < this.streamReader.getNamespaceCount(); ++i) {
            String prefix = this.streamReader.getNamespacePrefix(i);
            String uri = this.streamReader.getNamespaceURI(i);
            if (uri == null) {
                uri = "";
            }
            if (prefix == null || prefix.length() == 0) {
                attrs.addAttribute("", null, "xmlns", "CDATA", uri);
                continue;
            }
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, "CDATA", uri);
        }
        for (i = 0; i < this.streamReader.getAttributeCount(); ++i) {
            String uri = this.streamReader.getAttributeNamespace(i);
            String localName = this.streamReader.getAttributeLocalName(i);
            String prefix = this.streamReader.getAttributePrefix(i);
            String qName = prefix != null && prefix.length() > 0 ? prefix + ':' + localName : localName;
            String type = this.streamReader.getAttributeType(i);
            String value = this.streamReader.getAttributeValue(i);
            if (value == null) {
                value = "";
            }
            attrs.addAttribute(uri, localName, qName, type, value);
        }
        return attrs;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource input) throws SAXException {
        this.parse();
    }

    public void parse(String systemId) throws SAXException {
        this.parse();
    }
}

