/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssertionClause
implements Runnable {
    private List<Predicate<Exchange>> predicates = new ArrayList<Predicate<Exchange>>();

    public AssertionClause predicate(Predicate<Exchange> predicate) {
        this.addPredicate(predicate);
        return this;
    }

    public ExpressionClause<AssertionClause> predicate() {
        ExpressionClause<AssertionClause> clause = new ExpressionClause<AssertionClause>(this);
        this.addPredicate(clause);
        return clause;
    }

    public ValueBuilder<Exchange> header(String name) {
        Expression<Exchange> expression = ExpressionBuilder.headerExpression(name);
        return new PredicateValueBuilder(expression);
    }

    public ValueBuilder<Exchange> property(String name) {
        Expression<Exchange> expression = ExpressionBuilder.propertyExpression(name);
        return new PredicateValueBuilder(expression);
    }

    public PredicateValueBuilder body() {
        Expression<Exchange> expression = ExpressionBuilder.bodyExpression();
        return new PredicateValueBuilder(expression);
    }

    public <T> PredicateValueBuilder bodyAs(Class<T> type) {
        Expression<Exchange> expression = ExpressionBuilder.bodyExpression(type);
        return new PredicateValueBuilder(expression);
    }

    public PredicateValueBuilder outBody() {
        Expression<Exchange> expression = ExpressionBuilder.bodyExpression();
        return new PredicateValueBuilder(expression);
    }

    public <T> PredicateValueBuilder outBody(Class<T> type) {
        Expression<Exchange> expression = ExpressionBuilder.bodyExpression(type);
        return new PredicateValueBuilder(expression);
    }

    protected void applyAssertionOn(MockEndpoint endpoint, int index, Exchange exchange) {
        for (Predicate<Exchange> predicate : this.predicates) {
            predicate.assertMatches(endpoint.getEndpointUri() + " ", exchange);
        }
    }

    protected void addPredicate(Predicate<Exchange> predicate) {
        this.predicates.add(predicate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PredicateValueBuilder
    extends ValueBuilder<Exchange> {
        public PredicateValueBuilder(Expression<Exchange> expression) {
            super(expression);
        }

        @Override
        protected Predicate<Exchange> onNewPredicate(Predicate<Exchange> predicate) {
            AssertionClause.this.addPredicate(predicate);
            return predicate;
        }
    }
}

