/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Converter
public final class IOConverter {
    private static final transient Log LOG = LogFactory.getLog(IOConverter.class);
    private static XmlConverter xmlConverter;

    private IOConverter() {
    }

    @Converter
    public static InputStream toInputStream(URL url) throws IOException {
        return url.openStream();
    }

    @Converter
    public static InputStream toInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    @Converter
    public static BufferedReader toReader(File file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }

    @Converter
    public static File toFile(String name) throws FileNotFoundException {
        return new File(name);
    }

    @Converter
    public static OutputStream toOutputStream(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    @Converter
    public static BufferedWriter toWriter(File file) throws IOException {
        return new BufferedWriter(new FileWriter(file));
    }

    @Converter
    public static Reader toReader(InputStream in) throws FileNotFoundException {
        return new InputStreamReader(in);
    }

    @Converter
    public static Writer toWriter(OutputStream out) throws FileNotFoundException {
        return new OutputStreamWriter(out);
    }

    @Converter
    public static StringReader toReader(String text) {
        return new StringReader(text);
    }

    @Converter
    public static InputStream toInputStream(String text, Exchange exchange) {
        String charsetName;
        if (exchange != null && (charsetName = exchange.getProperty("org.apache.camel.Exchange.CharsetName", String.class)) != null) {
            try {
                return IOConverter.toInputStream(text.getBytes(charsetName));
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Cannot convert the String into byte[] with the charset: " + charsetName), (Throwable)e);
            }
        }
        return IOConverter.toInputStream(text.getBytes());
    }

    @Converter
    public static InputStream toInputStream(BufferedReader buffer, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(IOConverter.toString(buffer), exchange);
    }

    @Converter
    public static InputStream toInputStrean(DOMSource source) throws TransformerException, IOException {
        XmlConverter xmlConverter = IOConverter.createXmlConverter();
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlConverter.toString(source).getBytes());
        return bais;
    }

    private static XmlConverter createXmlConverter() {
        if (xmlConverter == null) {
            xmlConverter = new XmlConverter();
        }
        return xmlConverter;
    }

    @Converter
    public static String toString(byte[] data, Exchange exchange) {
        String charsetName;
        if (exchange != null && (charsetName = exchange.getProperty("org.apache.camel.Exchange.CharsetName", String.class)) != null) {
            try {
                return new String(data, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Cannot convert the byte[] to String with the charset: " + charsetName), (Throwable)e);
            }
        }
        return new String(data);
    }

    @Converter
    public static String toString(File file) throws IOException {
        return IOConverter.toString(IOConverter.toReader(file));
    }

    @Converter
    public static byte[] toByteArray(File file) throws IOException {
        return IOConverter.toBytes(IOConverter.toInputStream(file));
    }

    @Converter
    public static byte[] toByteArray(Reader reader) throws IOException {
        if (reader instanceof BufferedReader) {
            return IOConverter.toByteArray((BufferedReader)reader);
        }
        return IOConverter.toByteArray(new BufferedReader(reader));
    }

    @Converter
    public static String toString(URL url) throws IOException {
        return IOConverter.toString(IOConverter.toInputStream(url));
    }

    @Converter
    public static String toString(Reader reader) throws IOException {
        if (reader instanceof BufferedReader) {
            return IOConverter.toString((BufferedReader)reader);
        }
        return IOConverter.toString(new BufferedReader(reader));
    }

    @Converter
    public static String toString(BufferedReader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        try {
            CollectionStringBuffer builder = new CollectionStringBuffer("\n");
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    String string = builder.toString();
                    return string;
                }
                builder.append(line);
            }
        }
        finally {
            ObjectHelper.close(reader, "reader", LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static byte[] toByteArray(BufferedReader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1024);
        char[] buf = new char[1024];
        try {
            int len = reader.read(buf);
            if (len != -1) {
                sb.append(buf, 0, len);
            }
        }
        finally {
            ObjectHelper.close(reader, "reader", LOG);
        }
        return sb.toString().getBytes();
    }

    @Converter
    public static String toString(InputStream in) throws IOException {
        return IOConverter.toString(IOConverter.toReader(in));
    }

    @Converter
    public static InputStream toInputStream(byte[] data) {
        return new ByteArrayInputStream(data);
    }

    @Converter
    public static ObjectOutput toObjectOutput(OutputStream stream) throws IOException {
        if (stream instanceof ObjectOutput) {
            return (ObjectOutput)((Object)stream);
        }
        return new ObjectOutputStream(stream);
    }

    @Converter
    public static ObjectInput toObjectInput(InputStream stream) throws IOException {
        if (stream instanceof ObjectInput) {
            return (ObjectInput)((Object)stream);
        }
        return new ObjectInputStream(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static byte[] toBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOConverter.copy(stream, bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            ObjectHelper.close(bos, "stream", LOG);
        }
    }

    public static void copy(InputStream stream, OutputStream os) throws IOException {
        byte[] data = new byte[4096];
        int read = stream.read(data);
        while (read != -1) {
            os.write(data, 0, read);
            read = stream.read(data);
        }
        os.flush();
    }
}

