/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Intercept;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.model.FromType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.processor.Interceptor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.ProceedProcessor;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.spi.ErrorHandlerWrappingStrategy;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRouteContext
implements RouteContext {
    private RouteType route;
    private FromType from;
    private Collection<Route> routes;
    private Endpoint<? extends Exchange> endpoint;
    private List<Processor> eventDrivenProcessors = new ArrayList<Processor>();
    private Interceptor lastInterceptor;
    private CamelContext camelContext;
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private ErrorHandlerWrappingStrategy errorHandlerWrappingStrategy;
    private boolean routeAdded;

    public DefaultRouteContext(RouteType route, FromType from, Collection<Route> routes) {
        this.route = route;
        this.from = from;
        this.routes = routes;
    }

    public DefaultRouteContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.routes = new ArrayList<Route>();
        this.route = new RouteType("temporary");
    }

    @Override
    public Endpoint<? extends Exchange> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = this.from.resolveEndpoint(this);
        }
        return this.endpoint;
    }

    @Override
    public FromType getFrom() {
        return this.from;
    }

    @Override
    public RouteType getRoute() {
        return this.route;
    }

    @Override
    public CamelContext getCamelContext() {
        if (this.camelContext == null) {
            this.camelContext = this.getRoute().getCamelContext();
        }
        return this.camelContext;
    }

    @Override
    public Processor createProcessor(ProcessorType node) throws Exception {
        return node.createOutputsProcessor(this);
    }

    @Override
    public Endpoint<? extends Exchange> resolveEndpoint(String uri) {
        return this.route.resolveEndpoint(uri);
    }

    @Override
    public Endpoint<? extends Exchange> resolveEndpoint(String uri, String ref) {
        Endpoint endpoint = null;
        if (uri != null && (endpoint = this.resolveEndpoint(uri)) == null) {
            throw new NoSuchEndpointException(uri);
        }
        if (ref != null && (endpoint = this.lookup(ref, Endpoint.class)) == null) {
            throw new NoSuchEndpointException("ref:" + ref);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Either 'uri' or 'ref' must be specified on: " + this);
        }
        return endpoint;
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        return this.getCamelContext().getRegistry().lookup(name, type);
    }

    @Override
    public void commit() {
        if (!this.eventDrivenProcessors.isEmpty()) {
            Processor processor = Pipeline.newInstance(this.eventDrivenProcessors);
            AsyncProcessor asyncProcessor = AsyncProcessorTypeConverter.convert(processor);
            UnitOfWorkProcessor unitOfWorkProcessor = new UnitOfWorkProcessor(asyncProcessor);
            EventDrivenConsumerRoute edcr = new EventDrivenConsumerRoute((Endpoint)this.getEndpoint(), unitOfWorkProcessor);
            edcr.getProperties().put("id", this.route.idOrCreate());
            edcr.getProperties().put("parent", Integer.toHexString(this.route.hashCode()));
            if (this.route.getGroup() != null) {
                edcr.getProperties().put("group", this.route.getGroup());
            }
            this.routes.add(edcr);
        }
    }

    @Override
    public void addEventDrivenProcessor(Processor processor) {
        this.eventDrivenProcessors.add(processor);
    }

    @Override
    public void intercept(Intercept interceptor) {
        this.lastInterceptor = (Interceptor)interceptor;
    }

    @Override
    public Processor createProceedProcessor() {
        if (this.lastInterceptor == null) {
            throw new IllegalArgumentException("Cannot proceed() from outside of an interceptor!");
        }
        return new ProceedProcessor(this.lastInterceptor);
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    @Override
    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
    }

    @Override
    public ErrorHandlerWrappingStrategy getErrorHandlerWrappingStrategy() {
        return this.errorHandlerWrappingStrategy;
    }

    @Override
    public void setErrorHandlerWrappingStrategy(ErrorHandlerWrappingStrategy strategy) {
        this.errorHandlerWrappingStrategy = strategy;
    }

    @Override
    public boolean isRouteAdded() {
        return this.routeAdded;
    }

    @Override
    public void setIsRouteAdded(boolean b) {
        this.routeAdded = b;
    }

    @Override
    public DataFormatType getDataFormat(String ref) {
        Map<String, DataFormatType> dataFormats = this.getCamelContext().getDataFormats();
        if (dataFormats != null) {
            return dataFormats.get(ref);
        }
        return null;
    }
}

