/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanLanguage
implements Language {
    public static Expression bean(String expression) {
        BeanLanguage language = new BeanLanguage();
        return language.createExpression(expression);
    }

    public static Expression bean(Class beanType, String method) {
        Object bean = ObjectHelper.newInstance(beanType);
        return BeanLanguage.bean(bean, method);
    }

    public static Expression bean(Object bean, String method) {
        BeanLanguage language = new BeanLanguage();
        return language.createExpression(bean, method);
    }

    @Override
    public Predicate<Exchange> createPredicate(String expression) {
        return PredicateBuilder.toPredicate(this.createExpression(expression));
    }

    @Override
    public Expression<Exchange> createExpression(String expression) {
        ObjectHelper.notNull(expression, "expression");
        int idx = expression.lastIndexOf(46);
        String beanName = expression;
        String method = null;
        if (idx > 0) {
            beanName = expression.substring(0, idx);
            method = expression.substring(idx + 1);
        }
        return new BeanExpression<Exchange>(beanName, method);
    }

    public Expression<Exchange> createExpression(Object bean, String method) {
        ObjectHelper.notNull(bean, "bean");
        return new BeanExpression<Exchange>(bean, method);
    }
}

