/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.DefaultAggregationCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateAggregationCollection
extends DefaultAggregationCollection {
    private Predicate aggregationCompletedPredicate;
    private List<Exchange> collection = new ArrayList<Exchange>();

    public PredicateAggregationCollection(Expression<Exchange> correlationExpression, AggregationStrategy aggregationStrategy, Predicate aggregationCompletedPredicate) {
        super(correlationExpression, aggregationStrategy);
        this.aggregationCompletedPredicate = aggregationCompletedPredicate;
    }

    @Override
    public void onAggregation(Object correlationKey, Exchange newExchange) {
        if (this.aggregationCompletedPredicate.matches(newExchange)) {
            super.getMap().remove(correlationKey);
            this.collection.add(newExchange);
        }
    }

    @Override
    public Iterator<Exchange> iterator() {
        return this.collection.iterator();
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public void clear() {
        this.collection.clear();
        super.clear();
    }
}

