/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyKey;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExceptionPolicyStrategy
implements ExceptionPolicyStrategy {
    private static final transient Log LOG = LogFactory.getLog(DefaultExceptionPolicyStrategy.class);

    @Override
    public ExceptionType getExceptionPolicy(Map<ExceptionPolicyKey, ExceptionType> exceptionPolicices, Exchange exchange, Throwable exception) {
        Iterator<Throwable> it = this.createExceptionIterator(exception);
        while (it.hasNext()) {
            ExceptionType type = this.findMatchedExceptionPolicy(exceptionPolicices, exchange, it.next());
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private ExceptionType findMatchedExceptionPolicy(Map<ExceptionPolicyKey, ExceptionType> exceptionPolicices, Exchange exchange, Throwable exception) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finding best suited exception policy for thrown exception " + exception.getClass().getName()));
        }
        int targetLevel = DefaultExceptionPolicyStrategy.getInheritanceLevel(exception.getClass());
        ExceptionType candidate = null;
        int candidateDiff = Integer.MAX_VALUE;
        Set<Map.Entry<ExceptionPolicyKey, ExceptionType>> entries = exceptionPolicices.entrySet();
        for (Map.Entry<ExceptionPolicyKey, ExceptionType> entry : entries) {
            Class clazz = entry.getKey().getExceptionClass();
            ExceptionType type = entry.getValue();
            if (!this.filter(type, clazz, exception)) continue;
            if (!this.matchesWhen(type, exchange)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("The type did not match when: " + type));
                continue;
            }
            if (clazz.equals(exception.getClass())) {
                candidate = type;
                break;
            }
            int level = DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz);
            int diff = targetLevel - level;
            if (diff >= candidateDiff) continue;
            candidate = type;
            candidateDiff = diff;
        }
        if (LOG.isDebugEnabled()) {
            if (candidate != null) {
                LOG.debug((Object)("Using " + candidate + " as the exception policy"));
            } else {
                LOG.debug((Object)"No candidate found to be used as exception policy");
            }
        }
        return candidate;
    }

    protected boolean filter(ExceptionType type, Class exceptionClass, Throwable exception) {
        return exceptionClass.isInstance(exception);
    }

    protected boolean matchesWhen(ExceptionType type, Exchange exchange) {
        if (type.getOnWhen() == null || type.getOnWhen().getExpression() == null) {
            return true;
        }
        return type.getOnWhen().getExpression().matches(exchange);
    }

    protected Iterator<Throwable> createExceptionIterator(Throwable exception) {
        return new ExceptionIterator(exception);
    }

    private static int getInheritanceLevel(Class clazz) {
        if (clazz == null || "java.lang.Object".equals(clazz.getName())) {
            return 0;
        }
        return 1 + DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz.getSuperclass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExceptionIterator
    implements Iterator<Throwable> {
        private List<Throwable> tree = new ArrayList<Throwable>();
        private Iterator<Throwable> it;

        public ExceptionIterator(Throwable exception) {
            for (Throwable current = exception; current != null; current = current.getCause()) {
                this.tree.add(current);
            }
            Collections.reverse(this.tree);
            this.it = this.tree.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Throwable next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

