/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.interceptor.Breakpoint;
import org.apache.camel.processor.interceptor.DebugInterceptor;
import org.apache.camel.processor.interceptor.ExceptionEvent;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debugger
implements InterceptStrategy {
    private static final transient Log LOG = LogFactory.getLog(Debugger.class);
    private int exchangeBufferSize = -1;
    private Map<String, DebugInterceptor> interceptors = new HashMap<String, DebugInterceptor>();
    private boolean logExchanges = true;
    private boolean enabled = true;
    private Tracer tracer = new Tracer();

    public static Debugger getDebugger(CamelContext context) {
        if (context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)context;
            List<InterceptStrategy> list = defaultCamelContext.getInterceptStrategies();
            for (InterceptStrategy interceptStrategy : list) {
                if (!(interceptStrategy instanceof Debugger)) continue;
                return (Debugger)interceptStrategy;
            }
        }
        return null;
    }

    public DebugInterceptor getInterceptor(String id) {
        return this.interceptors.get(id);
    }

    public List<Exchange> getExchanges(String id) {
        DebugInterceptor interceptor = this.getInterceptor(id);
        if (interceptor == null) {
            return null;
        }
        return interceptor.getExchanges();
    }

    public void setEnable(boolean flag) {
        this.enabled = flag;
        this.tracer.setEnabled(flag);
        for (DebugInterceptor interceptor : this.interceptors.values()) {
            interceptor.setEnabled(flag);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Breakpoint getBreakpoint(String id) {
        DebugInterceptor interceptor = this.getInterceptor(id);
        if (interceptor == null) {
            return null;
        }
        return interceptor.getBreakpoint();
    }

    public TraceFormatter getTraceFormatter() {
        return this.tracer.getFormatter();
    }

    public void setTraceFormatter(TraceFormatter formatter) {
        this.tracer.setFormatter(formatter);
    }

    public void setLogExchanges(boolean flag) {
        this.logExchanges = flag;
    }

    @Override
    public Processor wrapProcessorInInterceptors(ProcessorType processorType, Processor target) throws Exception {
        String id = processorType.idOrCreate();
        if (this.logExchanges) {
            TraceInterceptor traceInterceptor = new TraceInterceptor(processorType, target, this.tracer);
            target = traceInterceptor;
        }
        DebugInterceptor interceptor = new DebugInterceptor(processorType, target, this.createExchangeList(), this.createExceptionsList());
        this.interceptors.put(id, interceptor);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding " + id + " interceptor: " + interceptor));
        }
        return interceptor;
    }

    protected List<Exchange> createExchangeList() {
        if (this.exchangeBufferSize == 0) {
            return null;
        }
        if (this.exchangeBufferSize > 0) {
            return new ArrayList<Exchange>();
        }
        return new ArrayList<Exchange>();
    }

    protected List<ExceptionEvent> createExceptionsList() {
        return new ArrayList<ExceptionEvent>();
    }
}

