/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.converter.stream.StreamCache;
import org.apache.camel.model.InterceptorRef;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.MessageHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamCachingInterceptor
extends DelegateProcessor
implements AsyncProcessor {
    public StreamCachingInterceptor() {
    }

    public StreamCachingInterceptor(Processor processor) {
        this();
        this.setProcessor(processor);
    }

    @Override
    public String toString() {
        return "StreamCachingInterceptor(" + this.processor + ")";
    }

    public static void noStreamCaching(List<InterceptorType> interceptors) {
        for (int i = 0; i < interceptors.size(); ++i) {
            InterceptorType interceptor = interceptors.get(i);
            if (!(interceptor instanceof InterceptorRef) || !(((InterceptorRef)interceptor).getInterceptor() instanceof StreamCachingInterceptor)) continue;
            interceptors.remove(interceptor);
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            StreamCache newBody = exchange.getIn().getBody(StreamCache.class);
            if (newBody != null) {
                exchange.getIn().setBody(newBody);
            }
            MessageHelper.resetStreamCache(exchange.getIn());
        }
        catch (NoTypeConversionAvailableException noTypeConversionAvailableException) {
            // empty catch block
        }
        return this.proceed(exchange, callback);
    }

    public boolean proceed(Exchange exchange, AsyncCallback callback) {
        if (this.getProcessor() instanceof AsyncProcessor) {
            return ((AsyncProcessor)this.getProcessor()).process(exchange, callback);
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }
}

