/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CamelContextHelper {
    private CamelContextHelper() {
    }

    public static Endpoint getMandatoryEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        Endpoint endpoint = camelContext.getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public static <T extends Endpoint> T getMandatoryEndpoint(CamelContext camelContext, String uri, Class<T> type) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(camelContext, uri);
        return (T)((Endpoint)ObjectHelper.cast(type, endpoint));
    }

    public <T> List<T> getEndpoints(CamelContext camelContext, Class<T> type) {
        return CamelContextHelper.getEndpointsImpl(camelContext, type, false);
    }

    public static <T> List<T> getSingletonEndpoints(CamelContext camelContext, Class<T> type) {
        return CamelContextHelper.getEndpointsImpl(camelContext, type, true);
    }

    private static <T> List<T> getEndpointsImpl(CamelContext camelContext, Class<T> type, boolean singleton) {
        ArrayList<T> answer = new ArrayList<T>();
        Collection<Endpoint> endpoints = singleton ? camelContext.getSingletonEndpoints() : camelContext.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (!type.isInstance(endpoint)) continue;
            T value = type.cast(endpoint);
            answer.add(value);
        }
        return answer;
    }

    public static <T> T convertTo(CamelContext context, Class<T> type, Object value) {
        ObjectHelper.notNull(context, "camelContext");
        return context.getTypeConverter().convertTo(type, value);
    }

    public static <T> T mandatoryConvertTo(CamelContext context, Class<T> type, Object value) {
        T answer = CamelContextHelper.convertTo(context, type, value);
        if (answer == null) {
            throw new IllegalArgumentException("Value " + value + " converted to " + type.getName() + " cannot be null");
        }
        return answer;
    }

    public static <T> T newInstance(CamelContext context, Class<T> beanType) {
        return context.getInjector().newInstance(beanType);
    }

    public static Object lookup(CamelContext context, String name) {
        return context.getRegistry().lookup(name);
    }

    public static <T> T lookup(CamelContext context, String name, Class<T> beanType) {
        return context.getRegistry().lookup(name, beanType);
    }

    public static Object mandatoryLookup(CamelContext context, String name) {
        Object answer = CamelContextHelper.lookup(context, name);
        ObjectHelper.notNull(answer, "registry entry called " + name);
        return answer;
    }

    public static <T> T mandatoryLookup(CamelContext context, String name, Class<T> beanType) {
        T answer = CamelContextHelper.lookup(context, name, beanType);
        ObjectHelper.notNull(answer, "registry entry called " + name + " of type " + beanType.getName());
        return answer;
    }

    public static Language resolveMandatoryLanguage(CamelContext camelContext, String languageName) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(languageName, "languageName");
        Language language = camelContext.resolveLanguage(languageName);
        if (language == null) {
            throw new IllegalArgumentException("Could not resolve language: " + languageName);
        }
        return language;
    }

    public static Expression resolveMandatoryExpression(CamelContext camelContext, String languageName, String expressionText) {
        ObjectHelper.notNull(expressionText, "expressionText");
        Language language = CamelContextHelper.resolveMandatoryLanguage(camelContext, languageName);
        Expression<Exchange> expression = language.createExpression(expressionText);
        if (expression == null) {
            throw new IllegalArgumentException("Could not create expression: " + expressionText + " with language: " + language);
        }
        return expression;
    }

    public static Endpoint getEndpointInjection(CamelContext camelContext, String uri, String name, String injectionPointName, boolean mandatory) {
        Endpoint endpoint = null;
        if (ObjectHelper.isNotNullAndNonEmpty(uri)) {
            endpoint = camelContext.getEndpoint(uri);
        } else {
            if (ObjectHelper.isNullOrBlank(name)) {
                name = injectionPointName;
            }
            endpoint = mandatory ? CamelContextHelper.mandatoryLookup(camelContext, name, Endpoint.class) : CamelContextHelper.lookup(camelContext, name, Endpoint.class);
        }
        return endpoint;
    }
}

