/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountingLatch {
    private final Sync sync = new Sync();

    public int getCount() {
        return this.sync.getCount();
    }

    public void increment() {
        this.sync.releaseShared(1);
    }

    public void decrement() {
        this.sync.releaseShared(-1);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    private final class Sync
    extends AbstractQueuedSynchronizer {
        private Sync() {
        }

        int getCount() {
            return this.getState();
        }

        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        public boolean tryReleaseShared(int delta) {
            int nextc;
            int c;
            while (!this.compareAndSetState(c = this.getState(), nextc = c + delta)) {
            }
            return nextc == 0;
        }
    }
}

