/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.common.JbiConstants;
import org.apache.servicemix.http.endpoints.AbstractHttpConsumerMarshaler;
import org.apache.servicemix.jbi.jaxp.StAXSourceTransformer;
import org.apache.servicemix.jbi.jaxp.XMLStreamHelper;

public class DefaultHttpConsumerMarshaler
extends AbstractHttpConsumerMarshaler {
    private StAXSourceTransformer transformer = new StAXSourceTransformer();
    private URI defaultMep;

    public DefaultHttpConsumerMarshaler() {
        this(JbiConstants.IN_OUT);
    }

    public DefaultHttpConsumerMarshaler(URI defaultMep) {
        this.defaultMep = defaultMep;
    }

    public URI getDefaultMep() {
        return this.defaultMep;
    }

    public void setDefaultMep(URI defaultMep) {
        this.defaultMep = defaultMep;
    }

    public MessageExchange createExchange(HttpServletRequest request, ComponentContext context) throws Exception {
        MessageExchange me = context.getDeliveryChannel().createExchangeFactory().createExchange(this.getDefaultMep());
        NormalizedMessage in = me.createMessage();
        in.setContent((Source)new StreamSource(this.getRequestEncodingStream(request.getHeader("Content-Encoding"), (InputStream)request.getInputStream())));
        me.setMessage(in, "in");
        return me;
    }

    public void sendOut(MessageExchange exchange, NormalizedMessage outMsg, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addResponseHeaders(exchange, request, response);
        response.setStatus(200);
        XMLStreamReader reader = this.transformer.toXMLStreamReader(outMsg.getContent());
        OutputStream encodingStream = this.getResponseEncodingStream(request.getHeader("Accept-Encoding"), (OutputStream)response.getOutputStream());
        XMLStreamWriter writer = this.transformer.getOutputFactory().createXMLStreamWriter(encodingStream);
        writer.writeStartDocument();
        XMLStreamHelper.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
        writer.writeEndDocument();
        writer.close();
        encodingStream.close();
    }

    public void sendFault(MessageExchange exchange, Fault fault, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addResponseHeaders(exchange, request, response);
        response.setStatus(500);
        XMLStreamReader reader = this.transformer.toXMLStreamReader(fault.getContent());
        OutputStream encodingStream = this.getResponseEncodingStream(request.getHeader("Accept-Encoding"), (OutputStream)response.getOutputStream());
        XMLStreamWriter writer = this.transformer.getOutputFactory().createXMLStreamWriter(encodingStream);
        XMLStreamHelper.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
        writer.close();
        encodingStream.close();
    }

    public void sendError(MessageExchange exchange, Exception error, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addResponseHeaders(exchange, request, response);
        response.setStatus(500);
        OutputStream encodingStream = this.getResponseEncodingStream(request.getHeader("Accept-Encoding"), (OutputStream)response.getOutputStream());
        XMLStreamWriter writer = this.transformer.getOutputFactory().createXMLStreamWriter(encodingStream);
        writer.writeStartDocument();
        writer.writeStartElement("error");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        error.printStackTrace(pw);
        pw.close();
        writer.writeCData(sw.toString());
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        encodingStream.close();
    }

    public void sendAccepted(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setStatus(202);
    }
}

