/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.wsn.jms;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.wsn.AbstractPullPoint;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.Notify;
import org.oasis_open.docs.wsn.b_2.UnableToGetMessagesFaultType;
import org.oasis_open.docs.wsn.bw_2.UnableToGetMessagesFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsPullPoint
extends AbstractPullPoint {
    private static Log log = LogFactory.getLog(JmsPullPoint.class);
    private JAXBContext jaxbContext;
    private Connection connection;
    private Session session;
    private Queue queue;
    private MessageProducer producer;
    private MessageConsumer consumer;

    public JmsPullPoint(String name) {
        super(name);
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Notify.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create PullEndpoint", e);
        }
    }

    protected void initSession() throws JMSException {
        if (this.session == null) {
            this.session = this.connection.createSession(false, 1);
            this.queue = this.session.createQueue(this.getName());
            this.producer = this.session.createProducer((Destination)this.queue);
            this.consumer = this.session.createConsumer((Destination)this.queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void store(NotificationMessageHolderType messageHolder) {
        block8: {
            try {
                this.initSession();
                Notify notify = new Notify();
                notify.getNotificationMessage().add(messageHolder);
                StringWriter writer = new StringWriter();
                this.jaxbContext.createMarshaller().marshal((Object)notify, (Writer)writer);
                TextMessage message = this.session.createTextMessage(writer.toString());
                this.producer.send((Message)message);
            }
            catch (JMSException e) {
                log.warn((Object)"Error storing message", (Throwable)e);
                if (this.session == null) break block8;
                try {
                    this.session.close();
                }
                catch (JMSException inner) {
                    log.debug((Object)"Error closing session", (Throwable)inner);
                }
                finally {
                    this.session = null;
                }
            }
            catch (JAXBException e) {
                log.warn((Object)"Error storing message", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized List<NotificationMessageHolderType> getMessages(int max) throws ResourceUnknownFault, UnableToGetMessagesFault {
        try {
            Message msg;
            if (max == 0) {
                max = 256;
            }
            this.initSession();
            ArrayList<NotificationMessageHolderType> messages = new ArrayList<NotificationMessageHolderType>();
            for (int i = 0; i < max && (msg = this.consumer.receiveNoWait()) != null; ++i) {
                TextMessage txtMsg = (TextMessage)msg;
                StringReader reader = new StringReader(txtMsg.getText());
                Notify notify = (Notify)this.jaxbContext.createUnmarshaller().unmarshal((Reader)reader);
                messages.addAll(notify.getNotificationMessage());
            }
            return messages;
        }
        catch (JMSException e) {
            log.info((Object)"Error retrieving messages", (Throwable)e);
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (JMSException inner) {
                    log.debug((Object)"Error closing session", (Throwable)inner);
                }
                finally {
                    this.session = null;
                }
            }
            UnableToGetMessagesFaultType fault = new UnableToGetMessagesFaultType();
            throw new UnableToGetMessagesFault("Unable to retrieve messages", fault, e);
        }
        catch (JAXBException e) {
            log.info((Object)"Error retrieving messages", (Throwable)e);
            UnableToGetMessagesFaultType fault = new UnableToGetMessagesFaultType();
            throw new UnableToGetMessagesFault("Unable to retrieve messages", fault, e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

