/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NamespaceResolver;

public class NamespaceResolverAsDeclarations
implements NamespaceDeclarations {
    private NamePool pool;
    private NamespaceResolver resolver;
    private List prefixes;

    public NamespaceResolverAsDeclarations(NamePool pool, NamespaceResolver resolver) {
        this.pool = pool;
        this.resolver = resolver;
        this.prefixes = new ArrayList(10);
        Iterator iter = resolver.iteratePrefixes();
        while (iter.hasNext()) {
            this.prefixes.add(iter.next());
        }
    }

    public int getNumberOfNamespaces() {
        return this.prefixes.size();
    }

    public String getPrefix(int index) {
        return (String)this.prefixes.get(index);
    }

    public String getURI(int index) {
        return this.resolver.getURIForPrefix((String)this.prefixes.get(index), true);
    }

    public int getNamespaceCode(int index) {
        String prefix = this.getPrefix(index);
        String uri = this.getURI(index);
        return this.pool.allocateNamespaceCode(prefix, uri);
    }

    public int[] getNamespaceCodes(int[] buffer) {
        if (buffer.length < this.getNumberOfNamespaces()) {
            buffer = new int[this.getNumberOfNamespaces()];
        }
        for (int i = 0; i < this.getNumberOfNamespaces(); ++i) {
            buffer[i] = this.getNamespaceCode(i);
        }
        return buffer;
    }
}

