/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentSorter;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class ConditionalSorter
extends Expression {
    private Expression condition;
    private DocumentSorter documentSorter;

    public ConditionalSorter(Expression condition, DocumentSorter sorter) {
        this.condition = condition;
        this.documentSorter = sorter;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public DocumentSorter getDocumentSorter() {
        return this.documentSorter;
    }

    public int getCardinality() {
        return this.documentSorter.getCardinality();
    }

    protected int computeSpecialProperties() {
        return this.condition.getSpecialProperties() | 0x20000;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.condition, this.documentSorter);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.condition == original) {
            this.condition = replacement;
            found = true;
        }
        if (this.documentSorter == original) {
            this.documentSorter = (DocumentSorter)replacement;
            found = true;
        }
        return found;
    }

    protected int computeCardinality() {
        return 57344;
    }

    public Expression copy() {
        return new ConditionalSorter(this.condition.copy(), (DocumentSorter)this.documentSorter.copy());
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("conditionalSort");
        this.condition.explain(out);
        this.documentSorter.explain(out);
        out.endElement();
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.documentSorter.getItemType(th);
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        this.condition = this.doPromotion(this.condition, offer);
        Expression e = this.doPromotion(this.documentSorter, offer);
        if (e instanceof DocumentSorter) {
            return this;
        }
        return e;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        boolean b = this.condition.effectiveBooleanValue(context);
        if (b) {
            return this.documentSorter.iterate(context);
        }
        return this.documentSorter.getBaseExpression().iterate(context);
    }
}

