/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.store.ReferenceStore;
import org.apache.activemq.store.kahadaptor.ReferenceRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceRecordMarshaller
implements Marshaller<ReferenceRecord> {
    @Override
    public ReferenceRecord readPayload(DataInput dataIn) throws IOException {
        ReferenceRecord rr = new ReferenceRecord();
        rr.setMessageId(dataIn.readUTF());
        ReferenceStore.ReferenceData referenceData = new ReferenceStore.ReferenceData();
        referenceData.setFileId(dataIn.readInt());
        referenceData.setOffset(dataIn.readInt());
        referenceData.setExpiration(dataIn.readLong());
        rr.setData(referenceData);
        return rr;
    }

    @Override
    public void writePayload(ReferenceRecord rr, DataOutput dataOut) throws IOException {
        dataOut.writeUTF(rr.getMessageId());
        dataOut.writeInt(rr.getData().getFileId());
        dataOut.writeInt(rr.getData().getOffset());
        dataOut.writeLong(rr.getData().getExpiration());
    }
}

