/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.mail.marshaler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.mail.marshaler.AbstractMailMarshaler;

public class DefaultMailMarshaler
extends AbstractMailMarshaler {
    private static Log log = LogFactory.getLog(DefaultMailMarshaler.class);

    public void convertMailToJBI(MessageExchange exchange, NormalizedMessage nmsg, MimeMessage mailMsg) throws javax.mail.MessagingException {
        this.copyHeaders(exchange, nmsg, mailMsg);
        this.copyBodyAndAttachments(exchange, nmsg, mailMsg);
    }

    public void convertJBIToMail(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage nmsg, String configuredSender, String configuredReceiver) throws javax.mail.MessagingException {
        try {
            this.fillMailHeaders(mimeMessage, exchange, nmsg, configuredSender, configuredReceiver);
            this.fillMailBodyAndAttachments(mimeMessage, exchange, nmsg);
        }
        catch (Exception ex) {
            throw new javax.mail.MessagingException(ex.getMessage(), ex);
        }
    }

    protected void fillMailBodyAndAttachments(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage nmsg) throws Exception {
        if (nmsg.getAttachmentNames().size() > 0) {
            Iterator itAttNames = nmsg.getAttachmentNames().iterator();
            if (itAttNames.hasNext()) {
                MimeMultipart multipart = new MimeMultipart();
                this.fillMailBody(mimeMessage, exchange, nmsg, multipart);
                MimeBodyPart messageBodyPart = null;
                while (itAttNames.hasNext()) {
                    String oneAttachmentName = (String)itAttNames.next();
                    DataHandler dh = nmsg.getAttachment(oneAttachmentName);
                    File f = File.createTempFile("" + System.currentTimeMillis() + "-", dh.getDataSource().getName());
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                    DefaultMailMarshaler.copyInputStream(dh.getInputStream(), bos);
                    bos.close();
                    log.debug((Object)("Saved temp file: " + f.getName() + " with length: " + f.length()));
                    this.addTemporaryResource(exchange.getExchangeId(), f);
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(f)));
                    messageBodyPart.setFileName(dh.getDataSource().getName());
                    messageBodyPart.setDisposition("attachment");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                mimeMessage.setContent((Multipart)multipart);
            }
        } else {
            this.fillMailBody(mimeMessage, exchange, nmsg, null);
        }
    }

    protected void fillMailBody(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage nmsg, MimeMultipart content) throws Exception {
        block20: {
            boolean isHtmlMessage;
            boolean isPlainTextMessage = nmsg.getProperty("org.apache.servicemix.mail.text") != null;
            boolean bl = isHtmlMessage = nmsg.getProperty("org.apache.servicemix.mail.html") != null;
            if (isPlainTextMessage && !isHtmlMessage) {
                if (content != null) {
                    content.setSubType("mixed");
                    MimeBodyPart textBodyPart = new MimeBodyPart();
                    textBodyPart.setContent((Object)nmsg.getProperty("org.apache.servicemix.mail.text").toString(), "text/plain");
                    content.addBodyPart((BodyPart)textBodyPart);
                } else {
                    mimeMessage.setText(nmsg.getProperty("org.apache.servicemix.mail.text").toString());
                }
            } else if (isHtmlMessage && !isPlainTextMessage) {
                if (content != null) {
                    content.setSubType("mixed");
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    htmlBodyPart.setContent((Object)nmsg.getProperty("org.apache.servicemix.mail.html").toString(), "text/html");
                    content.addBodyPart((BodyPart)htmlBodyPart);
                } else {
                    content = new MimeMultipart("mixed");
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    htmlBodyPart.setContent((Object)nmsg.getProperty("org.apache.servicemix.mail.html").toString(), "text/html");
                    content.addBodyPart((BodyPart)htmlBodyPart);
                    mimeMessage.setContent((Multipart)content);
                }
            } else if (isHtmlMessage && isPlainTextMessage) {
                if (content != null) {
                    content.setSubType("mixed");
                    MimeBodyPart textBodyPart = new MimeBodyPart();
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    textBodyPart.setContent((Object)nmsg.getProperty("org.apache.servicemix.mail.text").toString(), "text/plain");
                    htmlBodyPart.setContent((Object)nmsg.getProperty("org.apache.servicemix.mail.html").toString(), "text/html");
                    content.addBodyPart((BodyPart)textBodyPart);
                    content.addBodyPart((BodyPart)htmlBodyPart);
                } else {
                    content = new MimeMultipart("mixed");
                    MimeBodyPart textBodyPart = new MimeBodyPart();
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    textBodyPart.setContent((Object)nmsg.getProperty("org.apache.servicemix.mail.text").toString(), "text/plain");
                    htmlBodyPart.setContent((Object)nmsg.getProperty("org.apache.servicemix.mail.html").toString(), "text/html");
                    content.addBodyPart((BodyPart)textBodyPart);
                    content.addBodyPart((BodyPart)htmlBodyPart);
                    mimeMessage.setContent((Multipart)content);
                }
            } else if (nmsg.getContent() != null) {
                SourceTransformer st = new SourceTransformer();
                try {
                    st.toDOMDocument(nmsg);
                    if (content != null) {
                        content.setSubType("mixed");
                        MimeBodyPart htmlBodyPart = new MimeBodyPart();
                        htmlBodyPart.setContent((Object)st.contentToString(nmsg), "text/html");
                        content.addBodyPart((BodyPart)htmlBodyPart);
                        break block20;
                    }
                    content = new MimeMultipart("mixed");
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    htmlBodyPart.setContent((Object)st.contentToString(nmsg), "text/html");
                    content.addBodyPart((BodyPart)htmlBodyPart);
                    mimeMessage.setContent((Multipart)content);
                }
                catch (Exception ex) {
                    if (content != null) {
                        content.setSubType("mixed");
                        MimeBodyPart textBodyPart = new MimeBodyPart();
                        textBodyPart.setContent((Object)st.contentToString(nmsg), "text/plain");
                        content.addBodyPart((BodyPart)textBodyPart);
                        break block20;
                    }
                    mimeMessage.setText(st.contentToString(nmsg));
                }
            } else if (content != null) {
                content.setSubType("mixed");
                MimeBodyPart textBodyPart = new MimeBodyPart();
                textBodyPart.setContent((Object)"no content", "text/plain");
                content.addBodyPart((BodyPart)textBodyPart);
            } else {
                mimeMessage.setText("no content");
            }
        }
    }

    protected void fillMailHeaders(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage nmsg, String configuredSender, String configuredReceiver) throws Exception {
        InternetAddress[] replyTo;
        String sentDate;
        InternetAddress from;
        InternetAddress[] bcc;
        InternetAddress[] cc;
        InternetAddress[] to;
        if (nmsg.getProperty("org.apache.servicemix.mail.to") != null) {
            to = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.to").toString());
            if (to != null) {
                mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])to);
            }
        } else if (configuredReceiver != null && (to = InternetAddress.parse((String)configuredReceiver)) != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])to);
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.cc") != null && (cc = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.cc").toString())) != null) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.bcc") != null && (bcc = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.bcc").toString())) != null) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
        if (configuredSender != null && configuredSender.trim().length() > 0) {
            from = InternetAddress.parse((String)configuredSender)[0];
            if (from != null) {
                mimeMessage.setFrom((Address)from);
            }
        } else if (nmsg.getProperty("org.apache.servicemix.mail.from") != null) {
            from = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.from").toString())[0];
            if (from != null) {
                mimeMessage.setFrom((Address)from);
            }
        } else {
            from = InternetAddress.parse((String)this.getDefaultSenderForOutgoingMails())[0];
            if (from != null) {
                mimeMessage.setFrom((Address)from);
            }
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.subject") != null) {
            String subject = nmsg.getProperty("org.apache.servicemix.mail.subject").toString();
            if (subject != null) {
                mimeMessage.setSubject(subject);
            } else {
                mimeMessage.setSubject("no subject");
            }
        } else {
            mimeMessage.setSubject("no subject");
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.sentdate") != null && (sentDate = nmsg.getProperty("org.apache.servicemix.mail.sentdate").toString()) != null) {
            try {
                mimeMessage.setSentDate(DateFormat.getInstance().parse(sentDate));
            }
            catch (ParseException ex) {
                mimeMessage.setSentDate(new Date());
            }
        }
        if (nmsg.getProperty("org.apache.servicemix.mail.replyto") != null && (replyTo = InternetAddress.parse((String)nmsg.getProperty("org.apache.servicemix.mail.replyto").toString())) != null) {
            mimeMessage.setReplyTo((Address[])replyTo);
        }
    }

    protected void copyHeaders(MessageExchange exchange, NormalizedMessage nmsg, MimeMessage mailMsg) throws javax.mail.MessagingException {
        Enumeration headers = mailMsg.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            if (nmsg.getProperty(header.getName()) != null) {
                nmsg.setProperty(header.getName(), nmsg.getProperty(header.getName() + ";" + header.getValue()));
            } else {
                nmsg.setProperty(header.getName(), (Object)header.getValue());
            }
            log.debug((Object)("Setting property: " + header.getName() + " = " + header.getValue()));
        }
        if (nmsg.getProperty("Bcc") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.bcc", nmsg.getProperty("Bcc"));
        }
        if (nmsg.getProperty("Cc") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.cc", nmsg.getProperty("Cc"));
        }
        if (nmsg.getProperty("From") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.from", nmsg.getProperty("From"));
        }
        if (nmsg.getProperty("Reply-To") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.replyto", nmsg.getProperty("Reply-To"));
        }
        if (nmsg.getProperty("Date") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.sentdate", nmsg.getProperty("Date"));
        }
        if (nmsg.getProperty("Subject") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.subject", nmsg.getProperty("Subject"));
        }
        if (nmsg.getProperty("To") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.to", nmsg.getProperty("To"));
        }
    }

    protected void copyBodyAndAttachments(MessageExchange exchange, NormalizedMessage nmsg, MimeMessage mailMsg) throws javax.mail.MessagingException {
        String html;
        String text;
        block22: {
            text = null;
            html = null;
            try {
                Object content = mailMsg.getContent();
                if (content instanceof String) {
                    text = this.asString(content);
                    break block22;
                }
                if (content instanceof Multipart) {
                    Multipart mp = (Multipart)content;
                    int nbMP = mp.getCount();
                    log.debug((Object)("MultiPart count: " + nbMP));
                    for (int i = 0; i < nbMP; ++i) {
                        BodyPart part = mp.getBodyPart(i);
                        String disposition = part.getDisposition();
                        log.debug((Object)("MultiPart " + i + ": " + part));
                        log.debug((Object)("Disposition: " + disposition));
                        if (disposition != null && (disposition.equalsIgnoreCase("attachment") || disposition.equalsIgnoreCase("inline"))) {
                            if (part.getFileName() != null) {
                                DataHandler att = part.getDataHandler();
                                nmsg.addAttachment(att.getName(), att);
                                continue;
                            }
                            text = part.getContent() != null ? part.getContent().toString() : "null";
                            continue;
                        }
                        if (disposition != null) continue;
                        MimeBodyPart mbp = (MimeBodyPart)part;
                        if (mbp.isMimeType("text/plain")) {
                            text = (String)mbp.getContent();
                            continue;
                        }
                        if (mbp.isMimeType("text/html")) {
                            html = (String)mbp.getContent();
                            continue;
                        }
                        if (mbp.getContent() instanceof MimeMultipart) {
                            MimeMultipart subMP = (MimeMultipart)mbp.getContent();
                            int nbsubMP = subMP.getCount();
                            for (int j = 0; j < nbsubMP; ++j) {
                                MimeBodyPart subMBP = (MimeBodyPart)subMP.getBodyPart(j);
                                if (subMBP.getContent() instanceof InputStream) {
                                    this.parsePart(subMBP, nmsg);
                                    continue;
                                }
                                if (subMBP.isMimeType("text/plain") && (text == null || text.length() <= 0)) {
                                    text = (String)subMBP.getContent();
                                    continue;
                                }
                                if (subMBP.isMimeType("text/html") && (html == null || html.length() <= 0)) {
                                    html = (String)subMBP.getContent();
                                    continue;
                                }
                                nmsg.setProperty("org.apache.servicemix.mail.alternativecontent" + j, subMBP.getContent());
                            }
                            continue;
                        }
                        this.parsePart(mbp, nmsg);
                    }
                    break block22;
                }
                log.warn((Object)("The content of the mail message is not supported by this component. (" + content.getClass().getName() + ")"));
            }
            catch (MessagingException e) {
                throw new javax.mail.MessagingException("Error while setting content on normalized message", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new javax.mail.MessagingException("Error while fetching content", (Exception)e);
            }
        }
        String msgContent = null;
        if (text == null && html != null) {
            msgContent = html;
            nmsg.setProperty("org.apache.servicemix.mail.html", (Object)html);
        } else if (text != null && html != null) {
            msgContent = text;
            nmsg.setProperty("org.apache.servicemix.mail.html", (Object)html);
            nmsg.setProperty("org.apache.servicemix.mail.text", (Object)text);
        } else {
            if (text == null) {
                log.debug((Object)("No content found! \n" + nmsg.toString()));
            }
            msgContent = text;
            nmsg.setProperty("org.apache.servicemix.mail.text", (Object)text);
        }
        try {
            nmsg.setContent((Source)new StringSource(msgContent != null ? msgContent : "No mail content found!"));
        }
        catch (MessagingException e) {
            throw new javax.mail.MessagingException("Error while setting message content", (Exception)((Object)e));
        }
    }

    protected void parsePart(MimeBodyPart mbp, NormalizedMessage nmsg) throws MessagingException, javax.mail.MessagingException, IOException {
        Object subContent = mbp.getContent();
        log.debug((Object)("Parsing: " + subContent.getClass().getName()));
        if (subContent instanceof InputStream) {
            String altName = mbp.getContentID() + "." + mbp.getContentType().substring(mbp.getContentType().lastIndexOf(47) + 1);
            altName = altName.replaceAll("<", "").replaceAll(">", "").toLowerCase();
            log.debug((Object)("Adding special attachment: " + (mbp.getFileName() != null ? mbp.getFileName() : altName)));
            byte[] data = new byte[mbp.getSize()];
            InputStream stream = (InputStream)subContent;
            stream.read(data);
            ByteArrayDataSource bads = new ByteArrayDataSource(data, mbp.getContentType());
            bads.setName(mbp.getFileName() != null ? mbp.getFileName() : altName);
            nmsg.addAttachment(bads.getName(), new DataHandler((DataSource)bads));
        }
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }
}

