/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.util.ResolverUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiResolverUtil
extends ResolverUtil {
    private Bundle bundle;

    public OsgiResolverUtil(BundleContext context) {
        this.bundle = context.getBundle();
    }

    public Set<ClassLoader> getClassLoaders() {
        Set classLoaders = super.getClassLoaders();
        BundleDelegatingClassLoader osgiLoader = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)this.bundle);
        classLoaders.add(osgiLoader);
        return classLoaders;
    }

    public void find(ResolverUtil.Test test, String packageName) {
        packageName = packageName.replace('.', '/');
        Set<ClassLoader> set = this.getClassLoaders();
        ClassLoader osgiClassLoader = OsgiResolverUtil.getOsgiClassLoader(set);
        if (osgiClassLoader != null) {
            LOG.debug((Object)"Using only osgi bundle classloader");
            this.findInOsgiClassLoader(test, packageName, osgiClassLoader);
        } else {
            LOG.debug((Object)"Using only regular classloaders");
            for (ClassLoader classLoader : set) {
                if (OsgiResolverUtil.isOsgiClassloader(classLoader)) continue;
                this.find(test, packageName, classLoader);
            }
        }
    }

    private void findInOsgiClassLoader(ResolverUtil.Test test, String packageName, ClassLoader osgiClassLoader) {
        try {
            Method mth = osgiClassLoader.getClass().getMethod("getBundle", new Class[0]);
            if (mth != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading from osgi buindle using classloader: " + osgiClassLoader));
                }
                this.loadImplementationsInBundle(test, packageName, osgiClassLoader, mth);
                return;
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn((Object)("It's not an osgi bundle classloader: " + osgiClassLoader));
            return;
        }
    }

    private static ClassLoader getOsgiClassLoader(Set<ClassLoader> set) {
        for (ClassLoader loader : set) {
            if (!OsgiResolverUtil.isOsgiClassloader(loader)) continue;
            return loader;
        }
        return null;
    }

    private static boolean isOsgiClassloader(ClassLoader loader) {
        try {
            Method mth = loader.getClass().getMethod("getBundle", new Class[0]);
            if (mth != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private void loadImplementationsInBundle(ResolverUtil.Test test, String packageName, ClassLoader loader, Method mth) {
        Set<String> urls = OsgiUtil.getImplementationsInBundle(test, packageName, loader, mth);
        if (urls != null) {
            for (String url : urls) {
                this.addIfMatching(test, url);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OsgiUtil {
        private OsgiUtil() {
        }

        static Set<String> getImplementationsInBundle(ResolverUtil.Test test, String packageName, ClassLoader loader, Method mth) {
            try {
                Bundle bundle = (Bundle)mth.invoke((Object)loader, new Object[0]);
                Bundle[] bundles = bundle.getBundleContext().getBundles();
                HashSet<String> urls = new HashSet<String>();
                for (Bundle bd : bundles) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Searching in bundle:" + bd));
                    }
                    Enumeration paths = bd.findEntries("/" + packageName, "*.class", true);
                    while (paths != null && paths.hasMoreElements()) {
                        URL path = (URL)paths.nextElement();
                        String pathString = path.getPath();
                        pathString.indexOf(packageName);
                        urls.add(pathString.substring(pathString.indexOf(packageName)));
                    }
                }
                return urls;
            }
            catch (Throwable t) {
                LOG.error((Object)("Could not search osgi bundles for classes matching criteria: " + test + "due to an Exception: " + t.getMessage()));
                return null;
            }
        }
    }
}

