/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jbi.management.DeploymentException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.servicemix.camel.CamelControlBus;
import org.apache.servicemix.camel.CamelJbiComponent;
import org.apache.servicemix.camel.CamelProviderEndpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.xbean.AbstractXBeanDeployer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelSpringDeployer
extends AbstractXBeanDeployer {
    private final CamelJbiComponent component;
    private List<CamelProviderEndpoint> activatedEndpoints = new ArrayList<CamelProviderEndpoint>();
    private String serviceUnitName;

    public CamelSpringDeployer(CamelJbiComponent component) {
        super((ServiceMixComponent)component);
        this.component = component;
    }

    protected String getXBeanFile() {
        return "camel-context";
    }

    public ServiceUnit deploy(String suName, String serviceUnitRootPath) throws DeploymentException {
        this.component.deployer = this;
        this.serviceUnitName = suName;
        ServiceUnit serviceUnit = super.deploy(suName, serviceUnitRootPath);
        return serviceUnit;
    }

    public void addService(CamelProviderEndpoint endpoint) {
        this.activatedEndpoints.add(endpoint);
    }

    protected Collection<org.apache.servicemix.common.Endpoint> getServices(AbstractXmlApplicationContext applicationContext) throws Exception {
        Endpoint endpoint2;
        ArrayList<CamelProviderEndpoint> services = new ArrayList<CamelProviderEndpoint>(this.activatedEndpoints);
        this.activatedEndpoints.clear();
        SpringCamelContext camelContext = SpringCamelContext.springCamelContext((ApplicationContext)applicationContext);
        Collection endpoints = camelContext.getSingletonEndpoints();
        for (Endpoint endpoint2 : endpoints) {
            if (!this.component.isEndpointExposedOnNmr(endpoint2)) continue;
            services.add(this.component.createJbiEndpointFromCamel(endpoint2));
        }
        BeanComponent beanComponent = (BeanComponent)camelContext.getComponent("bean", BeanComponent.class);
        endpoint2 = beanComponent.createEndpoint((Object)new CamelControlBus((CamelContext)camelContext), "camel:" + this.serviceUnitName + "-controlBus");
        services.add(this.component.createJbiEndpointFromCamel(endpoint2));
        return services;
    }

    protected Map getParentBeansMap() {
        Map beans = super.getParentBeansMap();
        beans.put("jbi", this.component);
        return beans;
    }
}

