/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.jms.JmsEndpointType;
import org.apache.servicemix.jms.endpoints.DefaultProviderMarshaler;
import org.apache.servicemix.jms.endpoints.DestinationChooser;
import org.apache.servicemix.jms.endpoints.JmsProviderMarshaler;
import org.apache.servicemix.jms.endpoints.SimpleDestinationChooser;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreFactory;
import org.apache.servicemix.store.memory.MemoryStoreFactory;
import org.springframework.jms.JmsException;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer102;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter102;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;

public class JmsProviderEndpoint
extends ProviderEndpoint
implements JmsEndpointType {
    private static final String MSG_SELECTOR_START = "JMSCorrelationID='";
    private static final String MSG_SELECTOR_END = "'";
    private JmsProviderMarshaler marshaler = new DefaultProviderMarshaler();
    private DestinationChooser destinationChooser = new SimpleDestinationChooser();
    private DestinationChooser replyDestinationChooser = new SimpleDestinationChooser();
    private JmsTemplateUtil template;
    private boolean jms102;
    private ConnectionFactory connectionFactory;
    private boolean pubSubDomain;
    private DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private Destination destination;
    private String destinationName;
    private boolean messageIdEnabled = true;
    private boolean messageTimestampEnabled = true;
    private boolean pubSubNoLocal;
    private long receiveTimeout = 0L;
    private boolean explicitQosEnabled;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private Destination replyDestination;
    private String replyDestinationName;
    private StoreFactory storeFactory;
    private Store store;
    private AbstractMessageListenerContainer listenerContainer;

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public boolean isJms102() {
        return this.jms102;
    }

    public void setJms102(boolean jms102) {
        this.jms102 = jms102;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public DestinationChooser getDestinationChooser() {
        return this.destinationChooser;
    }

    public void setDestinationChooser(DestinationChooser destinationChooser) {
        if (destinationChooser == null) {
            throw new NullPointerException("destinationChooser is null");
        }
        this.destinationChooser = destinationChooser;
    }

    public DestinationChooser getReplyDestinationChooser() {
        return this.replyDestinationChooser;
    }

    public void setReplyDestinationChooser(DestinationChooser replyDestinationChooser) {
        this.replyDestinationChooser = replyDestinationChooser;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public JmsProviderMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsProviderMarshaler marshaler) {
        if (marshaler == null) {
            throw new NullPointerException("marshaler is null");
        }
        this.marshaler = marshaler;
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setStoreFactory(StoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public Destination getReplyDestination() {
        return this.replyDestination;
    }

    public void setReplyDestination(Destination replyDestination) {
        this.replyDestination = replyDestination;
    }

    public String getReplyDestinationName() {
        return this.replyDestinationName;
    }

    public void setReplyDestinationName(String replyDestinationName) {
        this.replyDestinationName = replyDestinationName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() != MessageExchange.Role.PROVIDER) throw new IllegalStateException("Unsupported role: " + exchange.getRole());
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (exchange.getFault() != null) {
            this.done(exchange);
            return;
        } else {
            NormalizedMessage in = exchange.getMessage("in");
            if (in == null) throw new IllegalStateException("Provider exchange is ACTIVE, but no in or fault is provided");
            if (exchange instanceof InOnly) {
                this.processInOnly(exchange, in);
                this.done(exchange);
                return;
            } else {
                this.processInOut(exchange, in);
            }
        }
    }

    protected void processInOnly(final MessageExchange exchange, final NormalizedMessage in) throws Exception {
        SessionCallback callback = new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                try {
                    JmsProviderEndpoint.this.processInOnlyInSession(exchange, in, session);
                    return null;
                }
                catch (JMSException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new UncategorizedJmsException((Throwable)e);
                }
            }
        };
        this.template.execute(callback, true);
    }

    protected void processInOnlyInSession(MessageExchange exchange, NormalizedMessage in, Session session) throws Exception {
        Destination dest = this.getDestination(exchange, in, session);
        final Message message = this.marshaler.createMessage(exchange, in, session);
        this.template.send(dest, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return message;
            }
        });
    }

    protected void processInOut(final MessageExchange exchange, final NormalizedMessage in) throws Exception {
        SessionCallback callback = new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                try {
                    JmsProviderEndpoint.this.processInOutInSession(exchange, in, session);
                    return null;
                }
                catch (JMSException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new UncategorizedJmsException((Throwable)e);
                }
            }
        };
        this.template.execute(callback, true);
    }

    protected void processInOutInSession(MessageExchange exchange, NormalizedMessage in, Session session) throws Exception {
        Destination dest = this.getDestination(exchange, in, session);
        boolean asynchronous = false;
        boolean useSelector = true;
        Object replyDest = this.chooseDestination(exchange, in, session, this.replyDestinationChooser, null);
        if (replyDest == null) {
            useSelector = false;
            replyDest = this.chooseDestination(exchange, in, session, null, this.replyDestination != null ? this.replyDestination : this.replyDestinationName);
            if (replyDest != null) {
                asynchronous = true;
            } else {
                replyDest = this.isPubSubDomain() ? session.createTemporaryTopic() : session.createTemporaryQueue();
            }
        }
        Message sendJmsMsg = this.marshaler.createMessage(exchange, in, session);
        sendJmsMsg.setJMSReplyTo(replyDest);
        String correlationId = sendJmsMsg.getJMSMessageID() != null ? sendJmsMsg.getJMSMessageID() : exchange.getExchangeId();
        sendJmsMsg.setJMSCorrelationID(correlationId);
        if (asynchronous) {
            this.createAndStartListener();
            this.store.store(correlationId, (Object)exchange);
        }
        try {
            this.send(session, dest, sendJmsMsg);
        }
        catch (Exception e) {
            if (asynchronous) {
                this.store.load(exchange.getExchangeId());
            }
            throw e;
        }
        if (!asynchronous) {
            boolean txSync;
            String selector = useSelector ? MSG_SELECTOR_START + sendJmsMsg.getJMSCorrelationID() + MSG_SELECTOR_END : null;
            Message receiveJmsMsg = this.receiveSelected(session, (Destination)replyDest, selector);
            if (receiveJmsMsg == null) {
                throw new IllegalStateException("Unable to receive response");
            }
            if (receiveJmsMsg.getBooleanProperty("JBIDone")) {
                exchange.setStatus(ExchangeStatus.DONE);
            } else if (receiveJmsMsg.getBooleanProperty("JBIError")) {
                Exception e = (Exception)((ObjectMessage)receiveJmsMsg).getObject();
                exchange.setError(e);
                exchange.setStatus(ExchangeStatus.ERROR);
            } else if (receiveJmsMsg.getBooleanProperty("JBIFault")) {
                Fault fault = exchange.getFault();
                if (fault == null) {
                    fault = exchange.createFault();
                    exchange.setFault(fault);
                }
                this.marshaler.populateMessage(receiveJmsMsg, exchange, (NormalizedMessage)fault);
            } else {
                NormalizedMessage out = exchange.getMessage("out");
                if (out == null) {
                    out = exchange.createMessage();
                    exchange.setMessage(out, "out");
                }
                this.marshaler.populateMessage(receiveJmsMsg, exchange, out);
            }
            boolean bl = txSync = exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.sendSync(exchange);
            } else {
                this.send(exchange);
            }
        }
    }

    private void send(Session session, Destination dest, final Message message) throws JmsException {
        this.template.send(session, dest, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return message;
            }
        });
    }

    private Message receiveSelected(Session session, Destination dest, String messageSelector) throws JMSException {
        return this.template.receiveSelected(session, dest, messageSelector);
    }

    protected void onMessage(Message message) {
        InOut exchange = null;
        try {
            exchange = (InOut)this.store.load(message.getJMSCorrelationID());
            if (exchange == null) {
                throw new IllegalStateException("Could not find exchange " + message.getJMSCorrelationID());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to load exchange related to incoming JMS message " + message), (Throwable)e);
        }
        try {
            if (message.getBooleanProperty("JBIDone")) {
                exchange.setStatus(ExchangeStatus.DONE);
            } else if (message.getBooleanProperty("JBIError")) {
                e = (Exception)((ObjectMessage)message).getObject();
                exchange.setError(e);
                exchange.setStatus(ExchangeStatus.ERROR);
            } else if (message.getBooleanProperty("JBIFault")) {
                Fault fault = exchange.getFault();
                if (fault == null) {
                    fault = exchange.createFault();
                    exchange.setFault(fault);
                }
                this.marshaler.populateMessage(message, (MessageExchange)exchange, (NormalizedMessage)fault);
            } else {
                NormalizedMessage out = exchange.getMessage("out");
                if (out == null) {
                    out = exchange.createMessage();
                    exchange.setMessage(out, "out");
                }
                this.marshaler.populateMessage(message, (MessageExchange)exchange, out);
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Error while populating JBI exchange " + exchange), (Throwable)e);
            }
            exchange.setError(e);
        }
        try {
            boolean txSync;
            boolean bl = txSync = exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.sendSync((MessageExchange)exchange);
            } else {
                this.send((MessageExchange)exchange);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to send JBI exchange " + exchange), (Throwable)e);
        }
    }

    protected Destination getDestination(MessageExchange exchange, Object message, Session session) throws JMSException {
        Destination dest = this.chooseDestination(exchange, message, session, this.destinationChooser, this.destination != null ? this.destination : this.destinationName);
        if (dest == null) {
            throw new IllegalStateException("Unable to choose a destination for exchange " + exchange);
        }
        return dest;
    }

    protected Destination chooseDestination(MessageExchange exchange, Object message, Session session, DestinationChooser chooser, Object defaultDestination) throws JMSException {
        Object dest = null;
        if (chooser != null) {
            dest = chooser.chooseDestination(exchange, message);
        }
        if (dest == null) {
            dest = defaultDestination;
        }
        if (dest instanceof Destination) {
            return (Destination)dest;
        }
        if (dest instanceof String) {
            return this.destinationResolver.resolveDestinationName(session, (String)dest, this.isPubSubDomain());
        }
        return null;
    }

    public synchronized void activate() throws Exception {
        super.activate();
        if (this.store == null) {
            if (this.storeFactory == null) {
                this.storeFactory = new MemoryStoreFactory();
            }
            this.store = this.storeFactory.open(this.getService().toString() + this.getEndpoint());
        }
        this.template = this.createTemplate();
    }

    protected synchronized void createAndStartListener() throws Exception {
        if (this.listenerContainer == null) {
            this.listenerContainer = this.createListenerContainer();
            this.listenerContainer.start();
        }
    }

    public synchronized void deactivate() throws Exception {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
            this.listenerContainer.shutdown();
            this.listenerContainer = null;
        }
        if (this.store != null) {
            if (this.storeFactory != null) {
                this.storeFactory.close(this.store);
            }
            this.store = null;
        }
        super.deactivate();
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.getService() == null) {
            throw new DeploymentException("service must be set");
        }
        if (this.getEndpoint() == null) {
            throw new DeploymentException("endpoint must be set");
        }
        if (this.getConnectionFactory() == null) {
            throw new DeploymentException("connectionFactory is required");
        }
    }

    protected JmsTemplateUtil createTemplate() {
        JmsTemplateUtil tplt = this.isJms102() ? new JmsTemplate102Util() : new JmsTemplateUtil();
        tplt.setConnectionFactory(this.getConnectionFactory());
        if (this.getDestination() != null) {
            tplt.setDefaultDestination(this.getDestination());
        } else if (this.getDestinationName() != null) {
            tplt.setDefaultDestinationName(this.getDestinationName());
        }
        tplt.setDeliveryMode(this.getDeliveryMode());
        if (this.getDestinationResolver() != null) {
            tplt.setDestinationResolver(this.getDestinationResolver());
        }
        tplt.setExplicitQosEnabled(this.isExplicitQosEnabled());
        tplt.setMessageIdEnabled(this.isMessageIdEnabled());
        tplt.setMessageTimestampEnabled(this.isMessageTimestampEnabled());
        tplt.setPriority(this.getPriority());
        tplt.setPubSubDomain(this.isPubSubDomain());
        tplt.setPubSubNoLocal(this.isPubSubNoLocal());
        tplt.setTimeToLive(this.getTimeToLive());
        tplt.setReceiveTimeout(this.getReceiveTimeout());
        tplt.afterPropertiesSet();
        return tplt;
    }

    protected AbstractMessageListenerContainer createListenerContainer() {
        Object cont = this.isJms102() ? new DefaultMessageListenerContainer102() : new DefaultMessageListenerContainer();
        cont.setConnectionFactory(this.getConnectionFactory());
        if (this.replyDestination != null) {
            cont.setDestination(this.replyDestination);
        }
        if (this.replyDestinationName != null) {
            cont.setDestinationName(this.replyDestinationName);
        }
        cont.setPubSubDomain(this.isPubSubDomain());
        cont.setPubSubNoLocal(this.isPubSubNoLocal());
        cont.setMessageListener((Object)new MessageListener(){

            public void onMessage(Message message) {
                JmsProviderEndpoint.this.onMessage(message);
            }
        });
        cont.setAutoStartup(false);
        cont.afterPropertiesSet();
        return cont;
    }

    public static class JmsTemplate102Util
    extends JmsTemplateUtil {
        protected void initDefaultStrategies() {
            this.setMessageConverter((MessageConverter)new SimpleMessageConverter102());
        }

        public void afterPropertiesSet() {
            super.afterPropertiesSet();
            if (this.isPubSubDomain()) {
                if (!(this.getConnectionFactory() instanceof TopicConnectionFactory)) {
                    throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 template for topics but did not supply an instance of TopicConnectionFactory");
                }
            } else if (!(this.getConnectionFactory() instanceof QueueConnectionFactory)) {
                throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 template for queues but did not supply an instance of QueueConnectionFactory");
            }
        }

        protected Connection getConnection(JmsResourceHolder holder) {
            return holder.getConnection(this.isPubSubDomain() ? TopicConnection.class : QueueConnection.class);
        }

        protected Session getSession(JmsResourceHolder holder) {
            return holder.getSession(this.isPubSubDomain() ? TopicSession.class : QueueSession.class);
        }

        protected Connection createConnection() throws JMSException {
            if (this.isPubSubDomain()) {
                return ((TopicConnectionFactory)this.getConnectionFactory()).createTopicConnection();
            }
            return ((QueueConnectionFactory)this.getConnectionFactory()).createQueueConnection();
        }

        protected Session createSession(Connection con) throws JMSException {
            if (this.isPubSubDomain()) {
                return ((TopicConnection)con).createTopicSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
            }
            return ((QueueConnection)con).createQueueSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
        }

        protected MessageProducer doCreateProducer(Session session, Destination destination) throws JMSException {
            if (this.isPubSubDomain()) {
                return ((TopicSession)session).createPublisher((Topic)destination);
            }
            return ((QueueSession)session).createSender((Queue)destination);
        }

        protected MessageConsumer createConsumer(Session session, Destination destination, String messageSelector) throws JMSException {
            if (this.isPubSubDomain()) {
                return ((TopicSession)session).createSubscriber((Topic)destination, messageSelector, this.isPubSubNoLocal());
            }
            return ((QueueSession)session).createReceiver((Queue)destination, messageSelector);
        }

        protected QueueBrowser createBrowser(Session session, Queue queue, String messageSelector) throws JMSException {
            if (this.isPubSubDomain()) {
                throw new javax.jms.IllegalStateException("Cannot create QueueBrowser for a TopicSession");
            }
            return ((QueueSession)session).createBrowser(queue, messageSelector);
        }

        protected void doSend(MessageProducer producer, Message message) throws JMSException {
            if (this.isPubSubDomain()) {
                if (this.isExplicitQosEnabled()) {
                    ((TopicPublisher)producer).publish(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
                } else {
                    ((TopicPublisher)producer).publish(message);
                }
            } else if (this.isExplicitQosEnabled()) {
                ((QueueSender)producer).send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
            } else {
                ((QueueSender)producer).send(message);
            }
        }

        protected boolean isClientAcknowledge(Session session) throws JMSException {
            return this.getSessionAcknowledgeMode() == 2;
        }
    }

    public static class JmsTemplateUtil
    extends JmsTemplate {
        public void send(Session session, Destination destination, MessageCreator messageCreator) throws JmsException {
            try {
                this.doSend(session, destination, messageCreator);
            }
            catch (JMSException ex) {
                throw this.convertJmsAccessException(ex);
            }
        }

        public Message receiveSelected(Session session, Destination destination, String messageSelector) throws JmsException {
            try {
                return this.doReceive(session, destination, messageSelector);
            }
            catch (JMSException ex) {
                throw this.convertJmsAccessException(ex);
            }
        }
    }
}

