/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.servicemix.jms.endpoints.JmsProviderMarshaler;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.InterceptorProvider;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.Policy;
import org.apache.servicemix.soap.api.model.Binding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsSoapProviderMarshaler
implements JmsProviderMarshaler {
    private Binding<?> binding;
    private boolean useJbiWrapper = true;
    private Policy[] policies;
    private String baseUrl;

    public Binding<?> getBinding() {
        return this.binding;
    }

    public void setBinding(Binding<?> binding) {
        this.binding = binding;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isUseJbiWrapper() {
        return this.useJbiWrapper;
    }

    public void setUseJbiWrapper(boolean useJbiWrapper) {
        this.useJbiWrapper = useJbiWrapper;
    }

    public Policy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(Policy[] policies) {
        this.policies = policies;
    }

    @Override
    public javax.jms.Message createMessage(MessageExchange exchange, NormalizedMessage in, Session session) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Message msg = this.binding.createMessage();
        exchange.setProperty(Message.class.getName(), null);
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(NormalizedMessage.class, (Object)in);
        msg.setContent(OutputStream.class, (Object)baos);
        exchange.setProperty(javax.jms.Message.class.getName(), (Object)msg);
        InterceptorChain phaseOut = this.getChain(InterceptorProvider.Phase.ClientOut);
        phaseOut.doIntercept(msg);
        TextMessage jmsMessage = session.createTextMessage();
        jmsMessage.setText(baos.toString());
        return jmsMessage;
    }

    @Override
    public void populateMessage(javax.jms.Message message, MessageExchange exchange, NormalizedMessage normalizedMessage) throws Exception {
        Message req = (Message)exchange.getProperty(javax.jms.Message.class.getName());
        exchange.setProperty(Message.class.getName(), null);
        Message msg = this.binding.createMessage(req);
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(NormalizedMessage.class, (Object)normalizedMessage);
        String str = ((TextMessage)message).getText();
        msg.setContent(InputStream.class, (Object)new ByteArrayInputStream(str.getBytes()));
        InterceptorChain phaseIn = this.getChain(InterceptorProvider.Phase.ClientIn);
        phaseIn.doIntercept(msg);
    }

    protected InterceptorChain getChain(InterceptorProvider.Phase phase) {
        InterceptorChain chain = this.binding.getInterceptorChain(phase);
        if (this.policies != null) {
            for (int i = 0; i < this.policies.length; ++i) {
                chain.add((Iterable)this.policies[i].getInterceptors(phase));
            }
        }
        return chain;
    }
}

