/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.util.QNameUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiOutWsdl1Interceptor
extends AbstractSoapInterceptor {
    private boolean useJBIWrapper = true;

    public JbiOutWsdl1Interceptor(boolean useJBIWrapper) {
        super("marshal");
        this.useJBIWrapper = useJBIWrapper;
    }

    public void handleMessage(SoapMessage message) {
        try {
            Source source = (Source)message.getContent(Source.class);
            if (source == null) {
                return;
            }
            Element element = new SourceTransformer().toDOMElement(source);
            XMLStreamWriter xmlWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            if (!this.useJBIWrapper) {
                SoapVersion soapVersion = message.getVersion();
                if (element != null) {
                    Element bodyElement = (Element)element.getElementsByTagNameNS(element.getNamespaceURI(), soapVersion.getBody().getLocalPart()).item(0);
                    if (bodyElement != null) {
                        StaxUtils.writeElement((Element)((Element)bodyElement.getFirstChild()), (XMLStreamWriter)xmlWriter, (boolean)false);
                    } else {
                        StaxUtils.writeElement((Element)element, (XMLStreamWriter)xmlWriter, (boolean)false);
                    }
                }
                return;
            }
            if (!"http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper".equals(element.getNamespaceURI()) || !"message".equals(element.getLocalName())) {
                throw new Fault((Throwable)new Exception("Message wrapper element is '" + QNameUtil.toString((Element)element) + "' but expected '{" + "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper" + "}message'"));
            }
            List<Attr> nsList = this.saveLaterUsedNS(element);
            for (Attr attr : nsList) {
                xmlWriter.writeAttribute(attr.getName(), attr.getValue());
            }
            BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
            if (bop == null) {
                throw new Fault((Throwable)new Exception("Operation not bound on this message"));
            }
            BindingMessageInfo msg = this.isRequestor((Message)message) ? bop.getInput() : bop.getOutput();
            SoapBindingInfo binding = (SoapBindingInfo)((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().getBinding();
            String style = binding.getStyle(bop.getOperationInfo());
            if (style == null) {
                style = binding.getStyle();
            }
            if ("rpc".equals(style)) {
                this.addOperationNode((Message)message, xmlWriter);
                this.getRPCPartWrapper(msg, element, message, xmlWriter);
            } else {
                Element partWrapper = DomUtil.getFirstChildElement((Node)element);
                while (partWrapper != null) {
                    List<NodeList> partsContent = this.getPartsContent(message, element, partWrapper, msg);
                    for (NodeList nl : partsContent) {
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Node n = nl.item(i);
                            StaxUtils.writeNode((Node)n, (XMLStreamWriter)xmlWriter, (boolean)false);
                        }
                    }
                    partWrapper = DomUtil.getNextSiblingElement((Element)partWrapper);
                }
            }
            if ("rpc".equals(style)) {
                xmlWriter.writeEndElement();
            }
        }
        catch (Fault e) {
            throw e;
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private List<Attr> saveLaterUsedNS(Element element) {
        ArrayList<Attr> nsList = new ArrayList<Attr>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr;
            if (!(attributes.item(i) instanceof Attr) || !(attr = (Attr)attributes.item(i)).getName().startsWith("xmlns:") || attr.getName().startsWith("xmlns:msg") || attr.getName().startsWith("xmlns:jbi")) continue;
            nsList.add(attr);
        }
        return nsList;
    }

    private void getRPCPartWrapper(BindingMessageInfo msg, Element element, SoapMessage message, XMLStreamWriter xmlWriter) {
        try {
            List parts = msg.getMessageParts();
            Iterator iter = parts.iterator();
            Element partWrapper = DomUtil.getFirstChildElement((Node)element);
            while (partWrapper != null) {
                MessagePartInfo msgPart = (MessagePartInfo)iter.next();
                String prefix = msgPart.getName().getPrefix();
                String name = msgPart.getName().getLocalPart();
                StaxUtils.writeStartElement((XMLStreamWriter)xmlWriter, (String)prefix, (String)name, (String)"");
                List<NodeList> partsContent = this.getPartsContent(message, element, partWrapper, msg);
                for (NodeList nl : partsContent) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node n = nl.item(i);
                        StaxUtils.writeNode((Node)n, (XMLStreamWriter)xmlWriter, (boolean)false);
                    }
                }
                xmlWriter.writeEndElement();
                partWrapper = DomUtil.getNextSiblingElement((Element)partWrapper);
            }
        }
        catch (Fault e) {
            throw e;
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private List<NodeList> getPartsContent(SoapMessage message, Element element, Element partWrapper, BindingMessageInfo msg) {
        ArrayList<NodeList> partsContent = new ArrayList<NodeList>();
        if (partWrapper != null) {
            if (!"http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper".equals(element.getNamespaceURI()) || !"part".equals(partWrapper.getLocalName())) {
                throw new Fault((Throwable)new Exception("Unexpected part wrapper element '" + QNameUtil.toString((Element)element) + "' expected '{" + "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper" + "}part'"));
            }
            NodeList nodes = partWrapper.getChildNodes();
            partsContent.add(nodes);
        }
        List headerList = message.getHeaders();
        List headers = msg.getExtensors(SoapHeaderInfo.class);
        for (SoapHeaderInfo header : headers) {
            NodeList nl = (NodeList)partsContent.get(0);
            if (!header.getPart().getConcreteName().getNamespaceURI().equals(nl.item(0).getNamespaceURI()) || !header.getPart().getConcreteName().getLocalPart().equals(nl.item(0).getLocalName())) continue;
            headerList.add(new Header(header.getPart().getConcreteName(), (Object)nl.item(0)));
            partsContent.remove(0);
        }
        return partsContent;
    }

    protected String addOperationNode(Message message, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String responseSuffix = !this.isRequestor(message) ? "Response" : "";
        BindingOperationInfo boi = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        String ns = boi.getName().getNamespaceURI();
        NSStack nsStack = new NSStack();
        nsStack.push();
        nsStack.add(ns);
        String prefix = nsStack.getPrefix(ns);
        StaxUtils.writeStartElement((XMLStreamWriter)xmlWriter, (String)prefix, (String)(boi.getName().getLocalPart() + responseSuffix), (String)ns);
        return ns;
    }
}

