/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrievePayLoadInterceptor
extends AbstractPhaseInterceptor<Message> {
    public RetrievePayLoadInterceptor() {
        super("post-stream");
    }

    public void handleMessage(Message message) throws Fault {
        InputStream is = (InputStream)message.getContent(InputStream.class);
        XMLStreamReader xmlReader = null;
        if (is != null) {
            StreamSource bodySource = new StreamSource((InputStream)message.getContent(InputStream.class));
            xmlReader = StaxUtils.createXMLStreamReader((Source)bodySource);
            this.findBody(message, xmlReader);
            message.setContent(XMLStreamReader.class, (Object)xmlReader);
        }
    }

    private void findBody(Message message, XMLStreamReader xmlReader) {
        DepthXMLStreamReader reader = new DepthXMLStreamReader(xmlReader);
        try {
            int depth = reader.getDepth();
            int event = reader.getEventType();
            while (reader.getDepth() >= depth && reader.hasNext()) {
                QName name = null;
                if (event == 1) {
                    name = reader.getName();
                }
                if (event == 1 && name.equals(((SoapMessage)message).getVersion().getBody())) {
                    reader.nextTag();
                    return;
                }
                event = reader.next();
            }
            return;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }
}

